/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=ProjectHelper.class)
public class ProjectHelper {
    @Requirement
    private MojoDescriptorCreator mojoDescriptorCreator;
    private Map<String, Plugin> cliPlugins = new ConcurrentHashMap<String, Plugin>();

    public List<Plugin> getPlugins(MavenProject project, MavenSession mavenSession) {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>(project.getBuildPlugins());
        for (String goal : mavenSession.getGoals()) {
            Plugin plugin;
            if (goal.indexOf(58) < 0 || (plugin = this.cliPlugins.computeIfAbsent(goal, cli -> {
                try {
                    MojoDescriptor mojoDescriptor = this.mojoDescriptorCreator.getMojoDescriptor(goal, mavenSession, project);
                    PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
                    Plugin p = pluginDescriptor.getPlugin();
                    PluginExecution execution = new PluginExecution();
                    execution.setId("default-cli");
                    execution.addGoal(mojoDescriptor.getGoal());
                    p.addExecution(execution);
                    return p;
                }
                catch (Exception e) {
                    return null;
                }
            })) == null) continue;
            plugins.add(plugin);
        }
        return plugins;
    }

    public boolean hasPluginExecution(String pluginGroupId, String pluginArtifactId, String goal, MavenProject project, MavenSession mavenSession) {
        MavenSession clone = mavenSession.clone();
        clone.setCurrentProject(project);
        List<Plugin> plugins = this.getPlugins(project, clone);
        for (Plugin plugin : plugins) {
            if (!plugin.getGroupId().equals(pluginGroupId) || !plugin.getArtifactId().equals(pluginArtifactId)) continue;
            for (PluginExecution execution : plugin.getExecutions()) {
                if (!execution.getGoals().contains(goal)) continue;
                return true;
            }
        }
        return false;
    }

    public Xpp3Dom getPluginConfiguration(String pluginGroupId, String pluginArtifactId, String goal, MavenProject project, MavenSession mavenSession) {
        MavenSession clone = mavenSession.clone();
        clone.setCurrentProject(project);
        List<Plugin> plugins = this.getPlugins(project, clone);
        for (Plugin plugin : plugins) {
            if (!plugin.getGroupId().equals(pluginGroupId) || !plugin.getArtifactId().equals(pluginArtifactId)) continue;
            if (goal == null) {
                return (Xpp3Dom)plugin.getConfiguration();
            }
            for (PluginExecution execution : plugin.getExecutions()) {
                if (!execution.getGoals().contains(goal)) continue;
                return (Xpp3Dom)execution.getConfiguration();
            }
        }
        return null;
    }
}

