/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.version;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class TychoVersion {
    private static final String TYCHO_VERSION = TychoVersion.readVersion("version");
    private static final String TYCHO_SCM = TychoVersion.readVersion("scm");
    private static final String BND_VERSION = TychoVersion.readVersion("bnd");
    private static Properties PROPERTIES;

    public static String getTychoVersion() {
        return TYCHO_VERSION;
    }

    public static String getBndVersion() {
        return BND_VERSION;
    }

    public static String getSCMInfo() {
        if ("${env.GIT_COMMIT}".equals(TYCHO_SCM)) {
            return "local build";
        }
        return TYCHO_SCM;
    }

    private static synchronized String readVersion(String version) {
        if (PROPERTIES == null) {
            try (InputStream stream = TychoVersion.class.getResourceAsStream("version.properties");){
                PROPERTIES = new Properties();
                PROPERTIES.load(stream);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return PROPERTIES.getProperty(version);
    }
}

