/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.helper;

import java.util.Optional;
import org.apache.maven.execution.MojoExecutionEvent;
import org.apache.maven.execution.MojoExecutionListener;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=MojoExecutionListener.class, hint="helper")
public class MojoExecutionHelper
implements MojoExecutionListener {
    private static boolean printMemoryInfo = Boolean.getBoolean("tycho.printMemory");
    private static boolean gc = Boolean.getBoolean("tycho.printMemory.gc");
    private static final ThreadLocal<MojoExecutionEvent> EVENT = new ThreadLocal();
    @Requirement
    private Logger logger;

    public void beforeMojoExecution(MojoExecutionEvent event) throws MojoExecutionException {
        EVENT.set(event);
        if (printMemoryInfo) {
            this.printMemory("Before", gc, event);
        }
    }

    public void afterMojoExecutionSuccess(MojoExecutionEvent event) throws MojoExecutionException {
        EVENT.remove();
        if (printMemoryInfo) {
            this.printMemory("After", gc, event);
        }
    }

    public void afterExecutionFailure(MojoExecutionEvent event) {
        EVENT.remove();
        if (printMemoryInfo) {
            this.printMemory("After", gc, event);
        }
    }

    public static Optional<MojoExecution> getExecution() {
        MojoExecutionEvent executionEvent = EVENT.get();
        if (executionEvent == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(executionEvent.getExecution());
    }

    private void printMemory(String state, boolean gc, MojoExecutionEvent evt) {
        double usedBefore;
        Runtime runtime = Runtime.getRuntime();
        if (gc) {
            usedBefore = (runtime.totalMemory() - runtime.freeMemory()) / 1024L / 1024L;
            System.gc();
        } else {
            usedBefore = 0.0;
        }
        double totalMemory = runtime.totalMemory() / 1024L / 1024L;
        double freeMemory = runtime.freeMemory() / 1024L / 1024L;
        double usedMemory = totalMemory - freeMemory;
        StringBuilder builder = new StringBuilder();
        builder.append("---- ");
        builder.append(state);
        builder.append(" ");
        builder.append(evt.getProject().getId());
        builder.append(" - ");
        MojoExecution execution = evt.getExecution();
        builder.append(execution.getMojoDescriptor().getId());
        builder.append(" [");
        builder.append(execution.getExecutionId());
        builder.append("] ----");
        builder.append(System.lineSeparator());
        builder.append("Total Memory: ");
        builder.append(String.format("%.2f", totalMemory));
        builder.append("mb");
        builder.append(System.lineSeparator());
        builder.append("Free Memory:  ");
        builder.append(String.format("%.2f", freeMemory));
        builder.append("mb");
        builder.append(System.lineSeparator());
        builder.append("Used Memory:  ");
        builder.append(String.format("%.2f", usedMemory));
        builder.append("mb");
        builder.append(System.lineSeparator());
        double reclaimed = usedBefore - usedMemory;
        if (reclaimed > 0.0) {
            builder.append("GC Reclaimed: ");
            builder.append(String.format("%.2f", reclaimed));
            builder.append("mb");
            builder.append(System.lineSeparator());
        }
        this.logger.info(builder.toString());
    }
}

