/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.surefire.util.DirectoryScanner;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.surefire.booter.PropertiesWrapper;
import org.apache.maven.surefire.testset.TestListResolver;
import org.apache.maven.surefire.util.DefaultScanResult;
import org.apache.maven.surefire.util.ScanResult;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.eclipse.sisu.equinox.launching.BundleStartLevel;
import org.eclipse.sisu.equinox.launching.DefaultEquinoxInstallationDescription;
import org.eclipse.sisu.equinox.launching.EquinoxInstallation;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationDescription;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationFactory;
import org.eclipse.sisu.equinox.launching.EquinoxLauncher;
import org.eclipse.sisu.equinox.launching.internal.EquinoxLaunchConfiguration;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.core.BundleProject;
import org.eclipse.tycho.core.DependencyResolver;
import org.eclipse.tycho.core.DependencyResolverConfiguration;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.core.maven.ToolchainProvider;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.OsgiBundleProject;
import org.eclipse.tycho.core.osgitools.project.BuildOutputJar;
import org.eclipse.tycho.core.resolver.DefaultDependencyResolverFactory;
import org.eclipse.tycho.core.resolver.shared.OptionalResolutionAction;
import org.eclipse.tycho.core.resolver.shared.PlatformPropertiesUtils;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.dev.DevBundleInfo;
import org.eclipse.tycho.dev.DevWorkspaceResolver;
import org.eclipse.tycho.launching.LaunchConfiguration;
import org.eclipse.tycho.p2.facade.RepositoryReferenceTool;
import org.eclipse.tycho.p2.tools.RepositoryReferences;
import org.eclipse.tycho.surefire.ParallelMode;
import org.eclipse.tycho.surefire.provider.impl.ProviderHelper;
import org.eclipse.tycho.surefire.provider.spi.TestFrameworkProvider;
import org.eclipse.tycho.surefire.provisioning.ProvisionedInstallationBuilder;
import org.eclipse.tycho.surefire.provisioning.ProvisionedInstallationBuilderFactory;
import org.osgi.framework.Version;

@Mojo(name="test", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class TestMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/work")
    private File work;
    @Parameter(defaultValue="${project.build.directory}/work/data/")
    private File osgiDataDirectory;
    @Parameter(defaultValue="true")
    private boolean deleteOsgiDataDirectory;
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter(property="debugPort")
    private int debugPort;
    @Parameter
    private List<String> includes;
    @Parameter
    private List<String> excludes;
    @Parameter(property="test")
    private String test;
    @Deprecated
    @Parameter(property="maven.test.skipExec")
    private boolean skipExec;
    @Parameter(property="skipTests")
    private Boolean skipTests;
    @Parameter(property="maven.test.skip")
    private Boolean skip;
    @Parameter(property="failIfNoTests", defaultValue="true")
    private boolean failIfNoTests;
    @Parameter(property="groups")
    private String groups;
    @Parameter(property="excludedGroups")
    private String excludedGroups;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    private boolean testFailureIgnore;
    @Parameter(property="project.build.outputDirectory")
    private File testClassesDirectory;
    @Parameter(property="tycho.showEclipseLog", defaultValue="false")
    private boolean showEclipseLog;
    @Parameter(property="maven.test.redirectTestOutputToFile", defaultValue="false")
    private boolean redirectTestOutputToFile;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports")
    private File reportsDirectory;
    @Parameter(defaultValue="${project.build.directory}/surefire.properties")
    private File surefireProperties;
    @Parameter
    private Dependency[] dependencies;
    @Parameter
    private String application;
    @Parameter
    private String product;
    @Parameter(property="session", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="false")
    private boolean useUIHarness;
    @Parameter(defaultValue="true")
    private boolean useUIThread;
    @Parameter(property="enableAssertions", defaultValue="false")
    private boolean enableAssertions;
    @Parameter(property="plugin.artifacts")
    private List<Artifact> pluginArtifacts;
    @Parameter(property="tycho.testArgLine")
    private String argLine;
    @Parameter
    private String appArgLine;
    @Parameter(property="surefire.timeout")
    private int forkedProcessTimeoutInSeconds;
    @Parameter(property="testClass")
    private String testClass;
    @Parameter
    private Map<String, String> environmentVariables;
    @Parameter
    private Map<String, String> systemProperties;
    @Parameter
    private String[] explodedBundles;
    @Parameter
    private Dependency[] frameworkExtensions;
    @Parameter
    private BundleStartLevel[] bundleStartLevel;
    @Parameter
    private BundleStartLevel defaultStartLevel;
    @Parameter(property="surefire.rerunFailingTestsCount", defaultValue="0")
    private Integer rerunFailingTestsCount;
    @Parameter(property="surefire.skipAfterFailureCount", defaultValue="0")
    private Integer skipAfterFailureCount;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ResolutionErrorHandler resolutionErrorHandler;
    @Component
    private DefaultDependencyResolverFactory dependencyResolverLocator;
    @Component(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;
    @Component
    private EquinoxInstallationFactory installationFactory;
    @Component
    private ProvisionedInstallationBuilderFactory provisionedInstallationBuilderFactory;
    @Component
    private EquinoxLauncher launcher;
    @Component(role=TychoProject.class, hint="eclipse-plugin")
    private OsgiBundleProject osgiBundle;
    @Parameter
    private String providerHint;
    @Parameter(defaultValue="filesystem")
    private String runOrder;
    @Parameter(property="trimStackTrace", defaultValue="true")
    private boolean trimStackTrace;
    @Parameter(property="parallel")
    private ParallelMode parallel;
    @Parameter(property="perCoreThreadCount", defaultValue="true")
    private boolean perCoreThreadCount;
    @Parameter(property="threadCount")
    private int threadCount = -1;
    @Parameter(property="useUnlimitedThreads", defaultValue="false")
    private boolean useUnlimitedThreads;
    @Parameter
    private Properties providerProperties = new Properties();
    @Parameter(defaultValue="default")
    private String testRuntime;
    @Parameter(defaultValue="DefaultProfile")
    private String profileName;
    @Component
    private ToolchainManager toolchainManager;
    @Component
    private ProviderHelper providerHelper;
    @Component
    private DevWorkspaceResolver workspaceState;
    @Component
    private RepositoryReferenceTool repositoryReferenceTool;
    @Component
    private ToolchainProvider toolchainProvider;
    @Parameter(defaultValue="SYSTEM")
    private ToolchainProvider.JDKUsage useJDK;
    @Parameter
    private List<String> suiteXmlFiles;

    public void execute() throws MojoExecutionException, MojoFailureException {
        EquinoxInstallation equinoxTestRuntime;
        if (this.shouldSkip()) {
            this.getLog().info((CharSequence)"Skipping tests");
            return;
        }
        if (!"eclipse-test-plugin".equals(this.project.getPackaging())) {
            this.getLog().warn((CharSequence)("Unsupported packaging type " + this.project.getPackaging()));
            return;
        }
        if ("p2Installed".equals(this.testRuntime)) {
            equinoxTestRuntime = this.createProvisionedInstallation();
        } else if ("default".equals(this.testRuntime)) {
            equinoxTestRuntime = this.createEclipseInstallation();
        } else {
            throw new MojoExecutionException("Configured testRuntime parameter value '" + this.testRuntime + "' is unkown. Allowed values: 'default', 'p2Installed'.");
        }
        this.runTest(equinoxTestRuntime);
    }

    protected boolean shouldSkip() {
        if (this.skip != null && this.skipTests != null && !this.skip.equals(this.skipTests)) {
            this.getLog().warn((CharSequence)"Both parameter 'skipTests' and 'maven.test.skip' are set, 'skipTests' has a higher priority!");
        }
        if (this.skipTests != null) {
            return this.skipTests;
        }
        if (this.skip != null) {
            return this.skip;
        }
        return this.skipExec;
    }

    private ReactorProject getReactorProject() {
        return DefaultReactorProject.adapt((MavenProject)this.project);
    }

    private List<ReactorProject> getReactorProjects() {
        return DefaultReactorProject.adapt((MavenSession)this.session);
    }

    private EquinoxInstallation createProvisionedInstallation() throws MojoExecutionException {
        try {
            TestFrameworkProvider provider = this.providerHelper.selectProvider(this.getProjectType().getClasspath(this.project), this.getMergedProviderProperties(), this.providerHint);
            this.createSurefireProperties(provider);
            ProvisionedInstallationBuilder installationBuilder = this.provisionedInstallationBuilderFactory.createInstallationBuilder();
            Set<Artifact> testHarnessArtifacts = this.providerHelper.filterTestFrameworkBundles(provider, this.pluginArtifacts);
            for (Artifact testHarnessArtifact : testHarnessArtifacts) {
                installationBuilder.addBundleJar(testHarnessArtifact.getFile());
            }
            RepositoryReferences sources = this.repositoryReferenceTool.getVisibleRepositories(this.project, this.session, RepositoryReferenceTool.REPOSITORIES_INCLUDE_CURRENT_MODULE);
            installationBuilder.addMetadataRepositories(sources.getMetadataRepositories());
            installationBuilder.addArtifactRepositories(sources.getArtifactRepositories());
            installationBuilder.setProfileName(this.profileName);
            installationBuilder.addIUsToBeInstalled(this.getIUsToInstall(testHarnessArtifacts));
            File workingDir = new File(this.project.getBuild().getDirectory(), "p2temp");
            workingDir.mkdirs();
            installationBuilder.setWorkingDir(workingDir);
            installationBuilder.setDestination(this.work);
            return installationBuilder.install();
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    private List<String> getIUsToInstall(Set<Artifact> testHarnessArtifacts) {
        ArrayList<String> iusToInstall = new ArrayList<String>();
        iusToInstall.add(this.getTestBundleSymbolicName());
        iusToInstall.addAll(this.providerHelper.getSymbolicNames(testHarnessArtifacts));
        for (Dependency extraDependency : TychoProjectUtils.getTargetPlatformConfiguration((MavenProject)this.project).getDependencyResolverConfiguration().getExtraRequirements()) {
            String type = extraDependency.getType();
            if ("eclipse-plugin".equals(type) || "p2-installable-unit".equals(type)) {
                iusToInstall.add(extraDependency.getArtifactId());
                continue;
            }
            if (!"eclipse-feature".equals(type)) continue;
            iusToInstall.add(extraDependency.getArtifactId() + ".feature.group");
        }
        return iusToInstall;
    }

    private BundleProject getProjectType() {
        return (BundleProject)this.projectTypes.get(this.project.getPackaging());
    }

    private EquinoxInstallation createEclipseInstallation() throws MojoExecutionException {
        DependencyResolverConfiguration resolverConfiguration;
        DependencyResolver platformResolver = this.dependencyResolverLocator.lookupDependencyResolver(this.project);
        final List<Dependency> extraDependencies = this.getExtraDependencies();
        List<ReactorProject> reactorProjects = this.getReactorProjects();
        DependencyArtifacts testRuntimeArtifacts = platformResolver.resolveDependencies(this.session, this.project, null, reactorProjects, resolverConfiguration = new DependencyResolverConfiguration(){

            public OptionalResolutionAction getOptionalResolutionAction() {
                return OptionalResolutionAction.IGNORE;
            }

            public List<Dependency> getExtraRequirements() {
                return extraDependencies;
            }
        });
        if (testRuntimeArtifacts == null) {
            throw new MojoExecutionException("Cannot determinate build target platform location -- not executing tests");
        }
        this.work.mkdirs();
        DefaultEquinoxInstallationDescription testRuntime = new DefaultEquinoxInstallationDescription();
        testRuntime.setDefaultBundleStartLevel(this.defaultStartLevel);
        testRuntime.addBundlesToExplode(this.getBundlesToExplode());
        testRuntime.addFrameworkExtensions(this.getFrameworkExtensions());
        if (this.bundleStartLevel != null) {
            for (BundleStartLevel level : this.bundleStartLevel) {
                testRuntime.addBundleStartLevel(level);
            }
        }
        TestFrameworkProvider provider = this.providerHelper.selectProvider(this.getProjectType().getClasspath(this.project), this.getMergedProviderProperties(), this.providerHint);
        this.createSurefireProperties(provider);
        for (ArtifactDescriptor artifact : testRuntimeArtifacts.getArtifacts("eclipse-plugin")) {
            ReactorProject otherProject = artifact.getMavenProject();
            if (otherProject != null) {
                if (otherProject.sameProject((Object)this.project)) {
                    testRuntime.addBundle(artifact.getKey(), this.project.getBasedir());
                    continue;
                }
                File file = otherProject.getArtifact(artifact.getClassifier());
                if (file != null) {
                    testRuntime.addBundle(artifact.getKey(), file);
                    continue;
                }
            }
            testRuntime.addBundle(artifact);
        }
        Set<Artifact> testFrameworkBundles = this.providerHelper.filterTestFrameworkBundles(provider, this.pluginArtifacts);
        for (Artifact artifact : testFrameworkBundles) {
            DevBundleInfo devInfo = this.workspaceState.getBundleInfo(this.session, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), this.project.getPluginArtifactRepositories());
            if (devInfo != null) {
                testRuntime.addBundle(devInfo.getArtifactKey(), devInfo.getLocation(), true);
                testRuntime.addDevEntries(devInfo.getSymbolicName(), devInfo.getDevEntries());
                continue;
            }
            File bundleLocation = artifact.getFile();
            ArtifactKey bundleArtifactKey = this.getBundleArtifactKey(bundleLocation);
            testRuntime.addBundle(bundleArtifactKey, bundleLocation, true);
        }
        testRuntime.addDevEntries(this.getTestBundleSymbolicName(), this.getBuildOutputDirectories());
        this.reportsDirectory.mkdirs();
        return this.installationFactory.createInstallation((EquinoxInstallationDescription)testRuntime, this.work);
    }

    private List<Dependency> getExtraDependencies() {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        if (this.dependencies != null) {
            dependencies.addAll(Arrays.asList(this.dependencies));
        }
        TargetPlatformConfiguration configuration = TychoProjectUtils.getTargetPlatformConfiguration((MavenProject)this.project);
        dependencies.addAll(configuration.getDependencyResolverConfiguration().getExtraRequirements());
        dependencies.addAll(this.getTestDependencies());
        return dependencies;
    }

    private String getTestBundleSymbolicName() {
        return this.getProjectType().getArtifactKey(this.getReactorProject()).getId();
    }

    private ArtifactKey getBundleArtifactKey(File file) throws MojoExecutionException {
        ArtifactKey key = this.osgiBundle.readArtifactKey(file);
        if (key == null) {
            throw new MojoExecutionException("Not an OSGi bundle " + file.getAbsolutePath());
        }
        return key;
    }

    private List<Dependency> getTestDependencies() {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        result.add(this.newBundleDependency("org.eclipse.osgi"));
        result.add(this.newBundleDependency("org.eclipse.equinox.launcher"));
        if (this.useUIHarness) {
            result.add(this.newBundleDependency("org.eclipse.ui.ide.application"));
        } else {
            result.add(this.newBundleDependency("org.eclipse.core.runtime"));
        }
        return result;
    }

    protected Dependency newBundleDependency(String bundleId) {
        Dependency ideapp = new Dependency();
        ideapp.setArtifactId(bundleId);
        ideapp.setType("eclipse-plugin");
        return ideapp;
    }

    private void createSurefireProperties(TestFrameworkProvider provider) throws MojoExecutionException {
        PropertiesWrapper wrapper = new PropertiesWrapper(new HashMap());
        wrapper.setProperty("testpluginname", this.getTestBundleSymbolicName());
        wrapper.setProperty("testclassesdirectory", this.testClassesDirectory.getAbsolutePath());
        wrapper.setProperty("reportsdirectory", this.reportsDirectory.getAbsolutePath());
        wrapper.setProperty("redirectTestOutputToFile", String.valueOf(this.redirectTestOutputToFile));
        wrapper.setProperty("failifnotests", String.valueOf(this.failIfNoTests));
        wrapper.setProperty("runOrder", this.runOrder);
        wrapper.setProperty("trimStackTrace", String.valueOf(this.trimStackTrace));
        wrapper.setProperty("skipAfterFailureCount", String.valueOf(this.skipAfterFailureCount));
        wrapper.setProperty("rerunFailingTestsCount", String.valueOf(this.rerunFailingTestsCount));
        Properties mergedProviderProperties = this.getMergedProviderProperties();
        mergedProviderProperties.putAll((Map<?, ?>)provider.getProviderSpecificProperties());
        ScanResult scanResult = this.scanForTests();
        Map<String, String> providerPropertiesAsMap = this.propertiesAsMap(mergedProviderProperties);
        scanResult.writeTo(providerPropertiesAsMap);
        for (Map.Entry<String, String> entry : providerPropertiesAsMap.entrySet()) {
            wrapper.setProperty("__provider." + entry.getKey(), entry.getValue().toString());
        }
        wrapper.setProperty("testprovider", provider.getSurefireProviderClassName());
        this.getLog().debug((CharSequence)("Using test framework provider " + provider.getClass().getName()));
        wrapper.addList(this.suiteXmlFiles, "testSuiteXmlFiles");
        this.storeProperties(wrapper.getProperties(), this.surefireProperties);
    }

    protected Properties getMergedProviderProperties() throws MojoExecutionException {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.providerProperties);
        if (this.parallel != null) {
            result.put("parallel", this.parallel.name());
            if (!this.useUnlimitedThreads) {
                if (this.perCoreThreadCount && this.threadCount < 1) {
                    throw new MojoExecutionException("Parallel mode with perCoreThreadCount=true requires threadCount>=1");
                }
                if (!this.perCoreThreadCount && this.threadCount <= 1) {
                    throw new MojoExecutionException("Parallel mode requires threadCount>1 or useUnlimitedThreads=true");
                }
            }
            if (this.threadCount > 0) {
                result.put("threadcount", String.valueOf(this.threadCount));
            }
            result.put("perCoreThreadCount", String.valueOf(this.perCoreThreadCount));
            result.put("useUnlimitedThreads", String.valueOf(this.useUnlimitedThreads));
        }
        if (this.groups != null) {
            result.put("groups", this.groups);
        }
        if (this.excludedGroups != null) {
            result.put("excludegroups", this.excludedGroups);
        }
        return result;
    }

    protected ScanResult scanForTests() {
        List<String> excludeList;
        List<String> includeList;
        List<String> defaultIncludes = Arrays.asList("**/Test*.class", "**/*Test.class", "**/*TestCase.class");
        List<String> defaultExcludes = Arrays.asList("**/*$*");
        if (this.test != null) {
            String test = this.test;
            test = (test = test.replace('.', '/')).endsWith(".class") ? test : test + ".class";
            test = test.startsWith("**/") ? test : "**/" + test;
            includeList = Collections.singletonList(test);
        } else if (this.testClass != null) {
            includeList = Collections.singletonList(this.testClass.replace('.', '/') + ".class");
        } else if (this.includes != null) {
            includeList = this.includes;
            includeList.removeAll(Collections.singleton(null));
        } else {
            includeList = defaultIncludes;
        }
        if (this.excludes != null) {
            excludeList = this.excludes;
            excludeList.removeAll(Collections.singleton(null));
        } else {
            excludeList = defaultExcludes;
        }
        TestListResolver resolver = new TestListResolver(includeList, excludeList);
        DirectoryScanner scanner = new DirectoryScanner(this.testClassesDirectory, resolver);
        DefaultScanResult scanResult = scanner.scan();
        return scanResult;
    }

    private void storeProperties(Map<String, String> propertiesMap, File file) throws MojoExecutionException {
        Properties p = new Properties();
        p.putAll(propertiesMap);
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            p.store(out, null);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't write test launcher properties file", (Exception)e);
        }
    }

    private void runTest(EquinoxInstallation testRuntime) throws MojoExecutionException, MojoFailureException {
        int result;
        try {
            if (this.deleteOsgiDataDirectory) {
                FileUtils.deleteDirectory((File)this.osgiDataDirectory);
            }
            LaunchConfiguration cli = this.createCommandLine(testRuntime);
            this.getLog().info((CharSequence)("Expected eclipse log file: " + new File(this.osgiDataDirectory, ".metadata/.log").getAbsolutePath()));
            result = this.launcher.execute(cli, this.forkedProcessTimeoutInSeconds);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while executing platform", e);
        }
        switch (result) {
            case 0: {
                this.getLog().info((CharSequence)"All tests passed!");
                break;
            }
            case 200: {
                if (this.application == null) {
                    throw new MojoExecutionException("Could not find the default application \"org.eclipse.ui.ide.workbench\" in the test runtime.");
                }
                throw new MojoFailureException("Could not find application \"" + this.application + "\" in the test runtime. Make sure that the test runtime includes the bundle which defines this application.");
            }
            case 254: {
                String message = "No tests found.";
                if (this.failIfNoTests) {
                    throw new MojoFailureException(message);
                }
                this.getLog().warn((CharSequence)message);
                break;
            }
            case 255: {
                String errorMessage = "There are test failures.\n\nPlease refer to " + this.reportsDirectory + " for the individual test results.";
                if (this.testFailureIgnore) {
                    this.getLog().error((CharSequence)errorMessage);
                    break;
                }
                throw new MojoFailureException(errorMessage);
            }
            default: {
                throw new MojoFailureException("An unexpected error occured while launching the test runtime (return code " + result + "). See log " + new File(this.osgiDataDirectory, ".metadata/.log").getAbsolutePath() + " for details.");
            }
        }
    }

    protected Toolchain getToolchain() throws MojoExecutionException {
        if (ToolchainProvider.JDKUsage.SYSTEM.equals((Object)this.useJDK)) {
            if (this.toolchainManager != null) {
                return this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
            }
            return null;
        }
        String profileName = TychoProjectUtils.getExecutionEnvironmentConfiguration((MavenProject)this.project).getProfileName();
        DefaultJavaToolChain toolChain = this.toolchainProvider.findMatchingJavaToolChain(this.session, profileName);
        if (toolChain == null) {
            throw new MojoExecutionException("useJDK = BREE configured, but no toolchain of type 'jdk' with id '" + profileName + "' found. See http://maven.apache.org/guides/mini/guide-using-toolchains.html");
        }
        return toolChain;
    }

    LaunchConfiguration createCommandLine(EquinoxInstallation testRuntime) throws MalformedURLException, MojoExecutionException {
        EquinoxLaunchConfiguration cli = new EquinoxLaunchConfiguration(testRuntime);
        String executable = null;
        Toolchain tc = this.getToolchain();
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in tycho-surefire-plugin: " + tc));
            executable = tc.findTool("java");
        }
        cli.setJvmExecutable(executable);
        cli.setWorkingDirectory(this.project.getBasedir());
        if (this.debugPort > 0) {
            cli.addVMArguments(new String[]{"-Xdebug", "-Xrunjdwp:transport=dt_socket,address=" + this.debugPort + ",server=y,suspend=y"});
        }
        cli.addVMArguments(new String[]{"-Dosgi.noShutdown=false"});
        Properties properties = (Properties)this.project.getContextValue(TychoConstants.CTX_MERGED_PROPERTIES);
        cli.addVMArguments(new String[]{"-Dosgi.os=" + PlatformPropertiesUtils.getOS((Properties)properties), "-Dosgi.ws=" + PlatformPropertiesUtils.getWS((Properties)properties), "-Dosgi.arch=" + PlatformPropertiesUtils.getArch((Properties)properties)});
        this.addCustomProfileArg(cli);
        cli.addVMArguments(this.splitArgLine(this.argLine));
        for (Map.Entry<String, String> entry : this.getMergedSystemProperties().entrySet()) {
            cli.addVMArguments(new String[]{"-D" + entry.getKey() + "=" + entry.getValue()});
        }
        if (this.getLog().isDebugEnabled() || this.showEclipseLog) {
            cli.addProgramArguments(new String[]{"-debug", "-consolelog"});
        }
        this.addProgramArgs(cli, "-data", this.osgiDataDirectory.getAbsolutePath(), "-install", testRuntime.getLocation().getAbsolutePath(), "-configuration", testRuntime.getConfigurationLocation().getAbsolutePath(), "-application", this.getTestApplication(testRuntime.getInstallationDescription()), "-testproperties", this.surefireProperties.getAbsolutePath());
        if (this.application != null) {
            cli.addProgramArguments(new String[]{"-testApplication", this.application});
        }
        if (this.product != null) {
            cli.addProgramArguments(new String[]{"-product", this.product});
        }
        if (this.useUIHarness && !this.useUIThread) {
            cli.addProgramArguments(new String[]{"-nouithread"});
        }
        cli.addProgramArguments(this.splitArgLine(this.appArgLine));
        if (this.environmentVariables != null) {
            cli.addEnvironmentVariables(this.environmentVariables);
        }
        if (this.enableAssertions) {
            cli.addVMArguments(new String[]{"-ea"});
        }
        return cli;
    }

    private Map<String, String> getMergedSystemProperties() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("osgi.clean", "true");
        if (this.systemProperties != null) {
            result.putAll(this.systemProperties);
        }
        return result;
    }

    private void addCustomProfileArg(EquinoxLaunchConfiguration cli) throws MojoExecutionException {
        ExecutionEnvironmentConfiguration eeConfig = TychoProjectUtils.getExecutionEnvironmentConfiguration((MavenProject)this.project);
        if (eeConfig.isCustomProfile()) {
            Properties customProfileProps = eeConfig.getFullSpecification().getProfileProperties();
            File profileFile = new File(new File(this.project.getBuild().getDirectory()), "custom.profile");
            this.storeProperties(this.propertiesAsMap(customProfileProps), profileFile);
            cli.addVMArguments(new String[]{"-Dosgi.java.profile=" + profileFile.toURI()});
        }
    }

    private Map<String, String> propertiesAsMap(Properties p) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String entry : p.stringPropertyNames()) {
            result.put(entry, p.getProperty(entry));
        }
        return result;
    }

    void addProgramArgs(EquinoxLaunchConfiguration cli, String ... arguments) {
        if (arguments != null) {
            for (String argument : arguments) {
                if (argument == null) continue;
                cli.addProgramArguments(new String[]{argument});
            }
        }
    }

    String[] splitArgLine(String argLine) throws MojoExecutionException {
        try {
            return CommandLineUtils.translateCommandline((String)argLine);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while parsing commandline: " + e.getMessage(), e);
        }
    }

    private String getTestApplication(EquinoxInstallationDescription testRuntime) {
        if (this.useUIHarness) {
            ArtifactDescriptor systemBundle = testRuntime.getSystemBundle();
            Version osgiVersion = Version.parseVersion((String)systemBundle.getKey().getVersion());
            if (osgiVersion.compareTo(EquinoxInstallationDescription.EQUINOX_VERSION_3_3_0) < 0) {
                return "org.eclipse.tycho.surefire.osgibooter.uitest32";
            }
            return "org.eclipse.tycho.surefire.osgibooter.uitest";
        }
        return "org.eclipse.tycho.surefire.osgibooter.headlesstest";
    }

    private String getBuildOutputDirectories() {
        StringBuilder sb = new StringBuilder();
        ReactorProject reactorProject = this.getReactorProject();
        sb.append(reactorProject.getOutputDirectory());
        sb.append(',').append(reactorProject.getTestOutputDirectory());
        for (BuildOutputJar outputJar : this.osgiBundle.getEclipsePluginProject(reactorProject).getOutputJars()) {
            if (".".equals(outputJar.getName())) continue;
            TestMojo.appendCommaSeparated(sb, outputJar.getOutputDirectory().getAbsolutePath());
        }
        return sb.toString();
    }

    private static void appendCommaSeparated(StringBuilder sb, String string) {
        if (sb.length() > 0) {
            sb.append(',');
        }
        sb.append(string);
    }

    private List<String> getBundlesToExplode() {
        ArrayList<String> bundles = new ArrayList<String>();
        if (this.explodedBundles != null) {
            bundles.addAll(Arrays.asList(this.explodedBundles));
        }
        return bundles;
    }

    private List<File> getFrameworkExtensions() throws MojoExecutionException {
        ArrayList<File> files = new ArrayList<File>();
        if (this.frameworkExtensions != null) {
            for (Dependency frameworkExtension : this.frameworkExtensions) {
                Artifact artifact = this.repositorySystem.createDependencyArtifact(frameworkExtension);
                ArtifactResolutionRequest request = new ArtifactResolutionRequest();
                request.setArtifact(artifact);
                request.setResolveRoot(true).setResolveTransitively(false);
                request.setLocalRepository(this.session.getLocalRepository());
                request.setRemoteRepositories(this.project.getPluginArtifactRepositories());
                request.setOffline(this.session.isOffline());
                request.setForceUpdate(this.session.getRequest().isUpdateSnapshots());
                ArtifactResolutionResult result = this.repositorySystem.resolve(request);
                try {
                    this.resolutionErrorHandler.throwErrors(request, result);
                }
                catch (ArtifactResolutionException e) {
                    throw new MojoExecutionException("Failed to resolve framework extension " + frameworkExtension.getManagementKey(), (Exception)((Object)e));
                }
                files.add(artifact.getFile());
            }
        }
        return files;
    }
}

