/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.surefire.api.util.ScanResult;
import org.apache.maven.surefire.booter.PropertiesWrapper;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationDescription;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.classpath.ClasspathEntry;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.surefire.AbstractTestMojo;
import org.eclipse.tycho.surefire.provider.impl.NoopTestFrameworkProvider;
import org.eclipse.tycho.surefire.provider.spi.TestFrameworkProvider;

@Mojo(name="integration-test", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class TychoIntegrationTestMojo
extends AbstractTestMojo {
    @Parameter(property="project.build.testOutputDirectory")
    private File testClassesDirectory;
    @Parameter(property="skipITs")
    private boolean skipITs;
    @Parameter(defaultValue="${project.build.directory}/failsafe-reports/failsafe-summary.xml", required=true)
    private File summaryFile;
    @Parameter(defaultValue="${project.build.directory}/failsafe-reports", required=true)
    private File reportDirectory;
    @Parameter(defaultValue="${plugin}", readonly=true, required=true)
    private PluginDescriptor pluginDescriptor;
    @Parameter(defaultValue="${project.pluginArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> pluginRemoteRepositories;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    private List<ArtifactRepository> projectRemoteRepositories;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;

    @Override
    protected boolean shouldRun() {
        return "eclipse-plugin".equals(this.project.getPackaging()) && this.scanForTests().size() > 0;
    }

    @Override
    protected List<String> getDefaultInclude() {
        return Arrays.asList("**/PluginTest*.class", "**/*IT.class");
    }

    @Override
    protected File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }

    @Override
    protected File getReportsDirectory() {
        return this.reportDirectory;
    }

    @Override
    protected boolean shouldSkip() {
        return this.skipITs || super.shouldSkip();
    }

    @Override
    protected PropertiesWrapper createSurefireProperties(TestFrameworkProvider provider, ScanResult scanResult) throws MojoExecutionException {
        PropertiesWrapper properties = super.createSurefireProperties(provider, scanResult);
        properties.setProperty("failifnotests", String.valueOf(false));
        properties.setProperty("failsafe", this.summaryFile.getAbsolutePath());
        return properties;
    }

    @Override
    protected void handleNoTestsFound() throws MojoFailureException {
        this.getLog().info((CharSequence)"No tests found");
    }

    @Override
    protected void handleSuccess() {
    }

    @Override
    protected void handleTestFailures() throws MojoFailureException {
    }

    @Override
    protected void setupTestBundles(TestFrameworkProvider provider, EquinoxInstallationDescription testRuntime) throws MojoExecutionException {
        List dependencies = this.pluginDescriptor.getPlugin().getDependencies();
        if (dependencies.isEmpty()) {
            super.setupTestBundles(provider, testRuntime);
        } else {
            super.setupTestBundles(new NoopTestFrameworkProvider(), testRuntime);
            for (Dependency dependency : dependencies) {
                ArtifactResolutionResult resolveArtifact = this.resolveDependency(dependency);
                for (Artifact artifact : resolveArtifact.getArtifacts()) {
                    File file = artifact.getFile();
                    if (file == null) continue;
                    testRuntime.addDevEntries("org.eclipse.tycho.surefire.osgibooter", file.getAbsolutePath());
                }
            }
        }
        ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.project);
        File testPluginJar = this.createTestPluginJar(reactorProject);
        ArtifactKey bundleArtifactKey = this.getBundleArtifactKey(testPluginJar);
        testRuntime.addBundle(bundleArtifactKey.getId(), bundleArtifactKey.getVersion(), testPluginJar);
        String bsn = bundleArtifactKey.getId();
        List testClasspath = this.osgiBundle.getTestClasspath(reactorProject, false);
        String testDevEntries = testClasspath.stream().map(ClasspathEntry::getLocations).flatMap(Collection::stream).map(File::getAbsolutePath).collect(Collectors.joining(","));
        testRuntime.addDevEntries(bsn, testDevEntries);
    }

    private File createTestPluginJar(ReactorProject reactorProject) throws MojoExecutionException {
        try {
            UUID uuid = UUID.randomUUID();
            File fragmentFile = new File(this.project.getBuild().getDirectory(), FilenameUtils.getBaseName((String)reactorProject.getArtifact().getName()) + "_test_fragment_" + uuid + ".jar");
            if (fragmentFile.exists()) {
                fragmentFile.delete();
            }
            try (Jar mainArtifact = new Jar(reactorProject.getArtifact());
                 Jar jar = new Jar(reactorProject.getName() + " test classes", new File(this.project.getBuild().getTestOutputDirectory()), null);
                 Analyzer analyzer = new Analyzer(jar);){
                Manifest bundleManifest = mainArtifact.getManifest();
                String hostVersion = bundleManifest.getMainAttributes().getValue("Bundle-Version");
                String hostSymbolicName = bundleManifest.getMainAttributes().getValue("Bundle-SymbolicName");
                analyzer.setProperty("Bundle-Version", hostVersion);
                analyzer.setProperty("Bundle-SymbolicName", hostSymbolicName + "." + uuid);
                analyzer.setProperty("Fragment-Host", hostSymbolicName + ";bundle-version=\"" + hostVersion + "\"");
                analyzer.setProperty("Bundle-Name", "Test Fragment for " + this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion());
                analyzer.setProperty("Import-Package", "*;resolution:=optional");
                Collection additionalBundles = reactorProject.getBuildProperties().getAdditionalBundles();
                if (!additionalBundles.isEmpty()) {
                    analyzer.setProperty("Require-Bundle", additionalBundles.stream().map(b -> b + ";resolution:=optional").collect(Collectors.joining(",")));
                }
                analyzer.setProperty("DynamicImport-Package", "*");
                List testClasspath = this.osgiBundle.getTestClasspath(reactorProject);
                for (ClasspathEntry classpathEntry : testClasspath) {
                    for (File loc : classpathEntry.getLocations()) {
                        analyzer.addClasspath(loc);
                    }
                }
                analyzer.addClasspath(mainArtifact);
                jar.setManifest(analyzer.calcManifest());
                jar.write(fragmentFile);
            }
            return fragmentFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling test fragment jar", e);
        }
    }

    private ArtifactResolutionResult resolveDependency(Dependency dependency) {
        Artifact artifact = this.repositorySystem.createDependencyArtifact(dependency);
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setOffline(this.session.isOffline()).setArtifact(artifact).setLocalRepository(this.localRepository).setResolveTransitively(true).setCollectionFilter((ArtifactFilter)new ProviderDependencyArtifactFilter()).setRemoteRepositories(Stream.concat(this.pluginRemoteRepositories.stream(), this.projectRemoteRepositories.stream()).collect(Collectors.toList()));
        return this.repositorySystem.resolve(request);
    }

    private static final class ProviderDependencyArtifactFilter
    implements ArtifactFilter {
        private static final Collection<String> SCOPES = List.of("compile", "compile+runtime", "runtime");

        private ProviderDependencyArtifactFilter() {
        }

        public boolean include(Artifact artifact) {
            String scope = artifact.getScope();
            return !artifact.isOptional() && (scope == null || SCOPES.contains(scope));
        }
    }
}

