/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.bnd;

import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.repository.ResourcesRepository;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.version.Version;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.osgi.resource.InstallableUnitResource;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class TargetPlatformRepository
extends ResourcesRepository
implements RepositoryPlugin {
    private ReactorProject reactorProject;
    private TargetPlatform targetPlatform;

    public TargetPlatformRepository(ReactorProject reactorProject) {
        this.reactorProject = reactorProject;
        this.targetPlatform = TychoProjectUtils.getTargetPlatform((ReactorProject)reactorProject);
        IArtifactRepository artifactRepository = this.targetPlatform.getArtifactRepository();
        Set allUnits = this.targetPlatform.getMetadataRepository().query(QueryUtil.ALL_UNITS, null).toSet();
        for (IInstallableUnit unit : allUnits) {
            if (unit.getId().endsWith(".source") || unit.getId().endsWith(".feature.group") || unit.getId().equals(".feature.jar")) continue;
            this.add((Resource)new InstallableUnitResource(unit, artifactRepository));
        }
    }

    public File get(String bsn, Version version, Map<String, String> properties, RepositoryPlugin.DownloadListener ... listeners) throws Exception {
        ArtifactKey artifact = this.targetPlatform.resolveArtifact("eclipse-plugin", bsn, version.toString());
        if (artifact != null) {
            File location = this.targetPlatform.getArtifactLocation(artifact);
            if (location != null) {
                for (RepositoryPlugin.DownloadListener downloadListener : listeners) {
                    downloadListener.success(location, properties);
                }
            }
            return location;
        }
        return null;
    }

    public List<String> list(String pattern) throws Exception {
        Instruction filter = null;
        if (pattern != null) {
            filter = new Instruction(pattern);
        }
        HashSet<String> result = new HashSet<String>();
        IQueryResult query = this.targetPlatform.getMetadataRepository().query(QueryUtil.ALL_UNITS, null);
        for (IInstallableUnit iu : query) {
            for (IArtifactKey artifactKey : iu.getArtifacts()) {
                if (!"osgi.bundle".equals(artifactKey.getClassifier())) continue;
                String id = artifactKey.getId();
                if (filter != null && !filter.matches(id)) continue;
                result.add(id);
            }
        }
        return List.copyOf(result);
    }

    public RepositoryPlugin.PutResult put(InputStream stream, RepositoryPlugin.PutOptions options) throws Exception {
        throw new UnsupportedOperationException();
    }

    public SortedSet<Version> versions(String bsn) throws Exception {
        TreeSet<Version> set = new TreeSet<Version>();
        TargetPlatform targetPlatform = TychoProjectUtils.getTargetPlatformIfAvailable((ReactorProject)this.reactorProject);
        for (IInstallableUnit iu : targetPlatform.getMetadataRepository().query(QueryUtil.createIUQuery((String)bsn), null)) {
            for (IArtifactKey artifactKey : iu.getArtifacts()) {
                if (!"osgi.bundle".equals(artifactKey.getClassifier())) continue;
                set.add(new Version(artifactKey.getVersion().toString()));
            }
        }
        return set;
    }

    public boolean canWrite() {
        return false;
    }

    public String getName() {
        return "TargetPlatform of " + this.reactorProject.getId();
    }

    public String getLocation() {
        return this.reactorProject.getBasedir().toURI().toString();
    }

    public List<Capability> findProvider(Requirement requirement) {
        List provider = super.findProvider(requirement);
        return provider;
    }
}

