/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ExecutionException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.surefire.api.util.ScanResult;
import org.apache.maven.surefire.booter.PropertiesWrapper;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.sisu.equinox.launching.BundleStartLevel;
import org.eclipse.sisu.equinox.launching.DefaultEquinoxInstallationDescription;
import org.eclipse.sisu.equinox.launching.EquinoxInstallation;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationDescription;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationFactory;
import org.eclipse.sisu.equinox.launching.EquinoxLauncher;
import org.eclipse.sisu.equinox.launching.LaunchConfiguration;
import org.eclipse.sisu.equinox.launching.internal.EquinoxLaunchConfiguration;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.BuildDirectory;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.DependencyArtifacts;
import org.eclipse.tycho.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.OptionalResolutionAction;
import org.eclipse.tycho.PlatformPropertiesUtils;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ReproducibleUtils;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.TychoConstants;
import org.eclipse.tycho.core.BundleProject;
import org.eclipse.tycho.core.DependencyResolver;
import org.eclipse.tycho.core.DependencyResolverConfiguration;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.project.BuildOutputJar;
import org.eclipse.tycho.dev.DevBundleInfo;
import org.eclipse.tycho.dev.DevWorkspaceResolver;
import org.eclipse.tycho.p2.tools.RepositoryReferences;
import org.eclipse.tycho.p2maven.InstallableUnitGenerator;
import org.eclipse.tycho.p2tools.RepositoryReferenceTool;
import org.eclipse.tycho.surefire.AbstractTestMojo;
import org.eclipse.tycho.surefire.ConcurrencyLock;
import org.eclipse.tycho.surefire.IU;
import org.eclipse.tycho.surefire.ParallelMode;
import org.eclipse.tycho.surefire.provider.impl.ProviderHelper;
import org.eclipse.tycho.surefire.provider.spi.TestFrameworkProvider;
import org.eclipse.tycho.surefire.provisioning.ProvisionedInstallationBuilder;
import org.eclipse.tycho.surefire.provisioning.ProvisionedInstallationBuilderFactory;

public abstract class AbstractEclipseTestMojo
extends AbstractTestMojo {
    private static final String[] UNIX_SIGNAL_NAMES = new String[]{"not a signal", "SIGHUP", "SIGINT", "SIGQUIT", "SIGILL", "SIGTRAP", "SIGABRT", "SIGBUS", "SIGFPE", "SIGKILL", "SIGUSR1", "SIGSEGV", "SIGUSR2", "SIGPIPE", "SIGALRM", "SIGTERM", "SIGSTKFLT", "SIGCHLD", "SIGCONT", "SIGSTOP", "SIGTSTP", "SIGTTIN", "SIGTTOU", "SIGURG", "SIGXCPU", "SIGXFSZ", "SIGVTALRM", "SIGPROF", "SIGWINCH", "SIGIO", "SIGPWR", "SIGSYS"};
    private static final ConcurrencyLock CONCURRENCY_LOCK = new ConcurrencyLock();
    @Parameter(defaultValue="${project.build.directory}/work/data/")
    private File osgiDataDirectory;
    @Parameter(defaultValue="true")
    private boolean deleteOsgiDataDirectory;
    @Parameter(defaultValue="${project.basedir}")
    private File metadataDirectory;
    @Parameter(property="debugPort")
    private int debugPort;
    @Parameter(property="osgi.debug")
    private String debugOptions;
    @Parameter(property="groups")
    private String groups;
    @Parameter(property="excludedGroups")
    private String excludedGroups;
    @Parameter(property="tycho.showEclipseLog", defaultValue="false")
    private boolean showEclipseLog;
    @Parameter(property="tycho.printWires", defaultValue="false")
    private boolean printWires;
    @Parameter(property="maven.test.redirectTestOutputToFile", defaultValue="false")
    private boolean redirectTestOutputToFile;
    @Parameter(defaultValue="${project.build.directory}/surefire.properties")
    private File surefireProperties;
    @Parameter
    private String application;
    @Parameter
    private String product;
    @Parameter(property="tycho.surefire.useUIHarness", defaultValue="false")
    private boolean useUIHarness;
    @Parameter(property="tycho.surefire.useUIThread", defaultValue="true")
    private boolean useUIThread;
    @Parameter(property="enableAssertions", defaultValue="false")
    private boolean enableAssertions;
    @Parameter(property="tycho.testArgLine")
    private String argLine;
    @Parameter
    private String appArgLine;
    @Parameter(property="surefire.timeout")
    private int forkedProcessTimeoutInSeconds;
    @Parameter
    private Map<String, String> environmentVariables;
    @Parameter
    private Map<String, String> systemProperties;
    @Parameter
    private String[] explodedBundles;
    @Parameter
    private Dependency[] frameworkExtensions;
    @Parameter
    private BundleStartLevel[] bundleStartLevel;
    @Parameter
    private BundleStartLevel defaultStartLevel;
    @Parameter(property="surefire.rerunFailingTestsCount", defaultValue="0")
    private Integer rerunFailingTestsCount;
    @Parameter(property="surefire.skipAfterFailureCount", defaultValue="0")
    private Integer skipAfterFailureCount;
    @Component
    protected RepositorySystem repositorySystem;
    @Component
    private ResolutionErrorHandler resolutionErrorHandler;
    @Component(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;
    @Component
    private EquinoxInstallationFactory installationFactory;
    @Component
    private ProvisionedInstallationBuilderFactory provisionedInstallationBuilderFactory;
    @Component
    private EquinoxLauncher launcher;
    @Component(hint="p2")
    protected DependencyResolver dependencyResolver;
    @Parameter
    private String providerHint;
    @Parameter(defaultValue="filesystem")
    private String runOrder;
    @Parameter(property="trimStackTrace", defaultValue="false")
    private boolean trimStackTrace;
    @Parameter(property="parallel")
    private ParallelMode parallel;
    @Parameter(property="perCoreThreadCount", defaultValue="true")
    private boolean perCoreThreadCount;
    @Parameter(property="threadCount")
    private int threadCount = -1;
    @Parameter(property="useUnlimitedThreads", defaultValue="false")
    private boolean useUnlimitedThreads;
    @Parameter
    private Properties providerProperties = new Properties();
    @Parameter(defaultValue="default")
    private String testRuntime;
    @Parameter
    private Dependency[] dependencies;
    @Parameter
    private List<IU> install;
    @Parameter(name="repositories")
    private List<Repository> repositories;
    @Parameter(defaultValue="DefaultProfile")
    private String profileName;
    @Parameter
    private int reactorConcurrencyLevel;
    @Parameter(defaultValue="booterFirst")
    private ClassLoaderOrder classLoaderOrder;
    @Component
    private ProviderHelper providerHelper;
    @Component
    private DevWorkspaceResolver workspaceState;
    @Component
    private RepositoryReferenceTool repositoryReferenceTool;
    @Component
    protected InstallableUnitGenerator generator;
    @Parameter
    private List<String> suiteXmlFiles;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runTests(ScanResult scanResult) throws MojoExecutionException, MojoFailureException {
        ReactorProject reactorProject = this.getReactorProject();
        reactorProject.setContextValue(TychoConstants.CTX_METADATA_ARTIFACT_LOCATION, (Object)this.metadataDirectory);
        Class<AbstractEclipseTestMojo> clazz = AbstractEclipseTestMojo.class;
        synchronized (AbstractEclipseTestMojo.class) {
            EquinoxInstallation equinoxTestRuntime;
            if ("p2Installed".equals(this.testRuntime)) {
                equinoxTestRuntime = this.createProvisionedInstallation();
            } else if ("default".equals(this.testRuntime)) {
                equinoxTestRuntime = this.createEclipseInstallation();
            } else {
                throw new MojoExecutionException("Configured testRuntime parameter value '" + this.testRuntime + "' is unknown. Allowed values: 'default', 'p2Installed'.");
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (equinoxTestRuntime != null) {
                try (AutoCloseable runLock = CONCURRENCY_LOCK.aquire(this.reactorConcurrencyLevel);){
                    this.runTest(equinoxTestRuntime);
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (MojoExecutionException | MojoFailureException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MojoFailureException((Throwable)e);
                }
            }
            return;
        }
    }

    private EquinoxInstallation createProvisionedInstallation() throws MojoExecutionException, MojoFailureException {
        ScanResult scanResult = this.scanForTests();
        if (scanResult.size() == 0) {
            this.handleNoTestsFound();
            return null;
        }
        TestFrameworkProvider provider = this.providerHelper.selectProvider(this.project, this.getProjectType().getClasspath(DefaultReactorProject.adapt((MavenProject)this.project)), this.getMergedProviderProperties(), this.providerHint);
        try {
            PropertiesWrapper wrapper = this.createSurefireProperties(provider, scanResult);
            this.storeProperties(wrapper.getProperties(), this.surefireProperties);
            ProvisionedInstallationBuilder installationBuilder = this.provisionedInstallationBuilderFactory.createInstallationBuilder();
            Set<Artifact> testHarnessArtifacts = this.providerHelper.filterTestFrameworkBundles(provider, this.pluginArtifacts);
            for (Artifact artifact : testHarnessArtifacts) {
                installationBuilder.addBundleJar(artifact.getFile());
            }
            RepositoryReferences sources = this.repositoryReferenceTool.getVisibleRepositories(this.project, this.session, 1);
            if (this.repositories != null) {
                for (Repository repository : this.repositories) {
                    String url = repository.getUrl();
                    if (url == null || url.isBlank()) {
                        throw new MojoExecutionException("Repository url can't be empty!");
                    }
                    URI uri = new URI(url);
                    this.getLog().info((CharSequence)("Adding repository " + String.valueOf(uri) + "..."));
                    sources.addRepository(uri);
                }
            }
            installationBuilder.addMetadataRepositories(sources.getMetadataRepositories());
            installationBuilder.addArtifactRepositories(sources.getArtifactRepositories());
            installationBuilder.setProfileName(this.profileName);
            installationBuilder.addIUsToBeInstalled(this.getIUsToInstall(testHarnessArtifacts));
            File file = new File(this.project.getBuild().getDirectory(), "p2temp");
            file.mkdirs();
            installationBuilder.setWorkingDir(file);
            installationBuilder.setDestination(this.work);
            List<TargetEnvironment> list = this.getTestTargetEnvironments();
            TargetEnvironment testEnvironment = list.get(0);
            installationBuilder.setTargetEnvironment(testEnvironment);
            this.getLog().info((CharSequence)("Provisioning with environment " + String.valueOf(testEnvironment) + "..."));
            return installationBuilder.install();
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException(e.getInput() + " is not a valid URI", (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private List<String> getIUsToInstall(Set<Artifact> testHarnessArtifacts) {
        ArrayList<String> iusToInstall = new ArrayList<String>();
        iusToInstall.add(this.getTestBundleSymbolicName());
        iusToInstall.addAll(this.providerHelper.getSymbolicNames(testHarnessArtifacts));
        LinkedHashSet<DefaultArtifactKey> extraDependencies = new LinkedHashSet<DefaultArtifactKey>(this.projectManager.getTargetPlatformConfiguration(this.project).getAdditionalArtifacts());
        extraDependencies.addAll(this.osgiBundle.getExtraTestRequirements(this.getReactorProject()));
        if (this.install != null) {
            for (IU iU : this.install) {
                extraDependencies.add(new DefaultArtifactKey(iU.feature ? "eclipse-feature" : "eclipse-plugin", iU.id, Objects.requireNonNullElse(iU.version, "0.0.0")));
            }
        }
        for (ArtifactKey artifactKey : extraDependencies) {
            String type = artifactKey.getType();
            if ("eclipse-plugin".equals(type) || "p2-installable-unit".equals(type)) {
                iusToInstall.add(artifactKey.getId());
                continue;
            }
            if (!"eclipse-feature".equals(type)) continue;
            iusToInstall.add(artifactKey.getId() + ".feature.group");
        }
        return iusToInstall;
    }

    private BundleProject getProjectType() {
        return (BundleProject)this.projectTypes.get(this.project.getPackaging());
    }

    private EquinoxInstallation createEclipseInstallation() throws MojoExecutionException, MojoFailureException {
        ScanResult scanResult = this.scanForTests();
        if (scanResult.size() == 0) {
            this.handleNoTestsFound();
            return null;
        }
        TestFrameworkProvider provider = this.providerHelper.selectProvider(this.project, this.getProjectType().getTestClasspath(DefaultReactorProject.adapt((MavenProject)this.project)), this.getMergedProviderProperties(), this.providerHint);
        ArrayList<IRequirement> testRequiredPackages = new ArrayList<IRequirement>();
        Set<Artifact> testFrameworkBundles = this.providerHelper.filterTestFrameworkBundles(provider, this.pluginArtifacts);
        for (Artifact artifact : testFrameworkBundles) {
            this.generator.getInstallableUnits(artifact).stream().flatMap(iu -> iu.getRequirements().stream()).filter(req -> {
                IRequiredCapability reqcap;
                return req instanceof IRequiredCapability && "java.package".equals((reqcap = (IRequiredCapability)req).getNamespace());
            }).forEach(testRequiredPackages::add);
        }
        DependencyArtifacts testRuntimeArtifacts = this.resolveDependencies(testRequiredPackages);
        this.work.mkdirs();
        DefaultEquinoxInstallationDescription testRuntime = new DefaultEquinoxInstallationDescription();
        testRuntime.setDefaultBundleStartLevel(this.defaultStartLevel);
        testRuntime.addBundlesToExplode(this.getBundlesToExplode());
        testRuntime.addFrameworkExtensions(this.getFrameworkExtensions());
        if (this.bundleStartLevel != null) {
            for (BundleStartLevel level : this.bundleStartLevel) {
                testRuntime.addBundleStartLevel(level);
            }
        }
        PropertiesWrapper wrapper = this.createSurefireProperties(provider, scanResult);
        this.storeProperties(wrapper.getProperties(), this.surefireProperties);
        for (ArtifactDescriptor artifact : testRuntimeArtifacts.getArtifacts("eclipse-plugin")) {
            ReactorProject otherProject = artifact.getMavenProject();
            if (otherProject != null) {
                if (this.useMetadataDirectory(otherProject)) {
                    this.addBundle((EquinoxInstallationDescription)testRuntime, artifact.getKey(), this.metadataDirectory);
                    continue;
                }
                File file = otherProject.getArtifact(artifact.getClassifier());
                if (file != null) {
                    this.addBundle((EquinoxInstallationDescription)testRuntime, artifact.getKey(), file);
                    continue;
                }
            }
            try {
                this.addBundle((EquinoxInstallationDescription)testRuntime, artifact.getKey(), (File)artifact.fetchArtifact().get());
            }
            catch (InterruptedException e) {
                throw new MojoExecutionException("interrupted");
            }
            catch (ExecutionException e) {
                throw new MojoFailureException("fetching artifact failed", (Throwable)e);
            }
        }
        this.setupTestBundles(testFrameworkBundles, (EquinoxInstallationDescription)testRuntime);
        this.getReportsDirectory().mkdirs();
        return this.installationFactory.createInstallation((EquinoxInstallationDescription)testRuntime, this.work);
    }

    protected boolean useMetadataDirectory(ReactorProject otherProject) {
        return otherProject.sameProject((Object)this.project) && this.project.getBasedir().equals(this.metadataDirectory);
    }

    private void addBundle(EquinoxInstallationDescription runtime, ArtifactKey artifact, File file) {
        if (file == null) {
            throw new IllegalArgumentException("File for artifact " + String.valueOf(artifact) + " is null");
        }
        runtime.addBundle(artifact.getId(), artifact.getVersion(), file);
    }

    protected DependencyArtifacts resolveDependencies(final Collection<IRequirement> additionalRequirements) throws MojoExecutionException {
        final List<ArtifactKey> extraDependencies = this.getExtraDependencies();
        DependencyResolverConfiguration resolverConfiguration = new DependencyResolverConfiguration(){

            public OptionalResolutionAction getOptionalResolutionAction() {
                return OptionalResolutionAction.IGNORE;
            }

            public List<ArtifactKey> getAdditionalArtifacts() {
                return extraDependencies;
            }

            public Collection<IRequirement> getAdditionalRequirements() {
                return additionalRequirements;
            }
        };
        DependencyArtifacts testRuntimeArtifacts = this.dependencyResolver.resolveDependencies(this.session, this.project, (TargetPlatform)this.projectManager.getTargetPlatform(this.project).orElseThrow(() -> new MojoExecutionException("Tycho build extension not configured for " + String.valueOf(this.project))), resolverConfiguration, this.getTestTargetEnvironments());
        if (testRuntimeArtifacts == null) {
            throw new MojoExecutionException("Cannot determinate build target platform location -- not executing tests");
        }
        return testRuntimeArtifacts;
    }

    protected void setupTestBundles(Set<Artifact> testFrameworkBundles, EquinoxInstallationDescription testRuntime) throws MojoExecutionException {
        for (Artifact artifact : testFrameworkBundles) {
            DevBundleInfo devInfo = this.workspaceState.getBundleInfo(this.session, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), this.project.getPluginArtifactRepositories());
            if (devInfo != null) {
                this.addBundle(testRuntime, devInfo.getArtifactKey(), devInfo.getLocation());
                testRuntime.addDevEntries(devInfo.getSymbolicName(), devInfo.getDevEntries());
                continue;
            }
            File bundleLocation = artifact.getFile();
            ArtifactKey bundleArtifactKey = this.getBundleArtifactKey(bundleLocation);
            this.addBundle(testRuntime, bundleArtifactKey, bundleLocation);
        }
        testRuntime.addDevEntries(this.getTestBundleSymbolicName(), this.getBuildOutputDirectories());
    }

    private String getTestBundleSymbolicName() {
        return this.getProjectType().getArtifactKey(this.getReactorProject()).getId();
    }

    protected ArtifactKey getBundleArtifactKey(File file) throws MojoExecutionException {
        ArtifactKey key = this.osgiBundle.readArtifactKey(file);
        if (key == null) {
            throw new MojoExecutionException("Not an OSGi bundle " + file.getAbsolutePath());
        }
        return key;
    }

    protected List<ArtifactKey> getExtraDependencies() {
        ArrayList<ArtifactKey> dependencies = new ArrayList<ArtifactKey>();
        if (this.dependencies != null) {
            for (Dependency key : this.dependencies) {
                dependencies.add((ArtifactKey)new DefaultArtifactKey(key.getType(), key.getArtifactId(), key.getVersion()));
            }
        }
        TargetPlatformConfiguration configuration = this.projectManager.getTargetPlatformConfiguration(this.project);
        dependencies.addAll(configuration.getDependencyResolverConfiguration().getAdditionalArtifacts());
        dependencies.addAll(this.osgiBundle.getExtraTestRequirements(this.getReactorProject()));
        dependencies.addAll(this.getTestDependencies());
        return dependencies;
    }

    private List<ArtifactKey> getTestDependencies() {
        ArrayList<ArtifactKey> result = new ArrayList<ArtifactKey>();
        result.add(this.newBundleDependency("org.eclipse.osgi"));
        result.add(this.newBundleDependency("org.eclipse.equinox.launcher"));
        if (this.useUIHarness) {
            result.add(this.newBundleDependency("org.eclipse.ui.ide.application"));
        } else {
            result.add(this.newBundleDependency("org.eclipse.core.runtime"));
        }
        return result;
    }

    protected ArtifactKey newBundleDependency(String bundleId) {
        return new DefaultArtifactKey("eclipse-plugin", bundleId);
    }

    protected PropertiesWrapper createSurefireProperties(TestFrameworkProvider provider, ScanResult scanResult) throws MojoExecutionException {
        PropertiesWrapper wrapper = new PropertiesWrapper(new HashMap());
        wrapper.setProperty("testpluginname", this.getTestBundleSymbolicName());
        wrapper.setProperty("testclassesdirectory", this.getTestClassesDirectory().getAbsolutePath());
        wrapper.setProperty("reportsdirectory", this.getReportsDirectory().getAbsolutePath());
        wrapper.setProperty("redirectTestOutputToFile", String.valueOf(this.redirectTestOutputToFile));
        wrapper.setProperty("runOrder", this.runOrder);
        wrapper.setProperty("trimStackTrace", String.valueOf(this.trimStackTrace));
        wrapper.setProperty("skipAfterFailureCount", String.valueOf(this.skipAfterFailureCount));
        wrapper.setProperty("rerunFailingTestsCount", String.valueOf(this.rerunFailingTestsCount));
        wrapper.setProperty("printBundles", String.valueOf(this.printBundles));
        wrapper.setProperty("printWires", String.valueOf(this.printWires));
        wrapper.setProperty("classLoaderOrder", this.classLoaderOrder.toString());
        Properties mergedProviderProperties = this.getMergedProviderProperties();
        mergedProviderProperties.putAll((Map<?, ?>)provider.getProviderSpecificProperties());
        Map<String, String> providerPropertiesAsMap = this.propertiesAsMap(mergedProviderProperties);
        scanResult.writeTo(providerPropertiesAsMap);
        for (Map.Entry<String, String> entry : providerPropertiesAsMap.entrySet()) {
            wrapper.setProperty("__provider." + entry.getKey(), entry.getValue().toString());
        }
        wrapper.setProperty("testprovider", provider.getSurefireProviderClassName());
        this.getLog().debug((CharSequence)("Using test framework provider: " + provider.getClass().getName()));
        wrapper.addList(this.suiteXmlFiles, "testSuiteXmlFiles");
        return wrapper;
    }

    protected Properties getMergedProviderProperties() throws MojoExecutionException {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.providerProperties);
        if (this.parallel != null) {
            result.put("parallel", this.parallel.name());
            if (!this.useUnlimitedThreads) {
                if (this.perCoreThreadCount && this.threadCount < 1) {
                    throw new MojoExecutionException("Parallel mode with perCoreThreadCount=true requires threadCount>=1");
                }
                if (!this.perCoreThreadCount && this.threadCount <= 1) {
                    throw new MojoExecutionException("Parallel mode requires threadCount>1 or useUnlimitedThreads=true");
                }
            }
            if (this.threadCount > 0) {
                result.put("threadcount", String.valueOf(this.threadCount));
            }
            result.put("perCoreThreadCount", String.valueOf(this.perCoreThreadCount));
            result.put("useUnlimitedThreads", String.valueOf(this.useUnlimitedThreads));
        }
        if (this.groups != null) {
            result.put("groups", this.groups);
        }
        if (this.excludedGroups != null) {
            result.put("excludegroups", this.excludedGroups);
        }
        return result;
    }

    private void storeProperties(Map<String, String> propertiesMap, File file) throws MojoExecutionException {
        Properties p = new Properties();
        p.putAll(propertiesMap);
        try {
            ReproducibleUtils.storeProperties((Properties)p, (Path)file.toPath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't write test launcher properties file", (Exception)e);
        }
    }

    private void runTest(EquinoxInstallation testRuntime) throws MojoExecutionException, MojoFailureException {
        int result;
        EquinoxLaunchConfiguration cli;
        File logFile = new File(this.osgiDataDirectory, ".metadata/.log");
        try {
            if (this.deleteOsgiDataDirectory) {
                FileUtils.deleteDirectory((File)this.osgiDataDirectory);
            }
            cli = this.createCommandLine(testRuntime);
            this.getLog().info((CharSequence)("Executing test runtime with timeout (seconds): " + this.forkedProcessTimeoutInSeconds + ", logs, if any, will be placed at: " + logFile.getAbsolutePath()));
            result = this.launcher.execute((LaunchConfiguration)cli, this.forkedProcessTimeoutInSeconds);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while executing platform", e);
        }
        switch (result) {
            case 0: {
                this.handleSuccess();
                break;
            }
            case 200: {
                if (this.application == null) {
                    throw new MojoExecutionException("Could not find the default application \"org.eclipse.ui.ide.workbench\" in the test runtime.");
                }
                throw new MojoFailureException("Could not find application \"" + this.application + "\" in the test runtime. Make sure that the test runtime includes the bundle which defines this application.");
            }
            case 254: {
                this.handleNoTestsFound();
                break;
            }
            case 255: {
                this.handleTestFailures();
                break;
            }
            default: {
                StringBuilder defaultMessage = new StringBuilder("An unexpected error occurred while launching the test runtime (process returned error code ");
                defaultMessage.append(this.decodeReturnCode(result));
                defaultMessage.append(").");
                if (logFile.exists()) {
                    defaultMessage.append(" The process logfile ");
                    defaultMessage.append(logFile.getAbsolutePath());
                    defaultMessage.append(" might contain further details.");
                }
                defaultMessage.append(" Command-line used to launch the sub-process was ");
                defaultMessage.append(cli.getJvmExecutable());
                CharSequence[] vmArguments = cli.getVMArguments();
                if (vmArguments != null && vmArguments.length > 0) {
                    defaultMessage.append(" ");
                    defaultMessage.append(String.join((CharSequence)" ", vmArguments));
                }
                defaultMessage.append(" -jar ");
                defaultMessage.append(cli.getLauncherJar());
                CharSequence[] programArguments = cli.getProgramArguments();
                if (programArguments != null && programArguments.length > 0) {
                    defaultMessage.append(" ");
                    defaultMessage.append(String.join((CharSequence)" ", programArguments));
                }
                defaultMessage.append(" in working directory ");
                defaultMessage.append(cli.getWorkingDirectory());
                throw new MojoFailureException(defaultMessage.toString());
            }
        }
    }

    protected abstract void handleTestFailures() throws MojoFailureException;

    protected abstract void handleSuccess();

    private String decodeReturnCode(int result) {
        try {
            if ("linux".equals(PlatformPropertiesUtils.getOS((Properties)System.getProperties()))) {
                int signal = result - 128;
                if (signal > 0 && signal < UNIX_SIGNAL_NAMES.length) {
                    return result + "(" + UNIX_SIGNAL_NAMES[signal] + " received?)";
                }
            } else if ("win32".equals(PlatformPropertiesUtils.getOS((Properties)System.getProperties()))) {
                return result + " (HRESULT Code 0x" + Integer.toHexString(result).toUpperCase() + ", check for example https://www.hresult.info/ for further details)";
            }
        }
        catch (RuntimeException e) {
            this.getLog().debug((CharSequence)"Decoding return code failed", (Throwable)e);
        }
        return String.valueOf(result);
    }

    private EquinoxLaunchConfiguration createCommandLine(EquinoxInstallation testRuntime) throws MalformedURLException, MojoExecutionException {
        EquinoxLaunchConfiguration cli = new EquinoxLaunchConfiguration(testRuntime);
        String executable = this.getJavaExecutable();
        cli.setJvmExecutable(executable);
        cli.setWorkingDirectory(this.project.getBasedir());
        if (this.debugPort > 0) {
            cli.addVMArguments(new String[]{"-Xdebug", "-Xrunjdwp:transport=dt_socket,address=" + this.debugPort + ",server=y,suspend=y"});
        }
        cli.addVMArguments(new String[]{"-Dosgi.noShutdown=false"});
        TargetEnvironment environment = TargetEnvironment.getRunningEnvironment();
        cli.addVMArguments(new String[]{"-Dosgi.os=" + environment.getOs(), "-Dosgi.ws=" + environment.getWs(), "-Dosgi.arch=" + environment.getArch()});
        this.addCustomProfileArg(cli);
        cli.addVMArguments(this.splitArgLine(this.argLine));
        for (Map.Entry<String, String> entry : this.getMergedSystemProperties().entrySet()) {
            cli.addVMArguments(new String[]{"-D" + entry.getKey() + "=" + entry.getValue()});
        }
        if (this.debugOptions != null || this.getLog().isDebugEnabled()) {
            if (this.debugOptions == null || this.debugOptions.isBlank()) {
                cli.addProgramArguments(new String[]{"-debug"});
            } else {
                cli.addProgramArguments(new String[]{"-debug", new File(this.debugOptions).getAbsolutePath()});
            }
        }
        if (this.getLog().isDebugEnabled() || this.showEclipseLog) {
            cli.addProgramArguments(new String[]{"-consolelog"});
        }
        this.addProgramArgs(cli, "-data", this.osgiDataDirectory.getAbsolutePath(), "-install", testRuntime.getLocation().getAbsolutePath(), "-configuration", testRuntime.getConfigurationLocation().getAbsolutePath(), "-application", this.getTestApplication(), "-testproperties", this.surefireProperties.getAbsolutePath());
        if (this.application != null) {
            cli.addProgramArguments(new String[]{"-testApplication", this.application});
        }
        if (this.product != null) {
            cli.addProgramArguments(new String[]{"-product", this.product});
        }
        if (this.useUIHarness && !this.useUIThread) {
            cli.addProgramArguments(new String[]{"-nouithread"});
        }
        cli.addProgramArguments(this.splitArgLine(this.appArgLine));
        if (this.environmentVariables != null) {
            cli.addEnvironmentVariables(this.environmentVariables);
        }
        if (this.enableAssertions) {
            cli.addVMArguments(new String[]{"-ea"});
        }
        return cli;
    }

    private Map<String, String> getMergedSystemProperties() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("osgi.clean", "true");
        if (this.systemProperties != null) {
            result.putAll(this.systemProperties);
        }
        return result;
    }

    private void addCustomProfileArg(EquinoxLaunchConfiguration cli) throws MojoExecutionException {
        ExecutionEnvironmentConfiguration eeConfig = this.projectManager.getExecutionEnvironmentConfiguration(this.project);
        if (eeConfig.isCustomProfile()) {
            Properties customProfileProps = eeConfig.getFullSpecification().getProfileProperties();
            File profileFile = new File(new File(this.project.getBuild().getDirectory()), "custom.profile");
            this.storeProperties(this.propertiesAsMap(customProfileProps), profileFile);
            cli.addVMArguments(new String[]{"-Dosgi.java.profile=" + String.valueOf(profileFile.toURI())});
        }
    }

    private Map<String, String> propertiesAsMap(Properties p) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String entry : p.stringPropertyNames()) {
            result.put(entry, p.getProperty(entry));
        }
        return result;
    }

    void addProgramArgs(EquinoxLaunchConfiguration cli, String ... arguments) {
        if (arguments != null) {
            for (String argument : arguments) {
                if (argument == null) continue;
                cli.addProgramArguments(new String[]{argument});
            }
        }
    }

    String[] splitArgLine(String argLine) throws MojoExecutionException {
        try {
            return CommandLineUtils.translateCommandline((String)argLine);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while parsing commandline: " + e.getMessage(), e);
        }
    }

    private String getTestApplication() {
        if (this.useUIHarness) {
            return "org.eclipse.tycho.surefire.osgibooter.uitest";
        }
        return "org.eclipse.tycho.surefire.osgibooter.headlesstest";
    }

    private String getBuildOutputDirectories() {
        StringJoiner sb = new StringJoiner(",");
        ReactorProject reactorProject = this.getReactorProject();
        BuildDirectory buildDirectory = reactorProject.getBuildDirectory();
        sb.add(buildDirectory.getOutputDirectory().toString());
        sb.add(buildDirectory.getTestOutputDirectory().toString());
        for (BuildOutputJar outputJar : this.osgiBundle.getEclipsePluginProject(reactorProject).getOutputJars()) {
            if (".".equals(outputJar.getName())) continue;
            sb.add(outputJar.getOutputDirectory().getAbsolutePath());
        }
        return sb.toString();
    }

    private List<String> getBundlesToExplode() {
        ArrayList<String> bundles = new ArrayList<String>();
        if (this.explodedBundles != null) {
            bundles.addAll(Arrays.asList(this.explodedBundles));
        }
        return bundles;
    }

    private List<File> getFrameworkExtensions() throws MojoExecutionException {
        ArrayList<File> files = new ArrayList<File>();
        if (this.frameworkExtensions != null) {
            for (Dependency frameworkExtension : this.frameworkExtensions) {
                Artifact artifact = this.repositorySystem.createDependencyArtifact(frameworkExtension);
                ArtifactResolutionRequest request = new ArtifactResolutionRequest();
                request.setArtifact(artifact);
                request.setResolveRoot(true).setResolveTransitively(false);
                request.setLocalRepository(this.session.getLocalRepository());
                request.setRemoteRepositories(this.project.getPluginArtifactRepositories());
                request.setOffline(this.session.isOffline());
                request.setForceUpdate(this.session.getRequest().isUpdateSnapshots());
                ArtifactResolutionResult result = this.repositorySystem.resolve(request);
                try {
                    this.resolutionErrorHandler.throwErrors(request, result);
                }
                catch (ArtifactResolutionException e) {
                    throw new MojoExecutionException("Failed to resolve framework extension " + frameworkExtension.getManagementKey(), (Exception)((Object)e));
                }
                files.add(artifact.getFile());
            }
        }
        return files;
    }

    public static enum ClassLoaderOrder {
        booterFirst,
        testProbeFirst;

    }
}

