/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.bnd;

import aQute.bnd.osgi.Instruction;
import aQute.bnd.repository.fileset.FileSetRepository;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.version.Version;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ResolvedArtifactKey;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class ArtifactKeyRepository
extends FileSetRepository
implements RepositoryPlugin {
    private List<ResolvedArtifactKey> bundles;
    private String name;
    private File location;

    public ArtifactKeyRepository(List<ResolvedArtifactKey> bundles, String name, File location) throws Exception {
        super(name, bundles.stream().map(ResolvedArtifactKey::getLocation).toList());
        this.bundles = bundles;
        this.name = name;
        this.location = location;
    }

    public RepositoryPlugin.PutResult put(InputStream stream, RepositoryPlugin.PutOptions options) throws Exception {
        throw new UnsupportedOperationException();
    }

    public File get(String bsn, Version version, Map<String, String> properties, RepositoryPlugin.DownloadListener ... listeners) throws Exception {
        File file = this.bundles.stream().filter(a -> a.getId().equals(bsn)).filter(a -> version.compareTo(new Version(a.getVersion())) == 0).findFirst().map(ResolvedArtifactKey::getLocation).orElse(null);
        if (file != null) {
            for (RepositoryPlugin.DownloadListener downloadListener : listeners) {
                downloadListener.success(file, properties);
            }
        }
        return file;
    }

    public boolean canWrite() {
        return false;
    }

    public List<String> list(String pattern) throws Exception {
        Stream<String> stream = this.bundles.stream().map(ArtifactKey::getId);
        if (pattern != null) {
            Instruction filter = new Instruction(pattern);
            stream = stream.filter(arg_0 -> ((Instruction)filter).matches(arg_0));
        }
        return stream.toList();
    }

    public SortedSet<Version> versions(String bsn) throws Exception {
        return this.bundles.stream().filter(a -> a.getId().equals(bsn)).map(a -> new Version(a.getVersion())).collect(Collectors.toCollection(TreeSet::new));
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location.getAbsolutePath();
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        Map map = super.findProviders(requirements);
        return map;
    }
}

