/*******************************************************************************
 * Copyright (c) 2022 Christoph Läubrich and others.
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Christoph Läubrich - initial API and implementation
 ******************************************************************************/
package org.eclipse.tycho.surefire;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.failsafe.VerifyMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.PackagingType;

/**
 * Verifies plugin-test runs from the integration-test stage
 */
@Mojo(name = "verify", defaultPhase = LifecyclePhase.VERIFY, threadSafe = true)
public class TychoVerifyMojo extends VerifyMojo {

    @Parameter(property = "project", readonly = true)
    protected MavenProject project;

    @Parameter(property = "tycho.verify-test.packaging", defaultValue = PackagingType.TYPE_ECLIPSE_PLUGIN)
    private String packaging = PackagingType.TYPE_ECLIPSE_PLUGIN;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (packaging.equals(project.getPackaging())) {
            super.execute();
        }
    }
}
