/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.provisioning;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.sisu.equinox.launching.EquinoxInstallation;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.p2.tools.director.shared.DirectorCommandException;
import org.eclipse.tycho.p2.tools.director.shared.DirectorRuntime;
import org.eclipse.tycho.surefire.provisioning.BundlesPublisher;
import org.eclipse.tycho.surefire.provisioning.ProvisionedEquinoxInstallation;

public class ProvisionedInstallationBuilder {
    private Logger log;
    private BundleReader bundleReader;
    private DirectorRuntime directorRuntime;
    private List<URI> metadataRepos = new ArrayList<URI>();
    private List<URI> artifactRepos = new ArrayList<URI>();
    private List<String> ius = new ArrayList<String>();
    private File workingDir;
    private File effectiveDestination;
    private String profileName;
    private boolean installFeatures = true;
    private BundlesPublisher bundlesPublisher;
    private List<File> bundleJars = new ArrayList<File>();

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    public ProvisionedInstallationBuilder(BundleReader bundleReader, DirectorRuntime directorRuntime, Logger log) {
        this.log = log;
        this.bundleReader = bundleReader;
        this.directorRuntime = directorRuntime;
        this.bundlesPublisher = new BundlesPublisher(log);
    }

    public void addMetadataRepositories(List<URI> uris) {
        this.metadataRepos.addAll(uris);
    }

    public void addArtifactRepositories(List<URI> uris) {
        this.artifactRepos.addAll(uris);
    }

    public void addBundleJar(File bundleJar) {
        this.bundleJars.add(bundleJar);
    }

    public void addIUsToBeInstalled(List<String> ius) {
        this.ius.addAll(ius);
    }

    public void setDestination(File destination) {
        this.effectiveDestination = destination.getName().endsWith(".app") ? new File(destination, "Contents/Eclipse") : destination;
    }

    public File getEffectiveDestination() {
        return this.effectiveDestination;
    }

    public void setProfileName(String name) {
        this.profileName = name;
    }

    public void setInstallFeatures(boolean installFeatures) {
        this.installFeatures = installFeatures;
    }

    public EquinoxInstallation install() throws Exception {
        this.validate();
        this.publishPlainBundleJars();
        this.executeDirector();
        return new ProvisionedEquinoxInstallation(this.effectiveDestination, this.bundleReader);
    }

    private void publishPlainBundleJars() throws Exception {
        if (this.bundleJars.isEmpty()) {
            return;
        }
        for (File bundle : this.bundleJars) {
            this.bundlesPublisher.addBundle(bundle);
        }
        File bundlesRepoDir = new File(this.workingDir, "additionalBundles");
        if (bundlesRepoDir.isDirectory()) {
            FileUtils.deleteDirectory((File)bundlesRepoDir);
        }
        bundlesRepoDir.mkdirs();
        URI bundlesRepoURI = this.bundlesPublisher.publishBundles(bundlesRepoDir);
        this.metadataRepos.add(bundlesRepoURI);
        this.artifactRepos.add(bundlesRepoURI);
    }

    private void executeDirector() throws MojoFailureException {
        DirectorRuntime.Command command = this.directorRuntime.newInstallCommand();
        command.addMetadataSources(this.metadataRepos);
        command.addArtifactSources(this.artifactRepos);
        for (String iu : this.ius) {
            command.addUnitToInstall(iu);
        }
        command.setDestination(this.effectiveDestination);
        command.setProfileName(this.profileName);
        command.setInstallFeatures(this.installFeatures);
        command.setEnvironment(TargetEnvironment.getRunningEnvironment());
        this.log.info("Installing IUs " + this.ius + " to " + this.effectiveDestination);
        try {
            command.execute();
        }
        catch (DirectorCommandException e) {
            throw new MojoFailureException("Installation of IUs " + this.ius + " failed", (Throwable)e);
        }
    }

    private void validate() {
        this.assertNotNull(this.workingDir, "workingDir");
        this.assertNotNull(this.effectiveDestination, "destination");
        this.assertNotEmpty(this.metadataRepos, "metadataRepos");
        this.assertNotEmpty(this.artifactRepos, "artifactRepos");
        this.assertNotEmpty(this.ius, "ius");
    }

    private void assertNotEmpty(Collection<?> collection, String name) {
        if (collection.isEmpty()) {
            throw new IllegalStateException(name + " must not be empty");
        }
    }

    private void assertNotNull(Object object, String name) {
        if (object == null) {
            throw new IllegalStateException(name + " must not be null");
        }
    }
}

