/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.provider.impl;

import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.ClasspathEntry;
import org.eclipse.tycho.surefire.provider.impl.AbstractJUnit5Provider;
import org.eclipse.tycho.surefire.provider.impl.JUnit4Provider;
import org.eclipse.tycho.surefire.provider.impl.ProviderHelper;
import org.eclipse.tycho.surefire.provider.spi.TestFrameworkProvider;
import org.osgi.framework.VersionRange;

@Component(role=TestFrameworkProvider.class, hint="junit5vintage")
public class JUnit5VintageProvider
extends AbstractJUnit5Provider {
    private static final VersionRange JUNIT_VINTAGE_INTERNAL_VERSION_RANGE = new VersionRange("[5.12,6)");

    @Override
    public List<Dependency> getRequiredArtifacts() {
        return List.of(ProviderHelper.newDependency("org.eclipse.tycho.surefire.junit5"), ProviderHelper.newDependency("org.eclipse.tycho", "org.eclipse.tycho.surefire.junit5.vintage"));
    }

    @Override
    public boolean isEnabled(MavenProject project, List<ClasspathEntry> testBundleClassPath, Properties surefireProperties) {
        return JUnit5VintageProvider.isJUnit5(project, testBundleClassPath, JUNIT_VINTAGE_INTERNAL_VERSION_RANGE) && JUnit4Provider.isJUnit4(project, testBundleClassPath);
    }

    @Override
    public VersionRange getVersionRange() {
        return JUNIT_VINTAGE_INTERNAL_VERSION_RANGE;
    }
}

