/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.provider.impl;

import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ClasspathEntry;
import org.eclipse.tycho.surefire.provider.impl.ProviderHelper;
import org.eclipse.tycho.surefire.provider.spi.TestFrameworkProvider;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

@Component(role=TestFrameworkProvider.class, hint="testng")
public class TestNGProvider
implements TestFrameworkProvider {
    private static final String TESTNG_BSN = "org.testng";
    private static final Version VERSION = Version.parseVersion((String)"6.9.10");
    private static final VersionRange VERSION_RANGE = new VersionRange("[6,7)");

    @Override
    public String getType() {
        return "testng";
    }

    @Override
    public Version getVersion() {
        return VERSION;
    }

    @Override
    public String getSurefireProviderClassName() {
        return "org.apache.maven.surefire.testng.TestNGProvider";
    }

    @Override
    public boolean isEnabled(MavenProject project, List<ClasspathEntry> testBundleClassPath, Properties surefireProperties) {
        for (ClasspathEntry classpathEntry : testBundleClassPath) {
            ArtifactKey artifactKey = classpathEntry.getArtifactKey();
            if (!TESTNG_BSN.equals(artifactKey.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Dependency> getRequiredArtifacts() {
        return List.of(ProviderHelper.newDependency("org.eclipse.tycho.surefire.testng"), ProviderHelper.newDependency("org.eclipse.tycho.surefire.testng.fixup"));
    }

    @Override
    public Properties getProviderSpecificProperties() {
        Properties properties = new Properties();
        properties.setProperty("testng.configurator", "org.apache.maven.surefire.testng.conf.TestNG60Configurator");
        return properties;
    }

    @Override
    public VersionRange getVersionRange() {
        return VERSION_RANGE;
    }
}

