/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.targetplatform;

import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.resource.CapReqBuilder;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.tycho.IArtifactFacade;
import org.eclipse.tycho.MavenArtifactRepositoryReference;
import org.eclipse.tycho.targetplatform.TargetDefinition;
import org.eclipse.tycho.targetplatform.TargetDefinitionSyntaxException;
import org.osgi.resource.Requirement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class TargetDefinitionFile
implements TargetDefinition {
    public static final String ELEMENT_LOCATIONS = "locations";
    private static final Map<URI, TargetDefinitionFile> FILE_CACHE = new ConcurrentHashMap<URI, TargetDefinitionFile>();
    private final String origin;
    private List<? extends TargetDefinition.Location> locations;
    private boolean hasIncludeBundles;
    private String targetEE;
    private final List<TargetDefinition.ImplicitDependency> implicitDependencies;
    public static final String FILE_EXTENSION = ".target";
    public static final String APPLICATION_TARGET = "application/target";

    private static String getTextFromChild(Element dom, String childName, String defaultValue) {
        Iterator<Element> iterator = TargetDefinitionFile.getChildren(dom, childName).iterator();
        if (iterator.hasNext()) {
            Element element = iterator.next();
            return element.getTextContent();
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new TargetDefinitionSyntaxException("Missing child element '" + childName + "'");
    }

    private static List<Element> getChildren(Element element, String tagName) {
        NodeList list = element.getChildNodes();
        int length = list.getLength();
        List<Node> nodes = IntStream.range(0, length).mapToObj(list::item).toList();
        return nodes.stream().filter(Element.class::isInstance).map(Element.class::cast).filter(e -> e.getNodeName().equals(tagName)).toList();
    }

    private static Element getChild(Element element, String tagName) {
        List<Element> list = TargetDefinitionFile.getChildren(element, tagName);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private TargetDefinitionFile(Document document, String origin) throws TargetDefinitionSyntaxException {
        this.origin = origin;
        Element dom = document.getDocumentElement();
        this.locations = TargetDefinitionFile.parseLocations(dom);
        this.hasIncludeBundles = TargetDefinitionFile.getChild(dom, "includeBundles") != null;
        this.targetEE = TargetDefinitionFile.parseTargetEE(dom);
        this.implicitDependencies = TargetDefinitionFile.parseImplicitDependencies(dom);
    }

    private static List<TargetDefinition.ImplicitDependency> parseImplicitDependencies(Element dom) {
        ArrayList<TargetDefinition.ImplicitDependency> list = new ArrayList<TargetDefinition.ImplicitDependency>();
        Element implicitDependencies = TargetDefinitionFile.getChild(dom, "implicitDependencies");
        if (implicitDependencies != null) {
            for (Element element : TargetDefinitionFile.getChildren(implicitDependencies, "plugin")) {
                final String id = element.getAttribute("id");
                if (id == null || id.isEmpty()) continue;
                list.add(new TargetDefinition.ImplicitDependency(){

                    @Override
                    public String getId() {
                        return id;
                    }
                });
            }
        }
        return list;
    }

    public static Document parseDocument(InputStream input) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(input);
    }

    public static void writeDocument(Document document, OutputStream outputStream) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(outputStream);){
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(document);
                StreamResult result = new StreamResult(os);
                transformer.transform(source, result);
            }
            catch (TransformerException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public List<? extends TargetDefinition.Location> getLocations() {
        return this.locations;
    }

    @Override
    public boolean hasIncludedBundles() {
        return this.hasIncludeBundles;
    }

    @Override
    public String getOrigin() {
        return this.origin;
    }

    public static TargetDefinitionFile read(File file) {
        return TargetDefinitionFile.read(file.toURI());
    }

    public static TargetDefinitionFile read(URI uri) {
        try {
            return FILE_CACHE.computeIfAbsent(uri.normalize(), key -> {
                TargetDefinitionFile targetDefinitionFile;
                block11: {
                    InputStream input = TargetDefinitionFile.openTargetStream(uri);
                    try {
                        targetDefinitionFile = TargetDefinitionFile.parse(TargetDefinitionFile.parseDocument(input), TargetDefinitionFile.getOrigin(uri));
                        if (input == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                if (input != null) {
                                    try {
                                        input.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (ParserConfigurationException e) {
                                throw new TargetDefinitionSyntaxException("No valid XML parser: " + e.getMessage(), e);
                            }
                            catch (SAXException e) {
                                throw new TargetDefinitionSyntaxException("Target definition is not well-formed XML: " + e.getMessage(), e);
                            }
                        }
                        catch (IOException e) {
                            throw new TargetDefinitionSyntaxException("I/O error while reading target definition file: " + e.getMessage(), e);
                        }
                    }
                    input.close();
                }
                return targetDefinitionFile;
            });
        }
        catch (TargetDefinitionSyntaxException e) {
            throw new RuntimeException("Invalid syntax in target definition " + String.valueOf(uri) + ": " + e.getMessage(), e);
        }
    }

    private static String getOrigin(URI uri) {
        if (TargetDefinitionFile.isDataUrl(uri)) {
            return "<embedded>";
        }
        return uri.toASCIIString();
    }

    private static InputStream openTargetStream(URI uri) throws IOException, MalformedURLException {
        if (TargetDefinitionFile.isDataUrl(uri)) {
            String rawPath = uri.toASCIIString();
            int indexOf = rawPath.indexOf(44);
            if (indexOf > -1) {
                String data = rawPath.substring(indexOf + 1);
                return new ByteArrayInputStream(Base64.getDecoder().decode(data));
            }
            throw new MalformedURLException("invalid data url!");
        }
        return uri.toURL().openStream();
    }

    private static boolean isDataUrl(URI uri) {
        return "data".equals(uri.getScheme());
    }

    public static TargetDefinitionFile parse(Document document, String origin) {
        return new TargetDefinitionFile(document, origin);
    }

    @Override
    public String getTargetEE() {
        return this.targetEE;
    }

    public String toString() {
        return "TargetDefinitionFile[" + this.origin + "]";
    }

    @Override
    public Stream<TargetDefinition.ImplicitDependency> implicitDependencies() {
        return this.implicitDependencies.stream();
    }

    public static File[] listTargetFiles(File folder) {
        File[] targetFiles;
        if (folder.isDirectory() && (targetFiles = folder.listFiles(TargetDefinitionFile::isTargetFile)) != null) {
            return targetFiles;
        }
        return new File[0];
    }

    public static boolean isTargetFile(File file) {
        return file != null && file.isFile() && file.getName().toLowerCase().endsWith(FILE_EXTENSION) && !file.getName().startsWith(".polyglot.");
    }

    private static List<? extends TargetDefinition.Location> parseLocations(Element dom) {
        ArrayList<TargetDefinition.Location> locations = new ArrayList<TargetDefinition.Location>();
        Element locationsDom = TargetDefinitionFile.getChild(dom, ELEMENT_LOCATIONS);
        if (locationsDom != null) {
            for (Element locationDom : TargetDefinitionFile.getChildren(locationsDom, "location")) {
                String type = locationDom.getAttribute("type");
                if ("InstallableUnit".equals(type)) {
                    locations.add(TargetDefinitionFile.parseIULocation(locationDom));
                    continue;
                }
                if ("Directory".equals(type)) {
                    locations.add(new DirectoryTargetLocation(locationDom.getAttribute("path")));
                    continue;
                }
                if ("Profile".equals(type)) {
                    locations.add(new ProfileTargetPlatformLocation(locationDom.getAttribute("path")));
                    continue;
                }
                if ("Feature".equals(type)) {
                    locations.add(new FeatureTargetPlatformLocation(locationDom.getAttribute("path"), locationDom.getAttribute("id"), locationDom.getAttribute("version")));
                    continue;
                }
                if ("Maven".equals(type)) {
                    locations.add(TargetDefinitionFile.parseMavenLocation(locationDom));
                    continue;
                }
                if ("Target".equals(type)) {
                    locations.add(new TargetReference(locationDom.getAttribute("uri")));
                    continue;
                }
                if ("Repository".equals(type)) {
                    locations.add(TargetDefinitionFile.parseRepositoryLocation(locationDom));
                    continue;
                }
                locations.add(new OtherLocation(type));
            }
        }
        return Collections.unmodifiableList(locations);
    }

    private static TargetDefinition.RepositoryLocation parseRepositoryLocation(Element dom) {
        String uri = dom.getAttribute("uri");
        NodeList childNodes = dom.getChildNodes();
        List<Requirement> requirements = IntStream.range(0, childNodes.getLength()).mapToObj(childNodes::item).filter(Element.class::isInstance).map(Element.class::cast).filter(element -> element.getNodeName().equalsIgnoreCase("require")).flatMap(element -> {
            String textContent = element.getTextContent();
            Parameters parameters = new Parameters(textContent);
            return CapReqBuilder.getRequirementsFrom((Parameters)parameters).stream();
        }).toList();
        return new OSGIRepositoryLocation(uri, requirements);
    }

    private static MavenLocation parseMavenLocation(Element dom) {
        LinkedHashSet<String> globalExcludes = new LinkedHashSet<String>();
        for (Element element : TargetDefinitionFile.getChildren(dom, "exclude")) {
            globalExcludes.add(element.getTextContent());
        }
        ArrayList<String> scopes = new ArrayList<String>();
        String scope = dom.getAttribute("includeDependencyScope");
        if (dom.hasAttribute("includeDependencyScopes")) {
            String scopesAttribute = dom.getAttribute("includeDependencyScopes");
            for (String s : scopesAttribute.split(",")) {
                scopes.add(s.strip());
            }
        } else {
            String SCOPE_COMPILE = "compile";
            String SCOPE_TEST = "test";
            String SCOPE_RUNTIME = "runtime";
            String SCOPE_PROVIDED = "provided";
            String SCOPE_SYSTEM = "system";
            if (scope == null || scope.isBlank() || SCOPE_COMPILE.equalsIgnoreCase(scope)) {
                scopes.add(SCOPE_COMPILE);
            } else if (SCOPE_PROVIDED.equalsIgnoreCase(scope)) {
                scopes.add(SCOPE_PROVIDED);
                scopes.add(SCOPE_COMPILE);
                scopes.add(SCOPE_SYSTEM);
                scopes.add(SCOPE_RUNTIME);
            } else if (SCOPE_TEST.equalsIgnoreCase(scope)) {
                scopes.add(SCOPE_TEST);
                scopes.add(SCOPE_COMPILE);
                scopes.add(SCOPE_PROVIDED);
                scopes.add(SCOPE_SYSTEM);
                scopes.add(SCOPE_RUNTIME);
            }
        }
        Element featureTemplate = TargetDefinitionFile.getChild(dom, "feature");
        return new MavenLocation(TargetDefinitionFile.parseRoots(dom, globalExcludes), scopes, TargetDefinitionFile.parseManifestStrategy(dom), Boolean.parseBoolean(dom.getAttribute("includeSource")), TargetDefinitionFile.parseInstructions(dom), TargetDefinitionFile.parseDependencyDepth(dom, scope), TargetDefinitionFile.parseRepositoryReferences(dom), featureTemplate, dom.getAttribute("label"));
    }

    private static IULocation parseIULocation(Element dom) {
        ArrayList<Unit> units = new ArrayList<Unit>();
        for (Element element : TargetDefinitionFile.getChildren(dom, "unit")) {
            String id = element.getAttribute("id");
            String version = element.getAttribute("version");
            if (version == null || version.isBlank()) {
                version = "0.0.0";
            }
            units.add(new Unit(id, version));
        }
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        for (Element node : TargetDefinitionFile.getChildren(dom, "repository")) {
            String id = node.getAttribute("id");
            String uri = node.getAttribute("location");
            repositories.add(new Repository(id, uri));
        }
        String string = dom.getAttribute("followRepositoryReferences");
        TargetDefinition.FollowRepositoryReferences followRepositoryReferences = string == null || string.isEmpty() ? TargetDefinition.FollowRepositoryReferences.DEFAULT : (Boolean.parseBoolean(string) ? TargetDefinition.FollowRepositoryReferences.ENABLED : TargetDefinition.FollowRepositoryReferences.DISABLED);
        return new IULocation(Collections.unmodifiableList(units), Collections.unmodifiableList(repositories), TargetDefinitionFile.parseIncludeMode(dom), Boolean.parseBoolean(dom.getAttribute("includeAllPlatforms")), Boolean.parseBoolean(dom.getAttribute("includeSource")), Boolean.parseBoolean(dom.getAttribute("includeConfigurePhase")), followRepositoryReferences);
    }

    private static String parseTargetEE(Element dom) {
        Attr path;
        Element targetJRE = TargetDefinitionFile.getChild(dom, "targetJRE");
        if (targetJRE != null && (path = targetJRE.getAttributeNode("path")) != null) {
            String pathValue = path.getValue();
            return pathValue.substring(pathValue.lastIndexOf(47) + 1);
        }
        return null;
    }

    private static TargetDefinition.IncludeMode parseIncludeMode(Element dom) {
        Attr attributeValue = dom.getAttributeNode("includeMode");
        if (attributeValue == null || "planner".equals(attributeValue.getTextContent())) {
            return TargetDefinition.IncludeMode.PLANNER;
        }
        if ("slicer".equals(attributeValue.getTextContent())) {
            return TargetDefinition.IncludeMode.SLICER;
        }
        throw new TargetDefinitionSyntaxException("Invalid value for attribute 'includeMode': " + String.valueOf(attributeValue));
    }

    private static TargetDefinition.MavenGAVLocation.MissingManifestStrategy parseManifestStrategy(Element dom) {
        String attributeValue = dom.getAttribute("missingManifest");
        if ("generate".equalsIgnoreCase(attributeValue)) {
            return TargetDefinition.MavenGAVLocation.MissingManifestStrategy.GENERATE;
        }
        if ("ignore".equals(attributeValue)) {
            return TargetDefinition.MavenGAVLocation.MissingManifestStrategy.IGNORE;
        }
        return TargetDefinition.MavenGAVLocation.MissingManifestStrategy.ERROR;
    }

    private static Collection<TargetDefinition.BNDInstructions> parseInstructions(Element dom) {
        ArrayList<2> list = new ArrayList<2>();
        for (Element element : TargetDefinitionFile.getChildren(dom, "instructions")) {
            final String reference = element.getAttribute("reference");
            String text = element.getTextContent();
            final Properties properties = new Properties();
            try {
                properties.load(new StringReader(text));
            }
            catch (IOException e) {
                throw new TargetDefinitionSyntaxException("parsing instructions into properties failed", e);
            }
            list.add(new TargetDefinition.BNDInstructions(){

                @Override
                public String getReference() {
                    if (reference == null) {
                        return "";
                    }
                    return reference;
                }

                @Override
                public Properties getInstructions() {
                    return properties;
                }
            });
        }
        return Collections.unmodifiableCollection(list);
    }

    private static Collection<TargetDefinition.MavenDependency> parseRoots(Element dom, Set<String> globalExcludes) {
        Iterator<Element> iterator = TargetDefinitionFile.getChildren(dom, "dependencies").iterator();
        if (iterator.hasNext()) {
            Element dependencies = iterator.next();
            ArrayList<MavenDependencyRoot> roots = new ArrayList<MavenDependencyRoot>();
            for (Element dependency : TargetDefinitionFile.getChildren(dependencies, "dependency")) {
                roots.add(TargetDefinitionFile.parseDependecyRoot(dependency, globalExcludes));
            }
            return Collections.unmodifiableCollection(roots);
        }
        return Collections.singleton(TargetDefinitionFile.parseDependecyRoot(dom, globalExcludes));
    }

    private static MavenDependencyRoot parseDependecyRoot(Element dom, Set<String> globalExcludes) {
        return new MavenDependencyRoot(TargetDefinitionFile.getTextFromChild(dom, "groupId", null), TargetDefinitionFile.getTextFromChild(dom, "artifactId", null), TargetDefinitionFile.getTextFromChild(dom, "version", null), TargetDefinitionFile.getTextFromChild(dom, "classifier", ""), TargetDefinitionFile.getTextFromChild(dom, "type", "jar"), globalExcludes);
    }

    private static TargetDefinition.MavenGAVLocation.DependencyDepth parseDependencyDepth(Element dom, String scope) {
        if (dom.getAttributeNode("includeDependencyDepth") == null) {
            if (scope == null || scope.isBlank()) {
                return TargetDefinition.MavenGAVLocation.DependencyDepth.NONE;
            }
            return TargetDefinition.MavenGAVLocation.DependencyDepth.INFINITE;
        }
        String attribute = dom.getAttribute("includeDependencyDepth");
        if ("NONE".equalsIgnoreCase(attribute)) {
            return TargetDefinition.MavenGAVLocation.DependencyDepth.NONE;
        }
        if ("DIRECT".equalsIgnoreCase(attribute)) {
            return TargetDefinition.MavenGAVLocation.DependencyDepth.DIRECT;
        }
        if ("INFINITE".equalsIgnoreCase(attribute)) {
            return TargetDefinition.MavenGAVLocation.DependencyDepth.INFINITE;
        }
        return TargetDefinition.MavenGAVLocation.DependencyDepth.NONE;
    }

    private static Collection<MavenArtifactRepositoryReference> parseRepositoryReferences(Element dom) {
        Iterator<Element> iterator = TargetDefinitionFile.getChildren(dom, "repositories").iterator();
        if (iterator.hasNext()) {
            Element dependencies = iterator.next();
            ArrayList<3> list = new ArrayList<3>();
            for (Element repository : TargetDefinitionFile.getChildren(dependencies, "repository")) {
                final String id = TargetDefinitionFile.getTextFromChild(repository, "id", String.valueOf(System.identityHashCode(repository)));
                final String url = TargetDefinitionFile.getTextFromChild(repository, "url", null);
                list.add(new MavenArtifactRepositoryReference(){

                    public String getId() {
                        return id;
                    }

                    public String getUrl() {
                        return url;
                    }
                });
            }
            return Collections.unmodifiableCollection(list);
        }
        return Collections.emptyList();
    }

    private record IULocation(List<Unit> getUnits, List<Repository> getRepositories, TargetDefinition.IncludeMode getIncludeMode, boolean includeAllEnvironments, boolean includeSource, boolean includeConfigurePhase, TargetDefinition.FollowRepositoryReferences followRepositoryReferences) implements TargetDefinition.InstallableUnitLocation
    {
    }

    private static class DirectoryTargetLocation
    extends AbstractPathLocation
    implements TargetDefinition.DirectoryLocation {
        public DirectoryTargetLocation(String path) {
            super(path);
        }

        @Override
        public String getTypeDescription() {
            return "Directory";
        }
    }

    private static class ProfileTargetPlatformLocation
    extends AbstractPathLocation
    implements TargetDefinition.ProfileLocation {
        public ProfileTargetPlatformLocation(String path) {
            super(path);
        }

        @Override
        public String getTypeDescription() {
            return "Profile";
        }
    }

    private static class FeatureTargetPlatformLocation
    extends AbstractPathLocation
    implements TargetDefinition.FeaturesLocation {
        private final String feature;
        private final String version;

        public FeatureTargetPlatformLocation(String path, String feature, String version) {
            super(path);
            this.feature = feature;
            this.version = version;
        }

        @Override
        public String getTypeDescription() {
            return "Feature";
        }

        @Override
        public String getId() {
            return this.feature;
        }

        @Override
        public String getVersion() {
            return this.version;
        }
    }

    private record MavenLocation(Collection<TargetDefinition.MavenDependency> getRoots, Collection<String> getIncludeDependencyScopes, TargetDefinition.MavenGAVLocation.MissingManifestStrategy getMissingManifestStrategy, boolean includeSource, Collection<TargetDefinition.BNDInstructions> getInstructions, TargetDefinition.MavenGAVLocation.DependencyDepth getIncludeDependencyDepth, Collection<MavenArtifactRepositoryReference> getRepositoryReferences, Element getFeatureTemplate, String label) implements TargetDefinition.MavenGAVLocation
    {
        MavenLocation {
            getFeatureTemplate = getFeatureTemplate == null ? null : (Element)getFeatureTemplate.cloneNode(true);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder("MavenDependencyRoots = ");
            builder.append(this.getRoots());
            builder.append(", IncludeDependencyScope = ");
            builder.append(this.getIncludeDependencyScopes());
            builder.append(", MissingManifestStrategy = ");
            builder.append((Object)this.getMissingManifestStrategy());
            builder.append(", IncludeSource = ");
            builder.append(this.includeSource());
            return builder.toString();
        }

        @Override
        public String getLabel() {
            Collection<TargetDefinition.MavenDependency> roots;
            if (this.label != null && !this.label.isBlank()) {
                return this.label;
            }
            Element featureTemplate = this.getFeatureTemplate();
            if (featureTemplate != null) {
                String featureLabel = featureTemplate.getAttribute("label");
                if (featureLabel != null && !featureLabel.isBlank()) {
                    return featureLabel;
                }
                String featureId = featureTemplate.getAttribute("id");
                if (featureId != null && !featureId.isBlank()) {
                    return featureId;
                }
            }
            if ((roots = this.getRoots()).size() == 1) {
                TargetDefinition.MavenDependency dependency = roots.iterator().next();
                return MessageFormat.format("{0}:{1} ({2})", dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
            }
            return MessageFormat.format("{0} Maven Dependencies", roots.size());
        }
    }

    private record TargetReference(String getUri) implements TargetDefinition.TargetReferenceLocation
    {
        @Override
        public String getTypeDescription() {
            return "Target";
        }
    }

    private record OtherLocation(String getTypeDescription) implements TargetDefinition.Location
    {
    }

    private record OSGIRepositoryLocation(String getUri, Collection<Requirement> getRequirements) implements TargetDefinition.RepositoryLocation
    {
    }

    private record Unit(String getId, String getVersion) implements TargetDefinition.Unit
    {
        @Override
        public String toString() {
            return "Unit [id=" + this.getId() + ", version=" + this.getVersion() + "]";
        }
    }

    private record Repository(String getId, String getLocation) implements TargetDefinition.Repository
    {
    }

    private record MavenDependencyRoot(String getGroupId, String getArtifactId, String getVersion, String getClassifier, String getArtifactType, Set<String> globalExcludes) implements TargetDefinition.MavenDependency
    {
        private static String getKey(IArtifactFacade artifact) {
            if (artifact == null) {
                return "";
            }
            String key = artifact.getGroupId() + ":" + artifact.getArtifactId();
            String classifier = artifact.getClassifier();
            if (classifier != null && !classifier.isBlank()) {
                key = key + ":" + classifier;
            }
            key = key + ":" + artifact.getVersion();
            return key;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("GroupId = ");
            builder.append(this.getGroupId());
            builder.append(", ArtifactId = ");
            builder.append(this.getArtifactId());
            builder.append(", Version = ");
            builder.append(this.getVersion());
            builder.append(", ArtifactType = ");
            builder.append(this.getArtifactType());
            builder.append(", IncludeDependencyScope = ");
            return builder.toString();
        }

        @Override
        public boolean isIgnored(IArtifactFacade artifact) {
            return this.globalExcludes.contains(MavenDependencyRoot.getKey(artifact));
        }
    }

    private static abstract class AbstractPathLocation
    implements TargetDefinition.PathLocation {
        private String path;

        public AbstractPathLocation(String path) {
            this.path = path;
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }
}

