/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.targetplatform;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.tycho.targetplatform.TargetDefinitionFile;
import org.eclipse.tycho.targetplatform.TargetPlatformArtifactResolver;
import org.eclipse.tycho.targetplatform.TargetResolveException;

@Singleton
@Named
public class TargetPlatformArtifactResolverImpl
implements TargetPlatformArtifactResolver {
    @Inject
    private RepositorySystem repositorySystem;

    @Override
    public File resolveTargetFile(String groupId, String artifactId, String version, String classifier, MavenSession session, List<ArtifactRepository> remoteRepositories) throws TargetResolveException {
        Optional<File> reactorTargetFile = this.getReactorTargetFile(groupId, artifactId, version, classifier, session);
        if (reactorTargetFile.isPresent()) {
            return reactorTargetFile.get();
        }
        ArtifactRequest request = new ArtifactRequest();
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, "target", version);
        request.setArtifact((Artifact)artifact);
        ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>(RepositoryUtils.toRepos(remoteRepositories));
        repos.add(RepositoryUtils.toRepo((ArtifactRepository)session.getLocalRepository()));
        request.setRepositories(repos);
        try {
            ArtifactResult result = this.repositorySystem.resolveArtifact(session.getRepositorySession(), request);
            File file = result.getArtifact().getFile();
            if (file != null && file.exists()) {
                return file;
            }
        }
        catch (ArtifactResolutionException e) {
            throw new TargetResolveException("Could not resolve target platform specification artifact " + String.valueOf(artifact), e);
        }
        throw new TargetResolveException("Could not resolve target platform specification artifact " + String.valueOf(artifact));
    }

    @Override
    public Optional<File> getReactorTargetFile(String groupId, String artifactId, String version, String classifier, MavenSession session) throws TargetResolveException {
        if (session == null) {
            return Optional.empty();
        }
        List projects = session.getProjects();
        if (projects == null) {
            return Optional.empty();
        }
        for (MavenProject project : projects) {
            if (!groupId.equals(project.getGroupId()) || !artifactId.equals(project.getArtifactId()) || !version.equals(project.getVersion())) continue;
            if (classifier == null || classifier.isBlank()) {
                return Optional.of(TargetPlatformArtifactResolver.getMainTargetFile(project));
            }
            File target = new File(project.getBasedir(), classifier + ".target");
            if (TargetDefinitionFile.isTargetFile(target)) {
                return Optional.of(target);
            }
            throw new TargetResolveException("target definition file '" + String.valueOf(target) + "' not found in project '" + project.getName() + "'.");
        }
        return Optional.empty();
    }
}

