/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.tycho.test.AbstractTychoIntegrationTest;

public class EnvironmentUtil {
    private static final Properties props = new Properties();
    private static final String WINDOWS_OS = "windows";
    private static final String MAC_OS = "mac os x";
    private static final String MAC_OS_DARWIN = "darwin";
    private static final String LINUX_OS = "linux";
    private static final String FREEBSD_OS = "freebsd";
    private static final String OS;

    static synchronized String getProperty(String key) {
        return props.getProperty(key);
    }

    public static boolean isWindows() {
        return OS.startsWith(WINDOWS_OS);
    }

    public static boolean isLinux() {
        return OS.startsWith(LINUX_OS);
    }

    public static boolean isFreeBSD() {
        return OS.startsWith(FREEBSD_OS);
    }

    public static boolean isMac() {
        return OS.startsWith(MAC_OS) || OS.startsWith(MAC_OS_DARWIN);
    }

    public static String getTargetPlatform() {
        return "https:////download.eclipse.org/releases/2019-12/";
    }

    public static String getTestSettings() {
        String value = EnvironmentUtil.getProperty("its-settings");
        if (value == null || value.contains("$")) {
            return null;
        }
        return value;
    }

    public static String getMavenHome() {
        String systemValue = System.getProperty("tychodev-maven.home");
        if (systemValue != null) {
            return systemValue;
        }
        return EnvironmentUtil.getProperty("maven-dir");
    }

    public static String getTychoVersion() {
        return EnvironmentUtil.getProperty("tycho-version");
    }

    public static int getHttpServerPort() {
        String port = EnvironmentUtil.getProperty("server-port");
        return Integer.parseInt(port);
    }

    public static String getLocalRepo() {
        return EnvironmentUtil.getProperty("local-repo");
    }

    static {
        ClassLoader cl = AbstractTychoIntegrationTest.class.getClassLoader();
        try (InputStream is = cl.getResourceAsStream("baseTest.properties");){
            props.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        OS = System.getProperty("os.name").toLowerCase();
    }
}

