/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.tycho.locking.facade.FileLockService;
import org.eclipse.tycho.locking.facade.FileLocker;
import org.eclipse.tycho.test.util.EnvironmentUtil;

@Component(role=LocalMavenRepositoryTool.class)
public class LocalMavenRepositoryTool {
    private File localRepo = new File(EnvironmentUtil.getLocalRepo());
    @Requirement
    private FileLockService fileLockService;

    public LocalMavenRepositoryTool() {
        if (!this.localRepo.isDirectory()) {
            throw new IllegalStateException("Local Maven repository does not exist: " + this.localRepo);
        }
    }

    public File getArtifactFile(String groupId, String artifactId, String version, String classifier, String extension) {
        String groupPath = groupId.replace('.', '/');
        String artifactPath = groupPath + '/' + artifactId + '/' + version;
        String artifactName = artifactId + "-" + version + (classifier == null ? "" : "-" + classifier) + "." + extension;
        return new File(this.localRepo, artifactPath + '/' + artifactName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getArtifactIndexLines() throws IOException {
        File indexFile = this.getArtifactIndexFile();
        FileLocker locker = this.fileLockService.getFileLocker(indexFile);
        locker.lock();
        try {
            Set<String> set = this.readLines(indexFile);
            return set;
        }
        finally {
            locker.release();
        }
    }

    public void removeLinesFromArtifactsIndex(String ... linesToBeRemoved) throws IOException {
        HashSet<String> toBeRemoved = new HashSet<String>(Arrays.asList(linesToBeRemoved));
        File indexFile = this.getArtifactIndexFile();
        this.filterLinesFromIndex(indexFile, toBeRemoved);
    }

    public void removeLinesFromMetadataIndex(String ... linesToBeRemoved) throws IOException {
        HashSet<String> toBeRemoved = new HashSet<String>(Arrays.asList(linesToBeRemoved));
        File indexFile = new File(this.localRepo, ".meta/p2-local-metadata.properties");
        this.filterLinesFromIndex(indexFile, toBeRemoved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterLinesFromIndex(File indexFile, Set<String> toBeRemoved) throws FileNotFoundException, IOException {
        FileLocker locker = this.fileLockService.getFileLocker(indexFile);
        locker.lock();
        try {
            Set<String> currentLines = this.readLines(indexFile);
            currentLines.removeAll(toBeRemoved);
            this.writeLines(indexFile, currentLines);
        }
        finally {
            locker.release();
        }
    }

    private File getArtifactIndexFile() {
        return new File(this.localRepo, ".meta/p2-artifacts.properties");
    }

    private Set<String> readLines(File indexFile) throws FileNotFoundException, IOException {
        LinkedHashSet<String> lines = new LinkedHashSet<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(indexFile), StandardCharsets.UTF_8));){
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
        }
        return lines;
    }

    private void writeLines(File indexFile, Collection<String> lines) throws FileNotFoundException, IOException {
        try (PrintStream writer = new PrintStream(indexFile);){
            for (String line : lines) {
                writer.println(line);
            }
        }
    }
}

