/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.junit.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class P2RepositoryTool {
    private final File repoLocation;
    private final File metadataFile;
    private Document contentXml;
    private XPath xPathTool;
    private Pattern strictVersionRangePattern;

    private P2RepositoryTool(File metadataFile) {
        this.repoLocation = metadataFile.getParentFile();
        this.metadataFile = metadataFile;
    }

    public static P2RepositoryTool forEclipseRepositoryModule(File projectRootFolder) {
        File repoLocation = new File(projectRootFolder, "target/repository");
        File contentXml = new File(repoLocation, "content.xml");
        File contentJar = new File(repoLocation, "content.jar");
        if (contentXml.isFile()) {
            return new P2RepositoryTool(contentXml);
        }
        if (contentJar.isFile()) {
            return new P2RepositoryTool(contentJar);
        }
        throw new IllegalStateException("Not an eclipse-repository project, or project has not been built: " + projectRootFolder);
    }

    public File getBundleArtifact(String bundleId, String version) {
        String pathInRepo = "plugins/" + bundleId + "_" + version + ".jar";
        return new File(this.repoLocation, pathInRepo);
    }

    public File getFeatureArtifact(String featureId, String version) {
        String pathInRepo = "features/" + featureId + "_" + version + ".jar";
        return new File(this.repoLocation, pathInRepo);
    }

    public File getBinaryArtifact(String artifactId, String version) {
        String pathInRepo = "binary/" + artifactId + "_" + version;
        return new File(this.repoLocation, pathInRepo);
    }

    public File findFeatureArtifact(String featureId) {
        File[] matchingFeatures = new File(this.repoLocation, "features").listFiles((dir, name) -> name.startsWith(featureId + "_"));
        return matchingFeatures[0];
    }

    public File findBinaryArtifact(String artifactId) {
        File[] matchingFeatures = new File(this.repoLocation, "binary").listFiles((dir, name) -> name.startsWith(artifactId + "_"));
        return matchingFeatures[0];
    }

    public List<String> getAllUnitIds() throws Exception {
        this.loadMetadata();
        return this.getValues(this.contentXml, "/repository/units/unit/@id");
    }

    public List<IdAndVersion> getAllUnits() throws Exception {
        this.loadMetadata();
        List<Node> units = this.getNodes(this.contentXml, "/repository/units/unit");
        ArrayList<IdAndVersion> result = new ArrayList<IdAndVersion>();
        for (Node node : units) {
            result.add(new IdAndVersion(this.getAttribute(node, "@id"), this.getAttribute(node, "@version")));
        }
        return result;
    }

    public List<String> getUnitVersions(String unitId) throws Exception {
        this.loadMetadata();
        return this.getValues(this.contentXml, "/repository/units/unit[@id='" + unitId + "']/@version");
    }

    public IU getUniqueIU(String unitId) throws Exception {
        this.loadMetadata();
        List<Node> nodes = this.getNodes(this.contentXml, "/repository/units/unit[@id='" + unitId + "']");
        if (nodes.isEmpty()) {
            Assert.fail((String)("Could not find IU with id '" + unitId + "'"));
        } else {
            if (nodes.size() == 1) {
                return new IU(nodes.get(0));
            }
            Assert.fail((String)("Found more than one IU with id '" + unitId + "'"));
        }
        throw new RuntimeException();
    }

    public IU getIU(String unitId, String version) throws Exception {
        this.loadMetadata();
        List<Node> nodes = this.getNodes(this.contentXml, "/repository/units/unit[@id='" + unitId + "' and @version='" + version + "']");
        if (nodes.isEmpty()) {
            Assert.fail((String)("Could not find IU with id '" + unitId + "' and version '" + version + "'"));
        } else {
            if (nodes.size() == 1) {
                return new IU(nodes.get(0));
            }
            Assert.fail((String)("Found more than one IU with id '" + unitId + "' and version '" + version + "'"));
        }
        throw new RuntimeException();
    }

    public List<String> getAllProvidedPackages() throws Exception {
        this.loadMetadata();
        return this.getValues(this.contentXml, "/repository/units/unit/provides/provided[@namespace='java.package']/@name");
    }

    private void loadMetadata() throws Exception {
        if (this.contentXml != null) {
            return;
        }
        if (this.metadataFile.getName().endsWith("jar")) {
            throw new UnsupportedOperationException("Can't read compressed p2 repositories yet");
        }
        this.contentXml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.metadataFile);
    }

    private XPath getXPathTool() {
        if (this.xPathTool == null) {
            this.xPathTool = XPathFactory.newInstance().newXPath();
        }
        return this.xPathTool;
    }

    List<Node> getNodes(Object startingPoint, String expression) throws XPathExpressionException {
        NodeList nodeList = (NodeList)this.getXPathTool().evaluate(expression, startingPoint, XPathConstants.NODESET);
        ArrayList<Node> result = new ArrayList<Node>(nodeList.getLength());
        for (int ix = 0; ix < nodeList.getLength(); ++ix) {
            result.add(nodeList.item(ix));
        }
        return result;
    }

    List<String> getValues(Object startingPoint, String expression) throws XPathExpressionException {
        NodeList nodeList = (NodeList)this.getXPathTool().evaluate(expression, startingPoint, XPathConstants.NODESET);
        ArrayList<String> result = new ArrayList<String>(nodeList.getLength());
        for (int ix = 0; ix < nodeList.getLength(); ++ix) {
            result.add(nodeList.item(ix).getNodeValue());
        }
        return result;
    }

    String getAttribute(Node node, String expression) throws XPathExpressionException {
        Attr attribute = (Attr)this.getXPathTool().evaluate(expression, node, XPathConstants.NODE);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    boolean isStrictRange(String range) {
        if (this.strictVersionRangePattern == null) {
            this.strictVersionRangePattern = Pattern.compile("\\[([^,]*),\\1\\]");
        }
        return this.strictVersionRangePattern.matcher(range).matches();
    }

    String getLowerBound(String range) {
        int begin = range.charAt(0) == '[' || range.charAt(0) == '(' ? 1 : 0;
        int end = range.indexOf(44, begin);
        if (end < 0) {
            end = range.length();
        }
        return range.substring(begin, end);
    }

    public static IdAndVersion withIdAndVersion(String id, String version) {
        return new IdAndVersion(id, version);
    }

    static boolean eq(String left, String right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        return left.equals(right);
    }

    public static final class IdAndVersion {
        public final String id;
        public final String version;

        public IdAndVersion(String id, String version) {
            this.id = id;
            this.version = version;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IdAndVersion)) {
                return false;
            }
            IdAndVersion other = (IdAndVersion)obj;
            return P2RepositoryTool.eq(this.id, other.id) && P2RepositoryTool.eq(this.version, other.version);
        }
    }

    public class IU {
        private final Node unitElement;

        IU(Node unitElement) {
            this.unitElement = unitElement;
        }

        public String getVersion() throws Exception {
            return P2RepositoryTool.this.getAttribute(this.unitElement, "@version");
        }

        public List<String> getProperties() throws Exception {
            List<Node> propertyNodes = P2RepositoryTool.this.getNodes(this.unitElement, "properties/property");
            ArrayList<String> result = new ArrayList<String>(propertyNodes.size());
            for (Node node : propertyNodes) {
                result.add(P2RepositoryTool.this.getAttribute(node, "@name") + "=" + P2RepositoryTool.this.getAttribute(node, "@value"));
            }
            return result;
        }

        public List<String> getRequiredIds() throws Exception {
            ArrayList<String> result = new ArrayList<String>();
            List<Node> requiredIds = P2RepositoryTool.this.getNodes(this.unitElement, "requires/required/@name");
            for (Node id : requiredIds) {
                result.add(id.getNodeValue());
            }
            return result;
        }

        public List<String> getInclusionIds() throws Exception {
            ArrayList<String> result = new ArrayList<String>();
            List<Node> requires = P2RepositoryTool.this.getNodes(this.unitElement, "requires/required");
            for (Node require : requires) {
                String range = P2RepositoryTool.this.getAttribute(require, "@range");
                if (range == null || !P2RepositoryTool.this.isStrictRange(range)) continue;
                result.add(P2RepositoryTool.this.getAttribute(require, "@name"));
            }
            return result;
        }

        public List<IdAndVersion> getInclusions() throws Exception {
            ArrayList<IdAndVersion> result = new ArrayList<IdAndVersion>();
            List<Node> requires = P2RepositoryTool.this.getNodes(this.unitElement, "requires/required");
            for (Node require : requires) {
                String range = P2RepositoryTool.this.getAttribute(require, "@range");
                if (range == null || !P2RepositoryTool.this.isStrictRange(range)) continue;
                result.add(new IdAndVersion(P2RepositoryTool.this.getAttribute(require, "@name"), P2RepositoryTool.this.getLowerBound(range)));
            }
            return result;
        }

        public List<String> getArtifacts() throws Exception {
            ArrayList<String> result = new ArrayList<String>();
            List<Node> artifacts = P2RepositoryTool.this.getNodes(this.unitElement, "artifacts/artifact");
            for (Node node : artifacts) {
                result.add(P2RepositoryTool.this.getAttribute(node, "@classifier") + "/" + P2RepositoryTool.this.getAttribute(node, "@id") + "/" + P2RepositoryTool.this.getAttribute(node, "@version"));
            }
            return result;
        }

        public List<String> getProvidedCapabilities() throws Exception {
            ArrayList<String> result = new ArrayList<String>();
            List<Node> provides = P2RepositoryTool.this.getNodes(this.unitElement, "provides/provided");
            for (Node node : provides) {
                result.add(P2RepositoryTool.this.getAttribute(node, "@namespace") + "/" + P2RepositoryTool.this.getAttribute(node, "@name") + "/" + P2RepositoryTool.this.getAttribute(node, "@version"));
            }
            return result;
        }
    }
}

