/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.maven.it.Verifier;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.tycho.test.util.EnvironmentUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class AbstractTychoIntegrationTest {
    private static final String SYSPROP_STATELOCATION = "tychodev.workspace.state";
    @Rule
    public TestName name = new TestName();

    protected File getBasedir(String test) throws IOException {
        File src = new File("projects", test).getAbsoluteFile();
        File dst = new File("target/projects", this.getClass().getSimpleName() + "/" + this.name.getMethodName() + "/" + test).getAbsoluteFile();
        if (dst.isDirectory()) {
            FileUtils.deleteDirectory((File)dst);
        } else if (dst.isFile() && !dst.delete()) {
            throw new IOException("Can't delete file " + dst.toString());
        }
        FileUtils.copyDirectoryStructure((File)src, (File)dst);
        return dst;
    }

    protected Verifier getVerifier(String test, boolean setTargetPlatform) throws Exception {
        return this.getVerifier(test, setTargetPlatform, AbstractTychoIntegrationTest.getSettings());
    }

    protected Verifier getVerifier(String test, boolean setTargetPlatform, boolean ignoreLocalArtifacts) throws Exception {
        return this.getVerifier(test, setTargetPlatform, AbstractTychoIntegrationTest.getSettings(), ignoreLocalArtifacts);
    }

    protected Verifier getVerifier(String test, boolean setTargetPlatform, File userSettings) throws Exception {
        return this.getVerifier(test, setTargetPlatform, userSettings, true);
    }

    protected Verifier getVerifier(String test, boolean setTargetPlatform, File userSettings, boolean ignoreLocalArtifacts) throws Exception {
        System.setProperty("maven.home", this.getMavenHome());
        File testDir = this.getBasedir(test);
        Verifier verifier = new Verifier(testDir.getAbsolutePath());
        String debug = System.getProperty("tycho.mvnDebug");
        if (debug != null) {
            Object mvnOpts;
            System.out.println("Preparing to execute Maven in debug mode");
            if (debug.startsWith("-")) {
                mvnOpts = debug;
                System.out.println("Using custom debug-opts: " + (String)mvnOpts);
            } else {
                int port;
                try {
                    port = Integer.parseInt(debug);
                }
                catch (RuntimeException e) {
                    port = 8000;
                }
                mvnOpts = "-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + port;
                System.out.println("Listening for transport dt_socket at address: " + port);
            }
            verifier.getEnvironmentVariables().put("MAVEN_OPTS", mvnOpts);
            System.out.flush();
        }
        verifier.getCliOptions().add("-Dmaven.home=" + this.getMavenHome());
        verifier.getCliOptions().add("-Dtycho-version=" + this.getTychoVersion());
        File tmpDir = new File("target/tmp");
        tmpDir.mkdirs();
        verifier.getCliOptions().add("-Djava.io.tmpdir=" + tmpDir.getAbsolutePath());
        if (setTargetPlatform) {
            verifier.getCliOptions().add("-Dtarget-platform=" + this.getTargetPlatform());
        }
        if (ignoreLocalArtifacts) {
            verifier.getCliOptions().add("-Dtycho.localArtifacts=ignore");
        }
        verifier.getCliOptions().add("-X");
        verifier.getCliOptions().add("-s " + userSettings.getAbsolutePath());
        verifier.getVerifierProperties().put("use.mavenRepoLocal", "true");
        verifier.setLocalRepo(EnvironmentUtil.getLocalRepo());
        String customOptions = System.getProperty("it.cliOptions");
        if (customOptions != null && !customOptions.trim().isEmpty()) {
            verifier.getCliOptions().add(customOptions);
        }
        if (System.getProperty(SYSPROP_STATELOCATION) != null) {
            verifier.setForkJvm(false);
            String m2eresolver = System.getProperty("tychodev-maven.ext.class.path");
            if (m2eresolver != null) {
                verifier.addCliOption("-Dmaven.ext.class.path=" + m2eresolver);
            }
        }
        return verifier;
    }

    protected Verifier getVerifier(String test) throws Exception {
        return this.getVerifier(test, true);
    }

    protected String getTargetPlatform() {
        return EnvironmentUtil.getTargetPlatform();
    }

    private static File getSettings() {
        String systemValue = System.getProperty("tycho.testSettings");
        if (systemValue != null) {
            return new File(systemValue);
        }
        String commandLineValue = EnvironmentUtil.getTestSettings();
        if (commandLineValue != null) {
            return new File(commandLineValue);
        }
        return new File("settings.xml");
    }

    protected String getMavenHome() {
        String mavenHome = EnvironmentUtil.getMavenHome();
        if (mavenHome == null) {
            throw new IllegalStateException("Generated test data for the integration tests is missing. Run the launch configuration 'tycho-its - prepare test resources' first.");
        }
        return mavenHome;
    }

    protected String getTychoVersion() {
        return EnvironmentUtil.getTychoVersion();
    }

    protected File[] assertFileExists(File baseDir, String pattern) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(baseDir);
        ds.setIncludes(new String[]{pattern});
        ds.scan();
        File[] includedFiles = (File[])Arrays.stream(ds.getIncludedFiles()).map(file -> new File(baseDir, (String)file)).toArray(File[]::new);
        Assert.assertEquals((String)(baseDir.getAbsolutePath() + "/" + pattern), (long)1L, (long)includedFiles.length);
        Assert.assertTrue((String)(baseDir.getAbsolutePath() + "/" + pattern), (boolean)includedFiles[0].canRead());
        return includedFiles;
    }

    protected void assertDirectoryExists(File targetdir, String pattern) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(targetdir);
        ds.setIncludes(new String[]{pattern});
        ds.scan();
        Assert.assertEquals((String)(targetdir.getAbsolutePath() + "/" + pattern), (long)1L, (long)ds.getIncludedDirectories().length);
        Assert.assertTrue((String)(targetdir.getAbsolutePath() + "/" + pattern), (boolean)new File(targetdir, ds.getIncludedDirectories()[0]).exists());
    }

    protected void assertFileDoesNotExist(File targetdir, String pattern) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(targetdir);
        ds.setIncludes(new String[]{pattern});
        ds.scan();
        Assert.assertEquals((String)(targetdir.getAbsolutePath() + "/" + pattern), (long)0L, (long)ds.getIncludedFiles().length);
    }

    protected String toURI(File file) throws IOException {
        return file.getCanonicalFile().toURI().normalize().toString();
    }
}

