/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.tycho.core.shared.TargetEnvironment;

public class EclipseInstallationTool {
    private File installationRoot;

    private EclipseInstallationTool(File installationRoot) {
        this.installationRoot = installationRoot;
    }

    public static EclipseInstallationTool forInstallationInEclipseRepositoryTarget(File projectRootFolder, String productId, TargetEnvironment env, String pathInArchive) {
        File installationRoot = new File(projectRootFolder, "target/products/" + productId + "/" + env.getOs() + "/" + env.getWs() + "/" + env.getArch());
        if (pathInArchive != null) {
            installationRoot = new File(installationRoot, pathInArchive);
        }
        if (!installationRoot.isDirectory()) {
            throw new IllegalArgumentException("No installation of product " + productId + " for environment " + env + " found at \"" + installationRoot + "\"");
        }
        return new EclipseInstallationTool(installationRoot);
    }

    public List<String> getInstalledFeatureIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (File file : new File(this.installationRoot, "features").listFiles()) {
            int separator = file.getName().lastIndexOf(95);
            if (separator <= 0) continue;
            result.add(file.getName().substring(0, separator));
        }
        return result;
    }
}

