/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.tycho.test.util.XMLTool;
import org.junit.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class P2RepositoryTool {
    private static final Pattern strictVersionRangePattern = Pattern.compile("\\[([^,]*),\\1\\]");
    private final File repoLocation;
    private final File metadataFile;
    private Document contentXml;

    private P2RepositoryTool(File metadataFile) {
        this.repoLocation = metadataFile.getParentFile();
        this.metadataFile = metadataFile;
    }

    public static P2RepositoryTool forEclipseRepositoryModule(File projectRootFolder) {
        File repoLocation = new File(projectRootFolder, "target/repository");
        File contentXml = new File(repoLocation, "content.xml");
        File contentJar = new File(repoLocation, "content.jar");
        if (contentXml.isFile()) {
            return new P2RepositoryTool(contentXml);
        }
        if (contentJar.isFile()) {
            return new P2RepositoryTool(contentJar);
        }
        throw new IllegalStateException("Not an eclipse-repository project, or project has not been built: " + String.valueOf(projectRootFolder));
    }

    public File getBundleArtifact(String bundleId, String version) {
        String pathInRepo = "plugins/" + bundleId + "_" + version + ".jar";
        return new File(this.repoLocation, pathInRepo);
    }

    public File getFeatureArtifact(String featureId, String version) {
        String pathInRepo = "features/" + featureId + "_" + version + ".jar";
        return new File(this.repoLocation, pathInRepo);
    }

    public File getBinaryArtifact(String artifactId, String version) {
        String pathInRepo = "binary/" + artifactId + "_" + version;
        return new File(this.repoLocation, pathInRepo);
    }

    public Optional<File> findFeatureArtifact(String featureId) {
        return this.getFeatures().filter(file -> file.getName().startsWith(featureId + "_")).findFirst();
    }

    public File findBinaryArtifact(String artifactId) {
        File[] matchingFeatures = new File(this.repoLocation, "binary").listFiles((dir, name) -> name.startsWith(artifactId + "_"));
        return matchingFeatures[0];
    }

    public Optional<File> findBundleArtifact(String bundleId) {
        return this.getBundles().filter(file -> file.getName().startsWith(bundleId + "_")).findFirst();
    }

    public Stream<File> getBundles() {
        File[] matching;
        File folder = new File(this.repoLocation, "plugins");
        if (folder.isDirectory() && (matching = folder.listFiles(pathname -> pathname.getName().toLowerCase().endsWith(".jar"))) != null) {
            return Arrays.stream(matching).filter(File::isFile);
        }
        return Stream.empty();
    }

    public Stream<File> getFeatures() {
        File[] matching;
        File folder = new File(this.repoLocation, "features");
        if (folder.isDirectory() && (matching = folder.listFiles(pathname -> pathname.getName().toLowerCase().endsWith(".jar"))) != null) {
            return Arrays.stream(matching).filter(File::isFile);
        }
        return Stream.empty();
    }

    public void assertNumberOfUnits(int expected) throws Exception {
        this.assertNumberOfUnits(expected, always -> false);
    }

    public void assertNumberOfUnits(int expected, Predicate<IdAndVersion> except) throws Exception {
        List<IdAndVersion> units = this.getAllUnits().stream().filter(except.negate()).toList();
        int size = units.size();
        if (size != expected) {
            Assert.fail((String)("Expected " + expected + " units but " + size + " units where found: " + System.lineSeparator() + units.stream().map(String::valueOf).collect(Collectors.joining(System.lineSeparator()))));
        }
    }

    public void assertNumberOfBundles(int expected) throws Exception {
        List<File> bundles = this.getBundles().toList();
        int size = bundles.size();
        if (size != expected) {
            Assert.fail((String)("Expected " + expected + " bundles but " + size + " bundles where found: " + System.lineSeparator() + bundles.stream().map(File::getName).collect(Collectors.joining(System.lineSeparator()))));
        }
    }

    public void assertNumberOfFeatures(int expected) throws Exception {
        List<File> features = this.getFeatures().toList();
        int size = features.size();
        if (size != expected) {
            Assert.fail((String)("Expected " + expected + " features but " + size + " features where found: " + System.lineSeparator() + features.stream().map(File::getName).collect(Collectors.joining(System.lineSeparator()))));
        }
    }

    public List<String> getAllUnitIds() throws Exception {
        this.loadMetadata();
        return P2RepositoryTool.getValues(this.contentXml, "/repository/units/unit/@id");
    }

    public List<IdAndVersion> getAllUnits() throws Exception {
        this.loadMetadata();
        List<Node> units = P2RepositoryTool.getNodes(this.contentXml, "/repository/units/unit");
        ArrayList<IdAndVersion> result = new ArrayList<IdAndVersion>();
        for (Node node : units) {
            result.add(new IdAndVersion(P2RepositoryTool.getAttribute(node, "@id"), P2RepositoryTool.getAttribute(node, "@version")));
        }
        return result;
    }

    public List<String> getUnitVersions(String unitId) throws Exception {
        this.loadMetadata();
        return P2RepositoryTool.getValues(this.contentXml, "/repository/units/unit[@id='" + unitId + "']/@version");
    }

    public IU getUniqueIU(String unitId) throws Exception {
        this.loadMetadata();
        List<Node> nodes = P2RepositoryTool.getNodes(this.contentXml, "/repository/units/unit[@id='" + unitId + "']");
        if (nodes.isEmpty()) {
            Assert.fail((String)("Could not find IU with id '" + unitId + "' from " + String.valueOf(this.metadataFile)));
        } else {
            if (nodes.size() == 1) {
                return new IU(nodes.get(0));
            }
            Assert.fail((String)("Found more than one IU with id '" + unitId + "'"));
        }
        throw new RuntimeException();
    }

    public IU getIU(String unitId, String version) throws Exception {
        this.loadMetadata();
        List<Node> nodes = P2RepositoryTool.getNodes(this.contentXml, "/repository/units/unit[@id='" + unitId + "' and @version='" + version + "']");
        if (nodes.isEmpty()) {
            Assert.fail((String)("Could not find IU with id '" + unitId + "' and version '" + version + "'"));
        } else {
            if (nodes.size() == 1) {
                return new IU(nodes.get(0));
            }
            Assert.fail((String)("Found more than one IU with id '" + unitId + "' and version '" + version + "'"));
        }
        throw new RuntimeException();
    }

    public List<String> getAllProvidedPackages() throws Exception {
        this.loadMetadata();
        return P2RepositoryTool.getValues(this.contentXml, "/repository/units/unit/provides/provided[@namespace='java.package']/@name");
    }

    public List<RepositoryReference> getAllRepositoryReferences() throws Exception {
        this.loadMetadata();
        List<Node> references = P2RepositoryTool.getNodes(this.contentXml, "/repository/references/repository");
        ArrayList<RepositoryReference> result = new ArrayList<RepositoryReference>();
        for (Node reference : references) {
            String uri = P2RepositoryTool.getAttribute(reference, "@uri");
            int type = Integer.parseInt(P2RepositoryTool.getAttribute(reference, "@type"));
            int options = Integer.parseInt(P2RepositoryTool.getAttribute(reference, "@options"));
            result.add(new RepositoryReference(uri, type, options));
        }
        return result;
    }

    private void loadMetadata() throws Exception {
        if (this.contentXml != null) {
            return;
        }
        this.contentXml = this.metadataFile.getName().endsWith("jar") ? XMLTool.parseXMLDocumentFromJar(this.metadataFile, "content.xml") : XMLTool.parseXMLDocument(this.metadataFile);
    }

    static List<Node> getNodes(Object startingPoint, String expression) throws XPathExpressionException {
        return XMLTool.getMatchingNodes(startingPoint, expression);
    }

    static List<String> getValues(Object startingPoint, String expression) throws XPathExpressionException {
        return XMLTool.getMatchingNodesValue(startingPoint, expression);
    }

    static String getAttribute(Node node, String expression) throws XPathExpressionException {
        Attr attribute = (Attr)XMLTool.getFirstMatchingNode(node, expression);
        return attribute != null ? attribute.getValue() : null;
    }

    static boolean isStrictRange(String range) {
        return strictVersionRangePattern.matcher(range).matches();
    }

    static String getLowerBound(String range) {
        int begin = range.charAt(0) == '[' || range.charAt(0) == '(' ? 1 : 0;
        int end = range.indexOf(44, begin);
        if (end < 0) {
            end = range.length();
        }
        return range.substring(begin, end);
    }

    public static IdAndVersion withIdAndVersion(String id, String version) {
        return new IdAndVersion(id, version);
    }

    public record IdAndVersion(String id, String version) {
    }

    public record IU(Node unitElement) {
        public String getVersion() throws Exception {
            return P2RepositoryTool.getAttribute(this.unitElement, "@version");
        }

        public List<String> getProperties() throws Exception {
            List<Node> propertyNodes = P2RepositoryTool.getNodes(this.unitElement, "properties/property");
            ArrayList<String> result = new ArrayList<String>(propertyNodes.size());
            for (Node node : propertyNodes) {
                result.add(P2RepositoryTool.getAttribute(node, "@name") + "=" + P2RepositoryTool.getAttribute(node, "@value"));
            }
            return result;
        }

        public List<String> getRequiredIds() throws Exception {
            return P2RepositoryTool.getValues(this.unitElement, "requires/required/@name");
        }

        public List<String> getUnfilteredRequiredIds() throws Exception {
            return XMLTool.getMatchingNodes(this.unitElement, "requires/required").stream().filter(node -> {
                try {
                    List<Node> nodes = P2RepositoryTool.getNodes(node, "filter");
                    return nodes.isEmpty();
                }
                catch (XPathExpressionException e) {
                    throw new RuntimeException(e);
                }
            }).map(node -> node.getAttributes().getNamedItem("name")).map(Node::getNodeValue).toList();
        }

        public List<String> getInclusionIds() throws Exception {
            ArrayList<String> result = new ArrayList<String>();
            List<Node> requires = P2RepositoryTool.getNodes(this.unitElement, "requires/required");
            for (Node require : requires) {
                String range = P2RepositoryTool.getAttribute(require, "@range");
                if (range == null || !P2RepositoryTool.isStrictRange(range)) continue;
                result.add(P2RepositoryTool.getAttribute(require, "@name"));
            }
            return result;
        }

        public List<IdAndVersion> getInclusions() throws Exception {
            ArrayList<IdAndVersion> result = new ArrayList<IdAndVersion>();
            List<Node> requires = P2RepositoryTool.getNodes(this.unitElement, "requires/required");
            for (Node require : requires) {
                String range = P2RepositoryTool.getAttribute(require, "@range");
                if (range == null || !P2RepositoryTool.isStrictRange(range)) continue;
                result.add(new IdAndVersion(P2RepositoryTool.getAttribute(require, "@name"), P2RepositoryTool.getLowerBound(range)));
            }
            return result;
        }

        public List<String> getArtifacts() throws Exception {
            ArrayList<String> result = new ArrayList<String>();
            List<Node> artifacts = P2RepositoryTool.getNodes(this.unitElement, "artifacts/artifact");
            for (Node node : artifacts) {
                result.add(P2RepositoryTool.getAttribute(node, "@classifier") + "/" + P2RepositoryTool.getAttribute(node, "@id") + "/" + P2RepositoryTool.getAttribute(node, "@version"));
            }
            return result;
        }

        public List<String> getProvidedCapabilities() throws Exception {
            ArrayList<String> result = new ArrayList<String>();
            List<Node> provides = P2RepositoryTool.getNodes(this.unitElement, "provides/provided");
            for (Node node : provides) {
                result.add(P2RepositoryTool.getAttribute(node, "@namespace") + "/" + P2RepositoryTool.getAttribute(node, "@name") + "/" + P2RepositoryTool.getAttribute(node, "@version"));
            }
            return result;
        }
    }

    public record RepositoryReference(String uri, int type, int options) {
    }
}

