/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.tycho.test.AbstractTychoIntegrationTest;

public class EnvironmentUtil {
    private static final String MAVEN_HOME_INFO = "Maven home:";
    public static final String ECLIPSE_LATEST = "https:////download.eclipse.org/releases/2022-12/";
    private static final Properties props = new Properties();
    private static final String WINDOWS_OS = "windows";
    private static final String MAC_OS = "mac os x";
    private static final String MAC_OS_DARWIN = "darwin";
    private static final String LINUX_OS = "linux";
    private static final String FREEBSD_OS = "freebsd";
    private static final String OS;

    static synchronized String getProperty(String key) {
        return props.getProperty(key);
    }

    public static boolean isWindows() {
        return OS.startsWith(WINDOWS_OS);
    }

    public static boolean isLinux() {
        return OS.startsWith(LINUX_OS);
    }

    public static boolean isFreeBSD() {
        return OS.startsWith(FREEBSD_OS);
    }

    public static boolean isMac() {
        return OS.startsWith(MAC_OS) || OS.startsWith(MAC_OS_DARWIN);
    }

    public static String getTargetPlatform() {
        return ECLIPSE_LATEST;
    }

    public static String getTestSettings() {
        String value = EnvironmentUtil.getProperty("its-settings");
        if (value == null || value.contains("$")) {
            return null;
        }
        return value;
    }

    public static String getMavenHome() {
        String systemValue = System.getProperty("tychodev-maven.home");
        if (systemValue != null) {
            return systemValue;
        }
        String property = EnvironmentUtil.getProperty("maven-dir");
        if (property == null) {
            ProcessBuilder pb = new ProcessBuilder("mvn", "-V");
            pb.redirectErrorStream(true);
            try {
                String line;
                Process process = pb.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith(MAVEN_HOME_INFO)) continue;
                    property = line.substring(MAVEN_HOME_INFO.length()).trim();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return property;
    }

    public static String getTychoVersion() {
        String property = EnvironmentUtil.getProperty("tycho-version");
        if (property == null) {
            try {
                List<String> lines = Files.readAllLines(Path.of("pom.xml", new String[0]));
                Pattern pattern = Pattern.compile("<version>(.*)</version>");
                for (String line : lines) {
                    Matcher matcher = pattern.matcher(line);
                    if (!matcher.find()) continue;
                    return matcher.group(1);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return property;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getHttpServerPort() {
        try (ServerSocket serverSocket2222 = new ServerSocket(0);){
            int localPort = serverSocket2222.getLocalPort();
            if (localPort > 0) {
                int n = localPort;
                return n;
            }
        }
        catch (IOException serverSocket2222) {
            // empty catch block
        }
        String port = EnvironmentUtil.getProperty("server-port");
        return Integer.parseInt(port);
    }

    public static String getLocalRepo() {
        String property = EnvironmentUtil.getProperty("local-repo");
        if (property == null) {
            try {
                return Files.createTempDirectory("tycho_its", new FileAttribute[0]).toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return property;
    }

    static {
        ClassLoader cl = AbstractTychoIntegrationTest.class.getClassLoader();
        try (InputStream is = cl.getResourceAsStream("baseTest.properties");){
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        OS = System.getProperty("os.name").toLowerCase();
    }
}

