/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test.util;

import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class TychoMatchers {
    public static <T> Matcher<List<T>> hasSequence(final T ... sequence) {
        if (sequence.length == 0) {
            throw new IllegalArgumentException();
        }
        return new TypeSafeMatcher<List<T>>(){

            public void describeTo(Description description) {
                description.appendValueList("a list with the sequence ", ", ", "", sequence);
            }

            public boolean matchesSafely(List<T> actualList) {
                for (int actualListIx = 0; actualListIx <= actualList.size() - sequence.length; ++actualListIx) {
                    if (!this.sequenceMatches(actualList, actualListIx, sequence)) continue;
                    return true;
                }
                return false;
            }

            private boolean sequenceMatches(List<T> actualList, int actualListIx, T[] sequence2) {
                for (int sequenceIx = 0; sequenceIx < sequence2.length; ++sequenceIx) {
                    if (sequence2[sequenceIx].equals(actualList.get(actualListIx + sequenceIx))) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

