/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.maven.it.VerificationException;
import org.apache.maven.it.Verifier;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.tycho.test.util.EnvironmentUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class AbstractTychoIntegrationTest {
    private static final String SYSPROP_STATELOCATION = "tychodev.workspace.state";
    @Rule
    public TestName name = new TestName();

    protected File getBasedir(String test) throws IOException {
        File src = new File("projects", test).getAbsoluteFile();
        File dst = new File("target/projects", this.getClass().getSimpleName() + "/" + this.name.getMethodName() + "/" + test.replace("../", "./")).getAbsoluteFile();
        if (dst.isDirectory()) {
            FileUtils.deleteDirectory((File)dst);
        } else if (dst.isFile() && !dst.delete()) {
            throw new IOException("Can't delete file " + dst.toString());
        }
        FileUtils.copyDirectoryStructure((File)src, (File)dst);
        return dst;
    }

    protected Verifier getVerifier(String test, boolean setTargetPlatform) throws Exception {
        return this.getVerifier(test, setTargetPlatform, AbstractTychoIntegrationTest.getSettings());
    }

    protected Verifier getVerifier(String test, boolean setTargetPlatform, boolean ignoreLocalArtifacts) throws Exception {
        return this.getVerifier(test, setTargetPlatform, AbstractTychoIntegrationTest.getSettings(), ignoreLocalArtifacts);
    }

    protected Verifier getVerifier(String test, boolean setTargetPlatform, File userSettings) throws Exception {
        return this.getVerifier(test, setTargetPlatform, userSettings, true);
    }

    protected Verifier getVerifier(String test, boolean setTargetPlatform, File userSettings, boolean ignoreLocalArtifacts) throws Exception {
        String debug;
        System.setProperty("maven.home", this.getMavenHome());
        File testDir = this.getBasedir(test);
        Verifier verifier = new Verifier(testDir.getAbsolutePath());
        verifier.setForkJvm(this.isForked());
        if (this.isDisableMirrors()) {
            verifier.setSystemProperty("eclipse.p2.mirrors", "false");
        }
        if ((debug = System.getProperty("tycho.mvnDebug")) != null) {
            Object mvnOpts;
            System.out.println("Preparing to execute Maven in debug mode");
            if (debug.startsWith("-")) {
                mvnOpts = debug;
                System.out.println("Using custom debug-opts: " + (String)mvnOpts);
            } else {
                int port;
                try {
                    port = Integer.parseInt(debug);
                }
                catch (RuntimeException e) {
                    port = 8000;
                }
                mvnOpts = "-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + port;
                System.out.println("Listening for transport dt_socket at address: " + port);
            }
            verifier.getEnvironmentVariables().put("MAVEN_OPTS", mvnOpts);
            System.out.flush();
        }
        verifier.addCliOption("-Dmaven.home=" + this.getMavenHome());
        verifier.addCliOption("-Dtycho-version=" + this.getTychoVersion());
        File tmpDir = new File("target/tmp");
        tmpDir.mkdirs();
        verifier.addCliOption("-Djava.io.tmpdir=" + tmpDir.getAbsolutePath());
        if (setTargetPlatform) {
            verifier.addCliOption("-Dtarget-platform=" + this.getTargetPlatform());
        }
        if (ignoreLocalArtifacts) {
            verifier.addCliOption("-Dtycho.localArtifacts=ignore");
        }
        verifier.addCliOption("-X");
        verifier.addCliOption("-s " + userSettings.getAbsolutePath());
        verifier.getVerifierProperties().put("use.mavenRepoLocal", "true");
        verifier.setLocalRepo(EnvironmentUtil.getLocalRepo());
        String customOptions = System.getProperty("it.cliOptions");
        if (customOptions != null && !customOptions.trim().isEmpty()) {
            verifier.addCliOption(customOptions);
        }
        if (System.getProperty(SYSPROP_STATELOCATION) != null) {
            verifier.setForkJvm(false);
            String m2eresolver = System.getProperty("tychodev-maven.ext.class.path");
            if (m2eresolver != null) {
                verifier.addCliOption("-Dmaven.ext.class.path=" + m2eresolver);
            }
        }
        return verifier;
    }

    protected boolean isDisableMirrors() {
        return true;
    }

    protected boolean isForked() {
        return true;
    }

    protected Verifier getVerifier(String test) throws Exception {
        return this.getVerifier(test, true);
    }

    protected String getTargetPlatform() {
        return EnvironmentUtil.getTargetPlatform();
    }

    private static File getSettings() {
        String systemValue = System.getProperty("tycho.testSettings");
        if (systemValue != null) {
            return new File(systemValue);
        }
        String commandLineValue = EnvironmentUtil.getTestSettings();
        if (commandLineValue != null) {
            return new File(commandLineValue);
        }
        return new File("settings.xml");
    }

    protected String getMavenHome() {
        String mavenHome = EnvironmentUtil.getMavenHome();
        if (mavenHome == null) {
            throw new IllegalStateException("Generated test data for the integration tests is missing. Run the launch configuration 'tycho-its - prepare test resources' first.");
        }
        return mavenHome;
    }

    protected String getTychoVersion() {
        return EnvironmentUtil.getTychoVersion();
    }

    protected File[] assertFileExists(File baseDir, String pattern) {
        DirectoryScanner ds = AbstractTychoIntegrationTest.scan(baseDir, pattern);
        File[] includedFiles = (File[])Arrays.stream(ds.getIncludedFiles()).map(file -> new File(baseDir, (String)file)).toArray(File[]::new);
        Assert.assertEquals((String)(baseDir.getAbsolutePath() + "/" + pattern + System.lineSeparator() + Arrays.stream(includedFiles).map(f -> f.getName()).collect(Collectors.joining(System.lineSeparator()))), (long)1L, (long)includedFiles.length);
        Assert.assertTrue((String)(baseDir.getAbsolutePath() + "/" + pattern), (boolean)includedFiles[0].canRead());
        return includedFiles;
    }

    protected void assertDirectoryExists(File targetdir, String pattern) {
        DirectoryScanner ds = AbstractTychoIntegrationTest.scan(targetdir, pattern);
        Assert.assertEquals((String)(targetdir.getAbsolutePath() + "/" + pattern), (long)1L, (long)ds.getIncludedDirectories().length);
        Assert.assertTrue((String)(targetdir.getAbsolutePath() + "/" + pattern), (boolean)new File(targetdir, ds.getIncludedDirectories()[0]).exists());
    }

    protected void assertFileDoesNotExist(File targetdir, String pattern) {
        DirectoryScanner ds = AbstractTychoIntegrationTest.scan(targetdir, pattern);
        Assert.assertEquals((String)(targetdir.getAbsolutePath() + "/" + pattern), (long)0L, (long)ds.getIncludedFiles().length);
    }

    protected void assertDirectoryDoesNotExist(File baseDir, String pattern) {
        DirectoryScanner ds = AbstractTychoIntegrationTest.scan(baseDir, pattern);
        Assert.assertEquals((String)(baseDir.getAbsolutePath() + "/" + pattern), (long)0L, (long)ds.getIncludedDirectories().length);
    }

    private static DirectoryScanner scan(File targetdir, String pattern) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(targetdir);
        ds.setIncludes(new String[]{pattern});
        ds.scan();
        return ds;
    }

    protected String toURI(File file) throws IOException {
        return file.getCanonicalFile().toURI().normalize().toString();
    }

    public static void verifyTextInLogMatches(Verifier verifier, Pattern pattern) throws VerificationException {
        List lines = verifier.loadFile(verifier.getBasedir(), verifier.getLogFileName(), false);
        for (String line : lines) {
            if (!pattern.matcher(Verifier.stripAnsi((String)line)).find()) continue;
            return;
        }
        throw new VerificationException("Pattern not found in log: " + pattern);
    }

    public static void verifyTextNotInLog(Verifier verifier, String text) throws VerificationException {
        List lines = verifier.loadFile(verifier.getBasedir(), verifier.getLogFileName(), false);
        for (String line : lines) {
            if (!Verifier.stripAnsi((String)line).contains(text)) continue;
            throw new VerificationException("Text '" + text + "' was found in the log!");
        }
    }

    protected static void verifyErrorFreeLog(Verifier verifier) throws VerificationException {
        List lines = verifier.loadFile(verifier.getBasedir(), verifier.getLogFileName(), false);
        int size = lines.size();
        Pattern pattern = Pattern.compile("\\[\\w+\\]");
        for (int i = 0; i < size; ++i) {
            String line = (String)lines.get(i);
            if (!Verifier.stripAnsi((String)line).contains("[ERROR]")) continue;
            String collect = IntStream.range(i, size).mapToObj(lines::get).takeWhile(l -> l.contains("[ERROR]") || !pattern.matcher((CharSequence)l).find()).collect(Collectors.joining(System.lineSeparator()));
            throw new VerificationException("Error in execution: " + collect);
        }
    }
}

