/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.jar.JarFile;
import java.util.stream.IntStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLTool {
    private static final DocumentBuilderFactory FACTORY;
    private static final ThreadLocal<XPath> XPATH_TOOL;

    private XMLTool() {
    }

    public static Document parseXMLDocument(File file) throws SAXException, IOException, ParserConfigurationException {
        return FACTORY.newDocumentBuilder().parse(file);
    }

    public static Document parseXMLDocumentFromJar(File jarFile, String entryPath) throws SAXException, IOException, ParserConfigurationException {
        try (JarFile jar = new JarFile(jarFile);){
            Document document;
            block11: {
                InputStream stream = jar.getInputStream(jar.getEntry(entryPath));
                try {
                    document = FACTORY.newDocumentBuilder().parse(stream);
                    if (stream == null) break block11;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stream.close();
            }
            return document;
        }
    }

    private static Object evaluateXPath(Object startingPoint, String xpathExpression, QName returnType) throws XPathExpressionException {
        return XPATH_TOOL.get().evaluate(xpathExpression, startingPoint, returnType);
    }

    public static Node getFirstMatchingNode(Object startingPoint, String xpathExpression) throws XPathExpressionException {
        return (Node)XMLTool.evaluateXPath(startingPoint, xpathExpression, XPathConstants.NODE);
    }

    public static List<Node> getMatchingNodes(Object startingPoint, String xpathExpression) throws XPathExpressionException {
        NodeList nodeList = (NodeList)XMLTool.evaluateXPath(startingPoint, xpathExpression, XPathConstants.NODESET);
        return IntStream.range(0, nodeList.getLength()).mapToObj(nodeList::item).toList();
    }

    public static List<String> getMatchingNodesValue(Object startingPoint, String xpathExpression) throws XPathExpressionException {
        return XMLTool.getMatchingNodes(startingPoint, xpathExpression).stream().map(Node::getNodeValue).toList();
    }

    static {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        FACTORY = factory;
        XPATH_TOOL = ThreadLocal.withInitial(() -> XPathFactory.newInstance().newXPath());
    }
}

