/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.testing;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.testing.stubs.StubArtifactRepository;
import org.apache.maven.session.scope.internal.SessionScope;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.testing.TestUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public class TychoPlexusTestCase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    PlexusTestCaseExension ext = new PlexusTestCaseExension();

    @After
    public void tearDown() throws ComponentLookupException {
        SessionScope sessionScope = (SessionScope)this.ext.getContainer().lookup(SessionScope.class);
        sessionScope.exit();
        this.ext.teardownContainer();
    }

    protected PlexusContainer getContainer() {
        return this.ext.getContainer();
    }

    @Before
    public void setUpServiceAndSession() throws ComponentLookupException, IOException {
        LegacySupport legacySupport = this.lookup(LegacySupport.class);
        PlexusContainer container = this.ext.getContainer();
        Settings settings = new Settings();
        StubArtifactRepository localRepository = new StubArtifactRepository(this.temporaryFolder.newFolder().getAbsolutePath()){
            DefaultRepositoryLayout layout;
            {
                this.layout = new DefaultRepositoryLayout();
            }

            public String pathOf(Artifact artifact) {
                return this.layout.pathOf(artifact);
            }
        };
        MavenSession mavenSession = new MavenSession(container, settings, (ArtifactRepository)localRepository, null, null, List.of(), this.temporaryFolder.newFolder().getAbsolutePath(), System.getProperties(), System.getProperties(), new Date());
        SessionScope sessionScope = (SessionScope)container.lookup(SessionScope.class);
        mavenSession.setProjects(Collections.emptyList());
        sessionScope.enter();
        sessionScope.seed(MavenSession.class, (Object)mavenSession);
        legacySupport.setSession(mavenSession);
        this.modifySession(mavenSession);
        Collection<EquinoxServiceFactory> coreFactory = this.lookupList(EquinoxServiceFactory.class);
        for (EquinoxServiceFactory factory : coreFactory) {
            try {
                factory.getService(Object.class);
            }
            catch (Exception exception) {}
        }
    }

    public static String getBasedir() {
        return PlexusTestCaseExension.getBasedir();
    }

    protected void modifySession(MavenSession mavenSession) {
    }

    public final <T> T lookup(Class<T> role) throws ComponentLookupException {
        return (T)this.ext.getContainer().lookup(role);
    }

    public final <T> T lookup(Class<T> role, String hint) throws ComponentLookupException {
        return (T)this.ext.getContainer().lookup(role, hint);
    }

    public final <T> Collection<T> lookupList(Class<T> role) throws ComponentLookupException {
        return this.ext.getContainer().lookupList(role);
    }

    public static File resourceFile(String path) {
        File resolvedFile = new File("src/test/resources", path).getAbsoluteFile();
        if (!resolvedFile.canRead()) {
            throw new IllegalStateException("Test resource \"" + path + "\" not found under \"src/test/resources\" in the project");
        }
        return resolvedFile;
    }

    protected static File getBasedir(String name) throws IOException {
        return TestUtil.getBasedir(name);
    }

    private static final class PlexusTestCaseExension
    extends PlexusTestCase {
        private PlexusTestCaseExension() {
        }

        protected void customizeContainerConfiguration(ContainerConfiguration configuration) {
            configuration.setAutoWiring(true);
            configuration.setClassPathScanning("index");
        }

        public synchronized void setupContainer() {
            super.setupContainer();
        }

        public synchronized void teardownContainer() {
            super.teardownContainer();
        }

        public PlexusContainer getContainer() {
            return super.getContainer();
        }
    }
}

