/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.tycho.versions.AbstractVersionsMojo;
import org.eclipse.tycho.versions.engine.ProjectMetadataReader;
import org.eclipse.tycho.versions.engine.VersionsEngine;

@Mojo(name="set-version", aggregator=true, requiresDirectInvocation=true)
public class SetMojo
extends AbstractVersionsMojo {
    @Parameter(property="newVersion", required=true)
    private String newVersion;
    @Parameter(property="artifacts", defaultValue="${project.artifactId}")
    private String artifacts;
    @Parameter(property="updateVersionRangeMatchingBounds", defaultValue="false")
    private boolean updateVersionRangeMatchingBounds;
    @Parameter(property="properties")
    private String properties;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.newVersion == null || this.newVersion.length() == 0) {
            throw new MojoExecutionException("Missing required parameter newVersion");
        }
        VersionsEngine engine = this.newEngine();
        engine.setUpdateVersionRangeMatchingBounds(this.updateVersionRangeMatchingBounds);
        ProjectMetadataReader metadataReader = this.newProjectMetadataReader();
        try {
            metadataReader.addBasedir(this.session.getCurrentProject().getBasedir());
            engine.setProjects(metadataReader.getProjects());
            for (String artifactId : SetMojo.split(this.artifacts)) {
                engine.addVersionChange(artifactId, this.newVersion);
                for (String propertyName : SetMojo.split(this.properties)) {
                    engine.addPropertyChange(artifactId, propertyName, this.newVersion);
                }
            }
            engine.apply();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not set version", (Exception)e);
        }
    }

    private VersionsEngine newEngine() throws MojoFailureException {
        return this.lookup(VersionsEngine.class);
    }

    private static List<String> split(String str) {
        ArrayList<String> result = new ArrayList<String>();
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, ",");
            while (st.hasMoreTokens()) {
                result.add(st.nextToken().trim());
            }
        }
        return result;
    }
}

