/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.engine;

import org.eclipse.tycho.versions.engine.ImportRefVersionConstraint;
import org.eclipse.tycho.versions.engine.VersionRangeUpdateStrategy;
import org.eclipse.tycho.versions.engine.Versions;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class DefaultVersionRangeUpdateStrategy
implements VersionRangeUpdateStrategy {
    private final boolean updateMatchingBounds;

    public DefaultVersionRangeUpdateStrategy(boolean updateMatchingBounds) {
        this.updateMatchingBounds = updateMatchingBounds;
    }

    @Override
    public String computeNewVersionRange(String originalVersionRange, String originalReferencedVersion, String newReferencedVersion) {
        if (originalVersionRange == null) {
            return null;
        }
        VersionRange originalVersionRangeObject = VersionRange.valueOf((String)originalVersionRange);
        Version originalReferencedVersionObject = this.parseBaseVersion(originalReferencedVersion);
        Version newReferencedVersionObject = this.parseBaseVersion(newReferencedVersion);
        VersionRange newVersionRangeObject = this.computeNewVersionRange(originalVersionRangeObject, originalReferencedVersionObject, newReferencedVersionObject);
        return newVersionRangeObject.toString();
    }

    private Version parseBaseVersion(String version) {
        String baseVersion = Versions.toBaseVersion(version);
        return Version.valueOf((String)baseVersion);
    }

    private VersionRange computeNewVersionRange(VersionRange versionRange, Version originalReferencedVersion, Version newReferencedVersion) {
        VersionRange newVersionRange = this.updateMatchingBounds ? this.handleMatchingBouds(versionRange, originalReferencedVersion, newReferencedVersion) : versionRange;
        return this.handleNewlyOutOfScopeVersions(newVersionRange, originalReferencedVersion, newReferencedVersion);
    }

    private VersionRange handleMatchingBouds(VersionRange versionRange, Version originalReferencedVersion, Version newReferencedVersion) {
        Version newLeft = versionRange.getLeft().equals((Object)originalReferencedVersion) ? newReferencedVersion : versionRange.getLeft();
        Version newRight = versionRange.getRight() != null && versionRange.getRight().equals((Object)originalReferencedVersion) ? newReferencedVersion : versionRange.getRight();
        return new VersionRange(versionRange.getLeftType(), newLeft, newRight, versionRange.getRightType());
    }

    private VersionRange handleNewlyOutOfScopeVersions(VersionRange versionRange, Version originalReferencedVersion, Version newReferencedVersion) {
        if (versionRange.includes(originalReferencedVersion) && !versionRange.includes(newReferencedVersion)) {
            versionRange = newReferencedVersion.compareTo(originalReferencedVersion) > 0 ? this.updateRightBound(versionRange, ']', newReferencedVersion) : this.updateLeftBound(versionRange, '[', newReferencedVersion);
        }
        return versionRange;
    }

    private VersionRange updateLeftBound(VersionRange range, char leftType, Version leftVersion) {
        return new VersionRange(leftType, leftVersion, range.getRight(), range.getRightType());
    }

    private VersionRange updateRightBound(VersionRange range, char rightType, Version rightVersion) {
        return new VersionRange(range.getLeftType(), range.getLeft(), rightVersion, rightType);
    }

    @Override
    public ImportRefVersionConstraint computeNewImportRefVersionConstraint(ImportRefVersionConstraint originalVersionConstraint, String originalReferencedVersion, String newReferencedVersion) {
        if (originalVersionConstraint.getVersion() == null) {
            return originalVersionConstraint;
        }
        ImportRefVersionConstraint versionConstraintUsingBaseVersion = this.toBaseVersionConstraint(originalVersionConstraint);
        String referencedBaseVersion = Versions.toBaseVersion(originalReferencedVersion);
        String newReferencedBaseVersion = Versions.toBaseVersion(newReferencedVersion);
        if (this.updateMatchingBounds && versionConstraintUsingBaseVersion.getVersion().equals(referencedBaseVersion) || versionConstraintUsingBaseVersion.matches(referencedBaseVersion) && !versionConstraintUsingBaseVersion.matches(newReferencedBaseVersion)) {
            return originalVersionConstraint.withVersion(newReferencedBaseVersion);
        }
        return originalVersionConstraint;
    }

    private ImportRefVersionConstraint toBaseVersionConstraint(ImportRefVersionConstraint originalVersionConstraint) {
        if (originalVersionConstraint.getVersion() != null) {
            return new ImportRefVersionConstraint(Versions.toBaseVersion(originalVersionConstraint.getVersion()), originalVersionConstraint.getMatch());
        }
        return originalVersionConstraint;
    }
}

