/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.engine;

import org.eclipse.tycho.versions.engine.Versions;
import org.eclipse.tycho.versions.pom.PomFile;

public class VersionChange {
    protected final String newVersion;
    private final PomFile pom;
    private final String version;

    public VersionChange(PomFile pom, String newVersion) {
        this(pom, pom.getVersion(), newVersion);
    }

    public VersionChange(PomFile pom, String version, String newVersion) {
        this.pom = pom;
        this.version = Versions.toCanonicalVersion(version);
        this.newVersion = Versions.toCanonicalVersion(newVersion);
    }

    public String getGroupId() {
        return this.pom.getGroupId();
    }

    public String getArtifactId() {
        return this.pom.getArtifactId();
    }

    public String getVersion() {
        return this.version;
    }

    public PomFile getProject() {
        return this.pom;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public int hashCode() {
        int hash = this.version.hashCode();
        hash = 17 * hash + this.newVersion.hashCode();
        hash = 17 * hash + this.pom.getGroupId().hashCode();
        hash = 17 * hash + this.pom.getArtifactId().hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VersionChange)) {
            return false;
        }
        VersionChange other = (VersionChange)obj;
        return this.version.equals(other.version) && this.newVersion.equals(other.newVersion) && this.pom.getGroupId().equals(other.pom.getGroupId()) && this.pom.getArtifactId().equals(other.getArtifactId());
    }

    public String toString() {
        return this.pom.getGroupId() + ":" + this.pom.getArtifactId() + ":" + this.version + " => " + this.newVersion;
    }
}

