/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.engine;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.tycho.versions.engine.PackageVersionChange;
import org.eclipse.tycho.versions.engine.PomVersionChange;
import org.eclipse.tycho.versions.engine.VersionChange;
import org.eclipse.tycho.versions.engine.VersionRangeUpdateStrategy;

public class VersionChangesDescriptor {
    private final Set<PomVersionChange> aritfactsVersionChanges;
    private final Set<PackageVersionChange> packageVersionChanges;
    private final VersionRangeUpdateStrategy versionRangeUpdateStrategy;

    public VersionChangesDescriptor(Set<PomVersionChange> originalVersionChanges, VersionRangeUpdateStrategy versionRangeUpdateStrategy) {
        this.aritfactsVersionChanges = new HashSet<PomVersionChange>(originalVersionChanges);
        this.versionRangeUpdateStrategy = versionRangeUpdateStrategy;
        this.packageVersionChanges = new HashSet<PackageVersionChange>();
    }

    public Set<PomVersionChange> getVersionChanges() {
        return Collections.unmodifiableSet(new HashSet<PomVersionChange>(this.aritfactsVersionChanges));
    }

    public boolean addVersionChange(PomVersionChange versionChange) {
        return this.aritfactsVersionChanges.add(versionChange);
    }

    public VersionChange findVersionChangeByArtifactId(String symbolicName) {
        for (PomVersionChange versionChange : this.aritfactsVersionChanges) {
            if (!versionChange.getArtifactId().equals(symbolicName)) continue;
            return versionChange;
        }
        return null;
    }

    public Set<PackageVersionChange> getPackageVersionChanges() {
        return Collections.unmodifiableSet(this.packageVersionChanges);
    }

    public VersionRangeUpdateStrategy getVersionRangeUpdateStrategy() {
        return this.versionRangeUpdateStrategy;
    }

    public boolean addPackageVersionChanges(Set<PackageVersionChange> changes) {
        return this.packageVersionChanges.addAll(changes);
    }

    public PackageVersionChange findPackageVersionChange(String packageName) {
        for (PackageVersionChange versionChange : this.packageVersionChanges) {
            if (!versionChange.getPackageName().equals(packageName)) continue;
            return versionChange;
        }
        return null;
    }
}

