/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.manipulation;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.versions.bundle.MutableBundleManifest;
import org.eclipse.tycho.versions.engine.MetadataManipulator;
import org.eclipse.tycho.versions.engine.PackageVersionChange;
import org.eclipse.tycho.versions.engine.PomVersionChange;
import org.eclipse.tycho.versions.engine.ProjectMetadata;
import org.eclipse.tycho.versions.engine.VersionChange;
import org.eclipse.tycho.versions.engine.VersionChangesDescriptor;
import org.eclipse.tycho.versions.engine.Versions;
import org.eclipse.tycho.versions.manipulation.AbstractMetadataManipulator;

@Component(role=MetadataManipulator.class, hint="bundle-manifest")
public class BundleManifestManipulator
extends AbstractMetadataManipulator {
    @Override
    public boolean addMoreChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        if (this.isBundle(project)) {
            Set<PackageVersionChange> changes = this.computeExportedPackageChanges(project, versionChangeContext);
            return versionChangeContext.addPackageVersionChanges(changes);
        }
        return false;
    }

    @Override
    public Collection<String> validateChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        VersionChange versionChangeForProject;
        if (this.isBundle(project) && (versionChangeForProject = this.findVersionChangeForProject(project, versionChangeContext)) != null) {
            String error = Versions.validateOsgiVersion(versionChangeForProject.getNewVersion(), this.getManifestFile(project));
            return error != null ? Collections.singleton(error) : null;
        }
        return null;
    }

    @Override
    public void applyChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        if (this.isBundle(project)) {
            this.updateBundleAndExportPackageVersions(project, versionChangeContext);
            this.updateFragmentHostVersion(project, versionChangeContext);
            this.updateRequireBundleVersions(project, versionChangeContext);
            this.updateImportPackageVersions(project, versionChangeContext);
        }
    }

    @Override
    public void writeMetadata(ProjectMetadata project) throws IOException {
        MutableBundleManifest mf = project.getMetadata(MutableBundleManifest.class);
        if (mf != null) {
            MutableBundleManifest.write(mf, this.getManifestFile(project));
        }
    }

    private Set<PackageVersionChange> computeExportedPackageChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        VersionChange versionChangeForProject = this.findVersionChangeForProject(project, versionChangeContext);
        if (versionChangeForProject == null) {
            return Collections.emptySet();
        }
        MutableBundleManifest mf = this.getBundleManifest(project);
        String versionToReplace = Versions.toBaseVersion(versionChangeForProject.getVersion());
        String newVersion = Versions.toBaseVersion(versionChangeForProject.getNewVersion());
        HashSet<PackageVersionChange> packageVersionChanges = new HashSet<PackageVersionChange>();
        for (Map.Entry<String, String> exportedPackageVersion : mf.getExportedPackagesVersion().entrySet()) {
            String packageName = exportedPackageVersion.getKey();
            String packageVersion = exportedPackageVersion.getValue();
            if (packageVersion == null || !packageVersion.equals(versionToReplace)) continue;
            packageVersionChanges.add(new PackageVersionChange(mf.getSymbolicName(), packageName, packageVersion, newVersion));
        }
        return packageVersionChanges;
    }

    private VersionChange findVersionChangeForProject(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        MutableBundleManifest mf = this.getBundleManifest(project);
        VersionChange versionChangeForProject = versionChangeContext.findVersionChangeByArtifactId(mf.getSymbolicName());
        if (versionChangeForProject != null && versionChangeForProject.getVersion().equals(mf.getVersion())) {
            return versionChangeForProject;
        }
        return null;
    }

    private void updateBundleAndExportPackageVersions(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        MutableBundleManifest mf = this.getBundleManifest(project);
        VersionChange versionChangeForProject = this.findVersionChangeForProject(project, versionChangeContext);
        if (versionChangeForProject != null) {
            this.logger.info("  META-INF/MANIFEST.MF//Bundle-Version: " + versionChangeForProject.getVersion() + " => " + versionChangeForProject.getNewVersion());
            mf.setVersion(versionChangeForProject.getNewVersion());
            HashMap<String, String> exportPackagesNewVersion = new HashMap<String, String>();
            for (PackageVersionChange packageVersionChange : versionChangeContext.getPackageVersionChanges()) {
                if (!packageVersionChange.getBundleSymbolicName().equals(mf.getSymbolicName())) continue;
                this.logger.info("  META-INF/MANIFEST.MF//Export-Package//" + packageVersionChange.getPackageName() + ";version: " + packageVersionChange.getVersion() + " => " + packageVersionChange.getNewVersion());
                exportPackagesNewVersion.put(packageVersionChange.getPackageName(), packageVersionChange.getNewVersion());
            }
            mf.updateExportedPackageVersions(exportPackagesNewVersion);
        }
    }

    private void updateFragmentHostVersion(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        VersionChange versionChange;
        MutableBundleManifest mf = this.getBundleManifest(project);
        if (mf.isFragment() && (versionChange = versionChangeContext.findVersionChangeByArtifactId(mf.getFragmentHostSymbolicName())) != null) {
            String newVersionRange = versionChangeContext.getVersionRangeUpdateStrategy().computeNewVersionRange(mf.getFragmentHostVersion(), versionChange.getVersion(), versionChange.getNewVersion());
            this.logger.info("  META-INF/MANIFEST.MF//Fragment-Host//" + mf.getFragmentHostSymbolicName() + ";bundle-version: " + newVersionRange + " => " + newVersionRange);
            mf.setFragmentHostVersion(newVersionRange);
        }
    }

    private void updateRequireBundleVersions(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        MutableBundleManifest mf = this.getBundleManifest(project);
        Map<String, String> requiredBundleVersions = mf.getRequiredBundleVersions();
        HashMap<String, String> versionsToUpdate = new HashMap<String, String>();
        for (PomVersionChange versionChange : versionChangeContext.getVersionChanges()) {
            String bundleSymbolicName = versionChange.getArtifactId();
            if (!requiredBundleVersions.containsKey(bundleSymbolicName)) continue;
            String originalVersionRange = requiredBundleVersions.get(bundleSymbolicName);
            versionsToUpdate.put(bundleSymbolicName, versionChangeContext.getVersionRangeUpdateStrategy().computeNewVersionRange(originalVersionRange, versionChange.getVersion(), versionChange.getNewVersion()));
        }
        mf.updateRequiredBundleVersions(versionsToUpdate);
    }

    private void updateImportPackageVersions(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        MutableBundleManifest mf = this.getBundleManifest(project);
        HashMap<String, String> importedPackageNewVersions = new HashMap<String, String>();
        for (Map.Entry<String, String> importPackageVersions : mf.getImportPackagesVersions().entrySet()) {
            PackageVersionChange versionChange;
            String packageName = importPackageVersions.getKey();
            String importVersionRange = importPackageVersions.getValue();
            if (importVersionRange == null || (versionChange = versionChangeContext.findPackageVersionChange(packageName)) == null) continue;
            String newVersionRange = versionChangeContext.getVersionRangeUpdateStrategy().computeNewVersionRange(importVersionRange, versionChange.getVersion(), versionChange.getNewVersion());
            this.logger.info("  META-INF/MANIFEST.MF//Import-Package//" + packageName + ";version: " + importVersionRange + " => " + newVersionRange);
            importedPackageNewVersions.put(packageName, newVersionRange);
        }
        mf.updateImportedPackageVersions(importedPackageNewVersions);
    }

    private MutableBundleManifest getBundleManifest(ProjectMetadata project) {
        MutableBundleManifest mf = project.getMetadata(MutableBundleManifest.class);
        if (mf == null) {
            File file = this.getManifestFile(project);
            try {
                mf = MutableBundleManifest.read(file);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not parse bundle manifest " + file, e);
            }
            project.putMetadata(mf);
        }
        return mf;
    }

    private File getManifestFile(ProjectMetadata project) {
        return new File(project.getBasedir(), "META-INF/MANIFEST.MF");
    }
}

