/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.bundle;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.eclipse.tycho.versions.bundle.MutableManifestElement;
import org.osgi.framework.BundleException;

public class ManifestAttribute {
    private static final String ELEMENT_SEPARATOR = ",\n ";
    private final StringBuilder content = new StringBuilder();

    public ManifestAttribute(String str) {
        this.content.append(this.chopNewLine(str));
    }

    public ManifestAttribute(String name, String value) {
        this.set(name, value);
    }

    public void add(String str) {
        String choppedLine = this.chopNewLine(str);
        if (!choppedLine.substring(0, 1).startsWith(" ")) {
            throw new IllegalArgumentException("Additional attribute lines must start with a space.");
        }
        if (choppedLine.contains("\n") || choppedLine.contains("\r")) {
            throw new IllegalArgumentException("Additional attribute line must not consist of multiple lines");
        }
        this.content.append("\n");
        this.content.append(choppedLine);
    }

    private String chopNewLine(String str) {
        char lastChar;
        if (!(str.isEmpty() || (lastChar = str.charAt(str.length() - 1)) != '\n' && lastChar != '\r' && lastChar != '\u2028' && lastChar != '\u2029' && lastChar != '\u0085')) {
            return str.substring(0, str.length() - (str.endsWith("\r\n") ? 2 : 1));
        }
        return str;
    }

    public void writeTo(Writer w, String lineTermination) throws IOException {
        for (String line : this.content.toString().split("\n")) {
            w.write(line);
            w.write(lineTermination);
        }
    }

    public boolean hasName(String name) {
        return this.content.toString().startsWith(name + ": ");
    }

    public String getValue() {
        int index = this.content.indexOf(": ");
        if (index > 0) {
            return this.content.substring(index + 2).replace("\n ", "");
        }
        return null;
    }

    public void set(String name, List<MutableManifestElement> manifestElements) {
        this.content.setLength(0);
        this.content.append(name);
        this.content.append(": ");
        for (MutableManifestElement element : manifestElements) {
            this.content.append(element.toString());
            this.content.append(ELEMENT_SEPARATOR);
        }
        this.content.setLength(this.content.length() - ELEMENT_SEPARATOR.length());
    }

    public void set(String name, String value) {
        try {
            this.set(name, MutableManifestElement.parseHeader(name, value));
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
    }
}

