/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.tycho.versions.engine.ProjectMetadataReader;
import org.eclipse.tycho.versions.engine.VersionsEngine;

@Mojo(name="set-version", aggregator=true, requiresDirectInvocation=true)
public class SetMojo
extends AbstractMojo {
    @Parameter(property="newVersion", required=true, alias="developmentVersion")
    private String newVersion;
    @Parameter(property="artifacts", defaultValue="${project.artifactId}")
    private String artifacts;
    @Parameter(property="updateVersionRangeMatchingBounds", defaultValue="false")
    private boolean updateVersionRangeMatchingBounds;
    @Parameter(property="properties")
    private String properties;
    @Component
    private VersionsEngine engine;
    @Parameter(property="session", readonly=true)
    private MavenSession session;
    @Component
    private ProjectMetadataReader metadataReader;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.newVersion == null || this.newVersion.isEmpty()) {
            throw new MojoExecutionException("Missing required parameter newVersion");
        }
        this.engine.setUpdateVersionRangeMatchingBounds(this.updateVersionRangeMatchingBounds);
        try {
            this.metadataReader.addBasedir(this.session.getCurrentProject().getBasedir());
            this.engine.setProjects(this.metadataReader.getProjects());
            for (String artifactId : SetMojo.split(this.artifacts)) {
                this.engine.addVersionChange(artifactId, this.newVersion);
                for (String propertyName : SetMojo.split(this.properties)) {
                    this.engine.addPropertyChange(artifactId, propertyName, this.newVersion);
                }
            }
            this.engine.apply();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not set version", (Exception)e);
        }
    }

    private static List<String> split(String str) {
        ArrayList<String> result = new ArrayList<String>();
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, ",");
            while (st.hasMoreTokens()) {
                result.add(st.nextToken().trim());
            }
        }
        return result;
    }
}

