/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.engine;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.building.ModelProcessor;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.versions.engine.ProjectMetadata;
import org.eclipse.tycho.versions.pom.GAV;
import org.eclipse.tycho.versions.pom.PomFile;
import org.eclipse.tycho.versions.pom.Profile;

@Component(role=ProjectMetadataReader.class, instantiationStrategy="per-lookup")
public class ProjectMetadataReader {
    private static final String PACKAGING_POM = "pom";
    @Requirement
    private Logger log;
    @Requirement
    private PlexusContainer container;
    private Map<File, ProjectMetadata> projects = new LinkedHashMap<File, ProjectMetadata>();

    public void reset() {
        this.projects.clear();
    }

    public PomFile addBasedir(File file, boolean recursive) throws IOException {
        File baseDir;
        File pomFile;
        if (!file.exists()) {
            this.log.info("Project does not exist at " + file);
            return null;
        }
        if (file.isFile()) {
            pomFile = file;
            baseDir = file.getParentFile();
        } else {
            pomFile = this.lookupPomFile(file);
            baseDir = file;
        }
        if (this.projects.containsKey(baseDir)) {
            return null;
        }
        if (this.isInvalidPomFile(pomFile)) {
            this.log.warn("No pom file found at " + baseDir);
            return null;
        }
        ProjectMetadata project = new ProjectMetadata(baseDir, pomFile);
        this.projects.put(baseDir, project);
        PomFile pom = PomFile.read(pomFile, pomFile.canWrite());
        project.putMetadata(pom);
        if (recursive) {
            GAV parent;
            if (PACKAGING_POM.equals(pom.getPackaging())) {
                for (File child : this.getChildren(baseDir, pom)) {
                    this.addBasedir(child, recursive);
                }
            }
            if ((parent = pom.getParent()) != null) {
                File parentProjectPath;
                String relativePath = parent.getRelativePath();
                if (relativePath == null) {
                    relativePath = "../pom.xml";
                }
                if ((parentProjectPath = new File(baseDir, relativePath)).exists()) {
                    this.addBasedir(this.canonify(parentProjectPath), recursive);
                }
            }
        }
        return pom;
    }

    private File lookupPomFile(File basedir) throws IOException {
        List modelprocessors;
        try {
            modelprocessors = this.container.lookupList(ModelProcessor.class);
        }
        catch (ComponentLookupException e) {
            throw new IOException("can't lookup ModelProcessors");
        }
        File pomFile = null;
        for (ModelProcessor modelProcessor : modelprocessors) {
            File locatePom = modelProcessor.locatePom(basedir);
            if (!locatePom.exists()) continue;
            pomFile = locatePom;
            break;
        }
        return pomFile;
    }

    private boolean isInvalidPomFile(File pomFile) {
        return pomFile == null || !pomFile.exists() || pomFile.length() == 0L;
    }

    private Set<File> getChildren(File basedir, PomFile project) throws IOException {
        LinkedHashSet<File> children = new LinkedHashSet<File>();
        for (String module : project.getModules()) {
            children.add(this.canonify(new File(basedir, module)));
        }
        for (Profile profile : project.getProfiles()) {
            for (String module : profile.getModules()) {
                children.add(this.canonify(new File(basedir, module)));
            }
        }
        return children;
    }

    public Collection<ProjectMetadata> getProjects() {
        return this.projects.values();
    }

    private File canonify(File file) {
        return new File(file.toURI().normalize());
    }
}

