/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.engine;

import java.util.Objects;
import org.eclipse.tycho.versions.engine.Versions;

public class VersionChange {
    private final String version;
    private final String newVersion;

    public VersionChange(String version, String newVersion) {
        this.version = Versions.toCanonicalVersion(version);
        this.newVersion = Versions.toCanonicalVersion(newVersion);
    }

    public String getVersion() {
        return this.version;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public int hashCode() {
        return Objects.hash(this.version, this.newVersion);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof VersionChange)) return false;
        VersionChange other = (VersionChange)obj;
        if (!this.version.equals(other.version)) return false;
        if (!this.newVersion.equals(other.newVersion)) return false;
        return true;
    }

    public String toString() {
        return this.version + " => " + this.newVersion;
    }
}

