/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.manipulation;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.targetplatform.TargetDefinitionFile;
import org.eclipse.tycho.versions.engine.MetadataManipulator;
import org.eclipse.tycho.versions.engine.PomVersionChange;
import org.eclipse.tycho.versions.engine.ProjectMetadata;
import org.eclipse.tycho.versions.engine.TargetFiles;
import org.eclipse.tycho.versions.engine.VersionChangesDescriptor;
import org.eclipse.tycho.versions.engine.Versions;
import org.eclipse.tycho.versions.manipulation.AbstractMetadataManipulator;
import org.eclipse.tycho.versions.pom.PomFile;

@Component(role=MetadataManipulator.class, hint="eclipse-target-files")
public class EclipseTargetFileManipulator
extends AbstractMetadataManipulator {
    private static final String SEQUENCE_NUMBER_ATTRIBUTE = "sequenceNumber";
    private static final String MVN_URL = "mvn";
    private static final String MVN_URL_PREFIX = "mvn:";
    private static final String TARGET_TYPE = "Target";
    private static final String TARGET_TYPE_URI_ATTRIBUTE = "uri";

    @Override
    public void applyChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        if (this.isEclipseTargetProject(project)) {
            for (PomVersionChange change : versionChangeContext.getVersionChanges()) {
                for (Map.Entry<File, Document> entry : this.getTargets(project).entrySet()) {
                    this.applyChanges(change, entry.getValue(), entry.getKey().getName());
                }
            }
        }
    }

    private void applyChanges(PomVersionChange change, Document document, String fileName) {
        Element dom = document.getRootElement();
        boolean changed = false;
        for (Element locations : dom.getChildren("locations")) {
            List children = locations.getChildren("location");
            for (int j = 0; j < children.size(); ++j) {
                String[] coordinates;
                String uri;
                Element location = (Element)children.get(j);
                String locationType = location.getAttributeValue("type");
                if (!TARGET_TYPE.equals(locationType) || !(uri = location.getAttributeValue(TARGET_TYPE_URI_ATTRIBUTE)).startsWith(MVN_URL_PREFIX) || (coordinates = uri.substring(MVN_URL_PREFIX.length()).split(":")).length < 3) continue;
                String groupId = coordinates[0];
                String artifactId = coordinates[1];
                String version = coordinates[2];
                if (!groupId.equals(change.getGroupId()) || !artifactId.equals(change.getArtifactId()) || !Versions.isVersionEquals(version, change.getVersion())) continue;
                Stream.Builder<String> builder = Stream.builder();
                builder.add(MVN_URL);
                builder.add(groupId);
                builder.add(artifactId);
                builder.add(Versions.toMavenVersion(change.getNewVersion()));
                for (int i = 3; i < coordinates.length; ++i) {
                    builder.add(coordinates[i]);
                }
                String newUri = builder.build().collect(Collectors.joining(":"));
                this.logger.info("  " + fileName + "//target/locations/location[" + j + "]/@uri: " + uri + " => " + newUri);
                changed = true;
                location.setAttribute(TARGET_TYPE_URI_ATTRIBUTE, newUri);
            }
        }
        if (changed) {
            try {
                int sequenceNumber = Integer.parseInt(dom.getAttributeValue(SEQUENCE_NUMBER_ATTRIBUTE));
                int nextSequenceNumber = sequenceNumber + 1;
                dom.setAttribute(SEQUENCE_NUMBER_ATTRIBUTE, String.valueOf(nextSequenceNumber));
                this.logger.info("  " + fileName + "//target/@sequenceNumber: " + sequenceNumber + " => " + nextSequenceNumber);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public Collection<String> validateChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        if (this.isEclipseTargetProject(project)) {
            // empty if block
        }
        return null;
    }

    private boolean isEclipseTargetProject(ProjectMetadata project) {
        return "eclipse-target-definition".equals(project.getMetadata(PomFile.class).getPackaging());
    }

    @Override
    public void writeMetadata(ProjectMetadata project) throws IOException {
        TargetFiles targetFiles = project.getMetadata(TargetFiles.class);
        if (targetFiles != null) {
            targetFiles.write();
        }
    }

    private Map<File, Document> getTargets(ProjectMetadata project) {
        TargetFiles targets = project.getMetadata(TargetFiles.class);
        if (targets == null) {
            File[] targetFiles;
            targets = new TargetFiles();
            for (File targetFile : targetFiles = TargetDefinitionFile.listTargetFiles((File)project.getBasedir())) {
                try {
                    targets.addTargetFile(targetFile);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not read target file " + targetFile, e);
                }
            }
            project.putMetadata(targets);
        }
        return targets.getTargets();
    }
}

