/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.engine;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.XMLIOSource;
import de.pdark.decentxml.XMLParser;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TargetFiles {
    private static final XMLParser PARSER = new XMLParser();
    private Map<File, Document> targets = new ConcurrentHashMap<File, Document>();

    public void addTargetFile(File targetFile) throws IOException {
        this.targets.put(targetFile, PARSER.parse((XMLSource)new XMLIOSource(targetFile)));
    }

    public Map<File, Document> getTargets() {
        return this.targets;
    }

    public void write(File targetFile) throws IOException {
        Document document = this.targets.get(targetFile);
        if (document == null) {
            return;
        }
        this.writeTarget(targetFile, document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTarget(File targetFile, Document document) throws IOException, UnsupportedEncodingException, FileNotFoundException {
        String enc = document.getEncoding() != null ? document.getEncoding() : "UTF-8";
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(targetFile)), enc);
             XMLWriter xw = new XMLWriter((Writer)w);){
            try {
                document.toXML(xw);
            }
            finally {
                xw.flush();
            }
        }
    }

    public void write() throws IOException {
        for (Map.Entry<File, Document> e : this.targets.entrySet()) {
            this.writeTarget(e.getKey(), e.getValue());
        }
    }
}

