/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.pom;

import de.pdark.decentxml.Element;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.tycho.versions.pom.Build;
import org.eclipse.tycho.versions.pom.Dependencies;
import org.eclipse.tycho.versions.pom.DependencyManagement;
import org.eclipse.tycho.versions.pom.GAV;
import org.eclipse.tycho.versions.pom.Property;

public class Profile {
    private final Element dom;

    public Profile(Element dom) {
        this.dom = dom;
    }

    public List<String> getModules() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Element modules : this.dom.getChildren("modules")) {
            for (Element module : modules.getChildren("module")) {
                result.add(module.getTrimmedText());
            }
        }
        return new ArrayList<String>(result);
    }

    public String getId() {
        Element child = this.dom.getChild("id");
        return child != null ? child.getTrimmedText() : null;
    }

    public Build getBuild() {
        return Build.getBuild(this.dom);
    }

    public List<GAV> getDependencies() {
        return Dependencies.getDependencies(this.dom);
    }

    public DependencyManagement getDependencyManagement() {
        return DependencyManagement.getDependencyManagement(this.dom);
    }

    public List<Property> getProperties() {
        return Property.getProperties(this.dom);
    }
}

