/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions;

import java.util.Optional;
import org.apache.maven.execution.BuildFailure;
import org.apache.maven.execution.BuildSummary;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.build.BuildListener;
import org.eclipse.tycho.core.exceptions.VersionBumpRequiredException;
import org.eclipse.tycho.helper.ProjectHelper;
import org.eclipse.tycho.versions.VersionBumpMojo;
import org.eclipse.tycho.versions.engine.ProjectMetadataReader;
import org.eclipse.tycho.versions.engine.Versions;
import org.eclipse.tycho.versions.engine.VersionsEngine;
import org.eclipse.tycho.versions.pom.PomFile;

@Component(role=BuildListener.class)
public class VersionBumpBuildListener
implements BuildListener {
    @Requirement
    private Logger logger;
    @Requirement
    private ProjectMetadataReader metadataReader;
    @Requirement
    private VersionsEngine engine;
    @Requirement
    private ProjectHelper projectHelper;

    public void buildStarted(MavenSession session) {
    }

    public void buildEnded(MavenSession session) {
        MavenExecutionResult result = session.getResult();
        int bumped = 0;
        int skipped = 0;
        for (MavenProject project : session.getProjects()) {
            BuildFailure failure;
            VersionBumpRequiredException vbe;
            BuildSummary buildSummary = result.getBuildSummary(project);
            if (buildSummary == null) {
                ++skipped;
                continue;
            }
            if (!(buildSummary instanceof BuildFailure) || (vbe = this.getVersionBumpRequiredException((failure = (BuildFailure)buildSummary).getCause())) == null || !this.hasBumpExecution(project, session)) continue;
            try {
                this.metadataReader.reset();
                this.engine.reset();
                PomFile pomFile = this.metadataReader.addBasedir(project.getBasedir(), false);
                if (pomFile == null) continue;
                String currentVersion = pomFile.getVersion();
                Optional suggestedVersion = vbe.getSuggestedVersion();
                Object newVersion = suggestedVersion.map(String::valueOf).orElseGet(() -> Versions.incrementVersion(currentVersion, VersionBumpMojo.getIncrement(session, project, this.projectHelper)));
                boolean isSnapshot = currentVersion.endsWith("-SNAPSHOT");
                if (isSnapshot) {
                    newVersion = (String)newVersion + "-SNAPSHOT";
                }
                this.logger.info(project.getId() + " requires a version bump from " + currentVersion + " => " + (String)newVersion);
                this.engine.setProjects(this.metadataReader.getProjects());
                this.engine.addVersionChange(pomFile.getArtifactId(), (String)newVersion);
                this.engine.apply();
                ++bumped;
            }
            catch (Exception e) {
                this.logger.warn("Can't bump versions for project " + project.getId() + ": " + e);
            }
        }
        if (bumped > 0) {
            this.logger.warn(bumped + " project version(s) where bumped, rerun the build to take the changes into account!");
            if (skipped > 0) {
                this.logger.warn(skipped + " project(s) where skipped, more version bumps might be required.");
            }
        }
    }

    private boolean hasBumpExecution(MavenProject project, MavenSession mavenSession) {
        return this.projectHelper.hasPluginExecution("org.eclipse.tycho", "tycho-versions-plugin", "bump-versions", project, mavenSession);
    }

    private VersionBumpRequiredException getVersionBumpRequiredException(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof VersionBumpRequiredException) {
            VersionBumpRequiredException vbe = (VersionBumpRequiredException)throwable;
            return vbe;
        }
        return this.getVersionBumpRequiredException(throwable.getCause());
    }
}

