/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.tycho.versions.engine.ProjectMetadataReader;
import org.eclipse.tycho.versions.engine.VersionsEngine;

public abstract class AbstractChangeMojo
extends AbstractMojo {
    @Parameter(property="artifacts", defaultValue="${project.artifactId}")
    private String artifacts;
    @Parameter(property="modules")
    private String modules;
    @Component
    private VersionsEngine engine;
    @Parameter(property="session", readonly=true)
    protected MavenSession session;
    @Component
    private ProjectMetadataReader metadataReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        VersionsEngine versionsEngine = this.engine;
        synchronized (versionsEngine) {
            ProjectMetadataReader projectMetadataReader = this.metadataReader;
            synchronized (projectMetadataReader) {
                try {
                    File basedir = this.session.getCurrentProject().getBasedir();
                    boolean recursive = this.session.getRequest().isRecursive();
                    this.metadataReader.addBasedir(basedir, recursive);
                    for (String p : AbstractChangeMojo.split(this.modules)) {
                        this.metadataReader.addBasedir(new File(basedir, p), recursive);
                    }
                    this.engine.setProjects(this.metadataReader.getProjects());
                    this.addChanges(AbstractChangeMojo.split(this.artifacts), this.engine);
                    this.engine.apply();
                    this.engine.reset();
                    this.metadataReader.reset();
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Could not set version", (Exception)e);
                }
            }
        }
    }

    protected static List<String> split(String str) {
        ArrayList<String> result = new ArrayList<String>();
        if (str != null && !str.isBlank()) {
            StringTokenizer st = new StringTokenizer(str, ",");
            while (st.hasMoreTokens()) {
                result.add(st.nextToken().trim());
            }
        }
        return result;
    }

    protected abstract void addChanges(List<String> var1, VersionsEngine var2) throws MojoExecutionException, IOException;
}

