/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.pom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.tycho.versions.pom.Property;

public class PomUtil {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{(.+?)\\}");

    public static boolean containsProperties(String str) {
        return str != null && str.contains("${");
    }

    public static String expandProperties(String str, List<Property> properties) {
        if (PomUtil.containsProperties(str)) {
            StringBuilder resolvedVersionBuilder = new StringBuilder();
            Matcher m = PROPERTY_PATTERN.matcher(str.trim());
            while (m.find()) {
                String unexpandedProperty = m.group();
                String propertyName = m.group(1);
                m.appendReplacement(resolvedVersionBuilder, properties.stream().filter(p -> p.getName().equals(propertyName)).map(p -> p.getValue()).findFirst().orElse(unexpandedProperty));
            }
            m.appendTail(resolvedVersionBuilder);
            return resolvedVersionBuilder.toString();
        }
        return str;
    }

    public static List<String> getContainedPropertyNames(String str) {
        if (PomUtil.containsProperties(str)) {
            Matcher m = PROPERTY_PATTERN.matcher(str.trim());
            ArrayList<String> propertyNames = new ArrayList<String>();
            while (m.find()) {
                propertyNames.add(m.group(1));
            }
            return Collections.unmodifiableList(propertyNames);
        }
        return List.of();
    }
}

