/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.versions.engine.DefaultVersionRangeUpdateStrategy;
import org.eclipse.tycho.versions.engine.IllegalVersionChangeException;
import org.eclipse.tycho.versions.engine.MetadataManipulator;
import org.eclipse.tycho.versions.engine.PomVersionChange;
import org.eclipse.tycho.versions.engine.ProjectMetadata;
import org.eclipse.tycho.versions.engine.VersionChangesDescriptor;
import org.eclipse.tycho.versions.manipulation.PomManipulator;
import org.eclipse.tycho.versions.pom.PomFile;

@Component(role=VersionsEngine.class, instantiationStrategy="per-lookup")
public class VersionsEngine {
    @Requirement
    private Logger logger;
    @Requirement(role=MetadataManipulator.class)
    private List<MetadataManipulator> manipulators;
    @Requirement(hint="pom")
    private MetadataManipulator pomManipulator;
    private Collection<ProjectMetadata> projects;
    private Set<PomVersionChange> originalVersionChanges = new LinkedHashSet<PomVersionChange>();
    private Set<PropertyChange> propertyChanges = new LinkedHashSet<PropertyChange>();
    private boolean updateVersionRangeMatchingBounds;

    public boolean isUpdateVersionRangeMatchingBounds() {
        return this.updateVersionRangeMatchingBounds;
    }

    public void setUpdateVersionRangeMatchingBounds(boolean updateVersionRangeMatchingBounds) {
        this.updateVersionRangeMatchingBounds = updateVersionRangeMatchingBounds;
    }

    public void setProjects(Collection<ProjectMetadata> projects) {
        this.projects = projects;
    }

    public void addVersionChange(String artifactId, String newVersion) throws IOException {
        PomFile pom = this.getMutablePom(artifactId);
        if (!newVersion.equals(pom.getVersion())) {
            this.addVersionChange(new PomVersionChange(pom, newVersion));
        }
    }

    public PomFile getMutablePom(String artifactId) throws IOException {
        ProjectMetadata project = this.getProject(artifactId);
        if (project == null) {
            throw new IOException("Project with artifactId=" + artifactId + " could not be found");
        }
        return project.getMetadata(PomFile.class);
    }

    public void addVersionChange(PomVersionChange change) {
        this.originalVersionChanges.add(change);
    }

    public void reset() {
        this.originalVersionChanges.clear();
        this.propertyChanges.clear();
        this.updateVersionRangeMatchingBounds = false;
        this.projects = null;
    }

    public void apply() throws IOException {
        VersionChangesDescriptor versionChangeContext = new VersionChangesDescriptor(this.originalVersionChanges, new DefaultVersionRangeUpdateStrategy(this.isUpdateVersionRangeMatchingBounds()), this.projects);
        boolean newChanges = true;
        while (newChanges) {
            newChanges = false;
            for (ProjectMetadata project : this.projects) {
                for (MetadataManipulator metadataManipulator : this.manipulators) {
                    newChanges |= metadataManipulator.addMoreChanges(project, versionChangeContext);
                }
            }
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (ProjectMetadata project : this.projects) {
            for (MetadataManipulator metadataManipulator : this.manipulators) {
                Collection<String> error = metadataManipulator.validateChanges(project, versionChangeContext);
                if (error == null) continue;
                errors.addAll(error);
            }
        }
        if (!errors.isEmpty()) {
            throw new IllegalVersionChangeException(errors);
        }
        for (ProjectMetadata project : this.projects) {
            this.logger.info("Making changes in " + project.getBasedir().getAbsolutePath());
            PomFile pomFile = project.getMetadata(PomFile.class);
            for (PropertyChange propertyChange : this.propertyChanges) {
                if (pomFile != propertyChange.pom) continue;
                ((PomManipulator)this.pomManipulator).applyPropertyChange(project.getPomFile().getName(), pomFile, propertyChange.propertyName, propertyChange.propertyValue);
            }
            for (MetadataManipulator manipulator : this.manipulators) {
                manipulator.applyChanges(project, versionChangeContext);
            }
        }
        for (ProjectMetadata project : this.projects) {
            for (MetadataManipulator metadataManipulator : this.manipulators) {
                metadataManipulator.writeMetadata(project);
            }
        }
    }

    private ProjectMetadata getProject(String artifactId) {
        for (ProjectMetadata project : this.projects) {
            PomFile pom = project.getMetadata(PomFile.class);
            if (!artifactId.equals(pom.getArtifactId())) continue;
            return project;
        }
        return null;
    }

    public void addPropertyChange(String artifactId, String propertyName, String propertyValue) throws IOException {
        PomFile pom = this.getMutablePom(artifactId);
        this.propertyChanges.add(new PropertyChange(pom, propertyName, propertyValue));
    }

    private static class PropertyChange {
        final PomFile pom;
        final String propertyName;
        String propertyValue;

        public PropertyChange(PomFile pom, String propertyName, String propertyValue) {
            this.pom = pom;
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }
    }
}

