/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uprotocol.cloudevent.datamodel;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.uprotocol.v1.UPriority;

public class UCloudEventAttributes {
    private static final UCloudEventAttributes EMPTY = new UCloudEventAttributes(null, null, null, null);
    private final String hash;
    private final UPriority priority;
    private final Integer ttl;
    private final String token;
    private final String traceparent;

    private UCloudEventAttributes(String hash, UPriority priority, Integer ttl, String token) {
        this.hash = hash;
        this.priority = priority;
        this.ttl = ttl;
        this.token = token;
        this.traceparent = null;
    }

    private UCloudEventAttributes(UCloudEventAttributesBuilder builder) {
        this.hash = builder.hash;
        this.priority = builder.priority;
        this.ttl = builder.ttl;
        this.token = builder.token;
        this.traceparent = builder.traceparent;
    }

    public static UCloudEventAttributes empty() {
        return EMPTY;
    }

    public boolean isEmpty() {
        return this.hash().isEmpty() && this.priority().isEmpty() && this.ttl().isEmpty() && this.token().isEmpty() && this.traceparent().isEmpty();
    }

    public Optional<String> hash() {
        return this.hash == null || this.hash.isBlank() ? Optional.empty() : Optional.of(this.hash);
    }

    public Optional<UPriority> priority() {
        return this.priority == null ? Optional.empty() : Optional.of(this.priority);
    }

    public Optional<Integer> ttl() {
        return this.ttl == null ? Optional.empty() : Optional.of(this.ttl);
    }

    public Optional<String> token() {
        return this.token == null || this.token.isBlank() ? Optional.empty() : Optional.of(this.token);
    }

    public Optional<String> traceparent() {
        return this.traceparent == null || this.traceparent.isBlank() ? Optional.empty() : Optional.of(this.traceparent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UCloudEventAttributes that = (UCloudEventAttributes)o;
        return Objects.equals(this.hash, that.hash) && this.priority == that.priority && Objects.equals(this.ttl, that.ttl) && Objects.equals(this.token, that.token) && Objects.equals(this.traceparent, that.traceparent);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hash, this.priority, this.ttl, this.token, this.traceparent});
    }

    public String toString() {
        Object traceParentString = "";
        if (this.traceparent != null) {
            traceParentString = ", traceparent='" + this.traceparent + "'";
        }
        return "UCloudEventAttributes{hash='" + this.hash + "', priority=" + this.priority + ", ttl=" + this.ttl + ", token='" + this.token + "'" + (String)traceParentString + "}";
    }

    public static class UCloudEventAttributesBuilder {
        private String hash;
        private UPriority priority;
        private Integer ttl;
        private String token;
        private String traceparent;

        public UCloudEventAttributesBuilder withHash(String hash) {
            this.hash = hash;
            return this;
        }

        public UCloudEventAttributesBuilder withPriority(UPriority priority) {
            this.priority = priority;
            return this;
        }

        public UCloudEventAttributesBuilder withTtl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        public UCloudEventAttributesBuilder withToken(String token) {
            this.token = token;
            return this;
        }

        public UCloudEventAttributesBuilder withTraceparent(String traceparent) {
            this.traceparent = traceparent;
            return this;
        }

        public UCloudEventAttributes build() {
            return new UCloudEventAttributes(this);
        }
    }
}

