/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uprotocol.cloudevent.factory;

import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.impl.BaseCloudEventBuilder;
import java.net.URI;
import org.eclipse.uprotocol.cloudevent.datamodel.UCloudEventAttributes;
import org.eclipse.uprotocol.cloudevent.factory.UCloudEvent;
import org.eclipse.uprotocol.uuid.factory.UuidFactory;
import org.eclipse.uprotocol.uuid.serializer.LongUuidSerializer;
import org.eclipse.uprotocol.v1.UMessageType;
import org.eclipse.uprotocol.v1.UPriority;
import org.eclipse.uprotocol.v1.UUID;

public interface CloudEventFactory {
    public static final String PROTOBUF_CONTENT_TYPE = "application/x-protobuf";

    public static CloudEvent request(String applicationUriForRPC, String serviceMethodUri, Any protoPayload, UCloudEventAttributes attributes) {
        String id = CloudEventFactory.generateCloudEventId();
        return CloudEventFactory.buildBaseCloudEvent(id, applicationUriForRPC, protoPayload.toByteArray(), protoPayload.getTypeUrl(), attributes).withType(UCloudEvent.getEventType(UMessageType.UMESSAGE_TYPE_REQUEST)).withExtension("sink", URI.create(serviceMethodUri)).build();
    }

    public static CloudEvent response(String applicationUriForRPC, String serviceMethodUri, String requestId, Any protoPayload, UCloudEventAttributes attributes) {
        String id = CloudEventFactory.generateCloudEventId();
        return CloudEventFactory.buildBaseCloudEvent(id, serviceMethodUri, protoPayload.toByteArray(), protoPayload.getTypeUrl(), attributes).withType(UCloudEvent.getEventType(UMessageType.UMESSAGE_TYPE_RESPONSE)).withExtension("sink", URI.create(applicationUriForRPC)).withExtension("reqid", requestId).build();
    }

    public static CloudEvent failedResponse(String applicationUriForRPC, String serviceMethodUri, String requestId, Integer communicationStatus, UCloudEventAttributes attributes) {
        String id = CloudEventFactory.generateCloudEventId();
        Any protoPayload = Any.pack((Message)Empty.getDefaultInstance());
        return CloudEventFactory.buildBaseCloudEvent(id, serviceMethodUri, protoPayload.toByteArray(), protoPayload.getTypeUrl(), attributes).withType(UCloudEvent.getEventType(UMessageType.UMESSAGE_TYPE_RESPONSE)).withExtension("sink", URI.create(applicationUriForRPC)).withExtension("reqid", requestId).withExtension("commstatus", (Number)communicationStatus).build();
    }

    public static CloudEvent publish(String source, Any protoPayload, UCloudEventAttributes attributes) {
        String id = CloudEventFactory.generateCloudEventId();
        return CloudEventFactory.buildBaseCloudEvent(id, source, protoPayload.toByteArray(), protoPayload.getTypeUrl(), attributes).withType(UCloudEvent.getEventType(UMessageType.UMESSAGE_TYPE_PUBLISH)).build();
    }

    public static CloudEvent notification(String source, String sink, Any protoPayload, UCloudEventAttributes attributes) {
        String id = CloudEventFactory.generateCloudEventId();
        return CloudEventFactory.buildBaseCloudEvent(id, source, protoPayload.toByteArray(), protoPayload.getTypeUrl(), attributes).withType(UCloudEvent.getEventType(UMessageType.UMESSAGE_TYPE_PUBLISH)).withExtension("sink", URI.create(sink)).build();
    }

    public static String generateCloudEventId() {
        UUID uuid = UuidFactory.Factories.UPROTOCOL.factory().create();
        return LongUuidSerializer.instance().serialize(uuid);
    }

    public static CloudEventBuilder buildBaseCloudEvent(String id, String source, byte[] protoPayloadBytes, String protoPayloadSchema, UCloudEventAttributes attributes) {
        BaseCloudEventBuilder cloudEventBuilder = CloudEventBuilder.v1().withId(id).withSource(URI.create(source)).withData(protoPayloadBytes);
        attributes.ttl().ifPresent(arg_0 -> CloudEventFactory.lambda$buildBaseCloudEvent$0((CloudEventBuilder)cloudEventBuilder, arg_0));
        attributes.priority().ifPresent(arg_0 -> CloudEventFactory.lambda$buildBaseCloudEvent$1((CloudEventBuilder)cloudEventBuilder, arg_0));
        attributes.hash().ifPresent(arg_0 -> CloudEventFactory.lambda$buildBaseCloudEvent$2((CloudEventBuilder)cloudEventBuilder, arg_0));
        attributes.token().ifPresent(arg_0 -> CloudEventFactory.lambda$buildBaseCloudEvent$3((CloudEventBuilder)cloudEventBuilder, arg_0));
        attributes.traceparent().ifPresent(arg_0 -> CloudEventFactory.lambda$buildBaseCloudEvent$4((CloudEventBuilder)cloudEventBuilder, arg_0));
        return cloudEventBuilder;
    }

    private static /* synthetic */ void lambda$buildBaseCloudEvent$4(CloudEventBuilder cloudEventBuilder, String traceparent) {
        cloudEventBuilder.withExtension("traceparent", traceparent);
    }

    private static /* synthetic */ void lambda$buildBaseCloudEvent$3(CloudEventBuilder cloudEventBuilder, String token) {
        cloudEventBuilder.withExtension("token", token);
    }

    private static /* synthetic */ void lambda$buildBaseCloudEvent$2(CloudEventBuilder cloudEventBuilder, String hash) {
        cloudEventBuilder.withExtension("hash", hash);
    }

    private static /* synthetic */ void lambda$buildBaseCloudEvent$1(CloudEventBuilder cloudEventBuilder, UPriority priority) {
        cloudEventBuilder.withExtension("priority", UCloudEvent.getCeName(priority.getValueDescriptor()));
    }

    private static /* synthetic */ void lambda$buildBaseCloudEvent$0(CloudEventBuilder cloudEventBuilder, Integer ttl) {
        cloudEventBuilder.withExtension("ttl", (Number)ttl);
    }
}

