/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uprotocol.cloudevent.factory;

import com.google.protobuf.Any;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.net.URI;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.uprotocol.UprotocolOptions;
import org.eclipse.uprotocol.uri.serializer.LongUriSerializer;
import org.eclipse.uprotocol.uuid.factory.UuidUtils;
import org.eclipse.uprotocol.uuid.serializer.LongUuidSerializer;
import org.eclipse.uprotocol.v1.UAttributes;
import org.eclipse.uprotocol.v1.UCode;
import org.eclipse.uprotocol.v1.UMessage;
import org.eclipse.uprotocol.v1.UMessageType;
import org.eclipse.uprotocol.v1.UPayload;
import org.eclipse.uprotocol.v1.UPayloadFormat;
import org.eclipse.uprotocol.v1.UPriority;
import org.eclipse.uprotocol.v1.UUID;

public interface UCloudEvent {
    public static String getSource(CloudEvent cloudEvent) {
        return cloudEvent.getSource().toString();
    }

    public static Optional<String> getSink(CloudEvent cloudEvent) {
        return UCloudEvent.extractStringValueFromExtension("sink", cloudEvent);
    }

    public static Optional<String> getRequestId(CloudEvent cloudEvent) {
        return UCloudEvent.extractStringValueFromExtension("reqid", cloudEvent);
    }

    public static Optional<String> getHash(CloudEvent cloudEvent) {
        return UCloudEvent.extractStringValueFromExtension("hash", cloudEvent);
    }

    public static Optional<String> getPriority(CloudEvent cloudEvent) {
        return UCloudEvent.extractStringValueFromExtension("priority", cloudEvent);
    }

    public static Optional<Integer> getTtl(CloudEvent cloudEvent) {
        return UCloudEvent.extractStringValueFromExtension("ttl", cloudEvent).map(Integer::valueOf);
    }

    public static Optional<String> getToken(CloudEvent cloudEvent) {
        return UCloudEvent.extractStringValueFromExtension("token", cloudEvent);
    }

    public static Optional<String> getTraceparent(CloudEvent cloudEvent) {
        return UCloudEvent.extractStringValueFromExtension("traceparent", cloudEvent);
    }

    public static UCode getCommunicationStatus(CloudEvent cloudEvent) {
        try {
            return UCode.forNumber(UCloudEvent.extractIntegerValueFromExtension("commstatus", cloudEvent).orElse(0));
        }
        catch (Exception e) {
            return UCode.OK;
        }
    }

    public static boolean hasCommunicationStatusProblem(CloudEvent cloudEvent) {
        return UCloudEvent.getCommunicationStatus(cloudEvent) != UCode.OK;
    }

    public static CloudEvent addCommunicationStatus(CloudEvent cloudEvent, Integer communicationStatus) {
        if (communicationStatus == null) {
            return cloudEvent;
        }
        io.cloudevents.core.v1.CloudEventBuilder builder = CloudEventBuilder.v1((CloudEvent)cloudEvent);
        builder.withExtension("commstatus", (Number)communicationStatus);
        return builder.build();
    }

    public static Optional<Long> getCreationTimestamp(CloudEvent cloudEvent) {
        String cloudEventId = cloudEvent.getId();
        UUID uuid = LongUuidSerializer.instance().deserialize(cloudEventId);
        return UuidUtils.getTime(uuid);
    }

    public static boolean isExpiredByCloudEventCreationDate(CloudEvent cloudEvent) {
        Optional<Integer> maybeTtl = UCloudEvent.getTtl(cloudEvent);
        if (maybeTtl.isEmpty()) {
            return false;
        }
        int ttl = maybeTtl.get();
        if (ttl <= 0) {
            return false;
        }
        OffsetDateTime cloudEventCreationTime = cloudEvent.getTime();
        if (cloudEventCreationTime == null) {
            return false;
        }
        OffsetDateTime now = OffsetDateTime.now();
        OffsetDateTime creationTimePlusTtl = cloudEventCreationTime.plus(ttl, ChronoUnit.MILLIS);
        return now.isAfter(creationTimePlusTtl);
    }

    public static boolean isExpired(CloudEvent cloudEvent) {
        Optional<Integer> maybeTtl = UCloudEvent.getTtl(cloudEvent);
        if (maybeTtl.isEmpty()) {
            return false;
        }
        int ttl = maybeTtl.get();
        if (ttl <= 0) {
            return false;
        }
        String cloudEventId = cloudEvent.getId();
        UUID uuid = LongUuidSerializer.instance().deserialize(cloudEventId);
        if (uuid.equals(UUID.getDefaultInstance())) {
            return false;
        }
        long delta = System.currentTimeMillis() - UuidUtils.getTime(uuid).orElse(0L);
        return delta >= (long)ttl;
    }

    public static boolean isCloudEventId(CloudEvent cloudEvent) {
        String cloudEventId = cloudEvent.getId();
        UUID uuid = LongUuidSerializer.instance().deserialize(cloudEventId);
        return UuidUtils.isUuid(uuid);
    }

    public static Any getPayload(CloudEvent cloudEvent) {
        CloudEventData data = cloudEvent.getData();
        if (data == null) {
            return Any.getDefaultInstance();
        }
        try {
            return Any.parseFrom((byte[])data.toBytes());
        }
        catch (InvalidProtocolBufferException e) {
            return Any.getDefaultInstance();
        }
    }

    public static <T extends Message> Optional<T> unpack(CloudEvent cloudEvent, Class<T> clazz) {
        try {
            return Optional.of(UCloudEvent.getPayload(cloudEvent).unpack(clazz));
        }
        catch (InvalidProtocolBufferException e) {
            return Optional.empty();
        }
    }

    public static String toString(CloudEvent cloudEvent) {
        return cloudEvent != null ? "CloudEvent{id='" + cloudEvent.getId() + "', source='" + cloudEvent.getSource() + "'" + UCloudEvent.getSink(cloudEvent).map(sink -> String.format(", sink='%s'", sink)).orElse("") + ", type='" + cloudEvent.getType() + "'}" : "null";
    }

    private static Optional<String> extractStringValueFromExtension(String extensionName, CloudEvent cloudEvent) {
        Set extensionNames = cloudEvent.getExtensionNames();
        if (extensionNames.contains(extensionName)) {
            Object extension = cloudEvent.getExtension(extensionName);
            return extension == null ? Optional.empty() : Optional.of(String.valueOf(extension));
        }
        return Optional.empty();
    }

    private static Optional<Integer> extractIntegerValueFromExtension(String extensionName, CloudEvent cloudEvent) {
        return UCloudEvent.extractStringValueFromExtension(extensionName, cloudEvent).map(Integer::valueOf);
    }

    public static String getEventType(UMessageType type) {
        return UCloudEvent.getCeName(type.getValueDescriptor());
    }

    public static String getCePriority(UPriority priority) {
        return UCloudEvent.getCeName(priority.getValueDescriptor());
    }

    public static UPriority getUPriority(String ce_priority) {
        return UPriority.getDescriptor().getValues().stream().filter(v -> v.getOptions().hasExtension(UprotocolOptions.ceName) && ((String)v.getOptions().getExtension(UprotocolOptions.ceName)).equals(ce_priority)).map(v -> UPriority.forNumber(v.getNumber())).findFirst().orElse(UPriority.UNRECOGNIZED);
    }

    public static UMessageType getMessageType(String ce_type) {
        return UMessageType.getDescriptor().getValues().stream().filter(v -> v.getOptions().hasExtension(UprotocolOptions.ceName) && ((String)v.getOptions().getExtension(UprotocolOptions.ceName)).equals(ce_type)).map(v -> UMessageType.forNumber(v.getNumber())).findFirst().orElse(UMessageType.UNRECOGNIZED);
    }

    public static UMessage toMessage(CloudEvent event) {
        Objects.requireNonNull(event);
        UPayload payload = UPayload.newBuilder().setFormat(UCloudEvent.getUPayloadFormatFromContentType(event.getDataContentType())).setValue(UCloudEvent.getPayload(event).toByteString()).build();
        UAttributes.Builder builder = UAttributes.newBuilder().setSource(LongUriSerializer.instance().deserialize(UCloudEvent.getSource(event))).setId(LongUuidSerializer.instance().deserialize(event.getId())).setType(UCloudEvent.getMessageType(event.getType()));
        if (UCloudEvent.hasCommunicationStatusProblem(event)) {
            builder.setCommstatus(UCloudEvent.getCommunicationStatus(event));
        }
        UCloudEvent.getPriority(event).map(p -> UPriority.getDescriptor().getValues().stream().filter(v -> v.getOptions().hasExtension(UprotocolOptions.ceName) && ((String)v.getOptions().getExtension(UprotocolOptions.ceName)).equals(p)).map(v -> UPriority.forNumber(v.getNumber())).findFirst().orElse(UPriority.UPRIORITY_UNSPECIFIED)).ifPresent(builder::setPriority);
        UCloudEvent.getSink(event).map(LongUriSerializer.instance()::deserialize).ifPresent(builder::setSink);
        UCloudEvent.getRequestId(event).map(LongUuidSerializer.instance()::deserialize).ifPresent(builder::setReqid);
        UCloudEvent.getTtl(event).ifPresent(builder::setTtl);
        UCloudEvent.getToken(event).ifPresent(builder::setToken);
        UCloudEvent.getTraceparent(event).ifPresent(builder::setTraceparent);
        Optional<Integer> permission_level = UCloudEvent.extractIntegerValueFromExtension("plevel", event);
        permission_level.ifPresent(builder::setPermissionLevel);
        UAttributes attributes = builder.build();
        return UMessage.newBuilder().setAttributes(attributes).setPayload(payload).build();
    }

    public static CloudEvent fromMessage(UMessage message) {
        Objects.requireNonNull(message, "message cannot be null.");
        UAttributes attributes = Objects.requireNonNullElse(message.getAttributes(), UAttributes.getDefaultInstance());
        UPayload payload = Objects.requireNonNullElse(message.getPayload(), UPayload.getDefaultInstance());
        io.cloudevents.core.v1.CloudEventBuilder cloudEventBuilder = CloudEventBuilder.v1().withId(LongUuidSerializer.instance().serialize(attributes.getId()));
        cloudEventBuilder.withType(UCloudEvent.getEventType(attributes.getType()));
        cloudEventBuilder.withSource(URI.create(LongUriSerializer.instance().serialize(attributes.getSource())));
        String contentType = UCloudEvent.getContentTypeFromUPayloadFormat(payload.getFormat());
        if (!contentType.isEmpty()) {
            cloudEventBuilder.withDataContentType(contentType);
        }
        if (payload.hasValue()) {
            cloudEventBuilder.withData(payload.getValue().toByteArray());
        }
        if (attributes.hasTtl()) {
            cloudEventBuilder.withExtension("ttl", (Number)attributes.getTtl());
        }
        if (attributes.hasToken()) {
            cloudEventBuilder.withExtension("token", attributes.getToken());
        }
        if (attributes.getPriorityValue() > 0) {
            cloudEventBuilder.withExtension("priority", UCloudEvent.getCePriority(attributes.getPriority()));
        }
        if (attributes.hasSink()) {
            cloudEventBuilder.withExtension("sink", URI.create(LongUriSerializer.instance().serialize(attributes.getSink())));
        }
        if (attributes.hasCommstatus()) {
            cloudEventBuilder.withExtension("commstatus", (Number)attributes.getCommstatus().getNumber());
        }
        if (attributes.hasReqid()) {
            cloudEventBuilder.withExtension("reqid", LongUuidSerializer.instance().serialize(attributes.getReqid()));
        }
        if (attributes.hasPermissionLevel()) {
            cloudEventBuilder.withExtension("plevel", (Number)attributes.getPermissionLevel());
        }
        if (attributes.hasTraceparent()) {
            cloudEventBuilder.withExtension("traceparent", attributes.getTraceparent());
        }
        return cloudEventBuilder.build();
    }

    public static UPayloadFormat getUPayloadFormatFromContentType(String contentType) {
        if (contentType == null) {
            return UPayloadFormat.UPAYLOAD_FORMAT_PROTOBUF_WRAPPED_IN_ANY;
        }
        return UPayloadFormat.getDescriptor().getValues().stream().filter(v -> v.getOptions().hasExtension(UprotocolOptions.mimeType) && ((String)v.getOptions().getExtension(UprotocolOptions.mimeType)).equals(contentType)).map(v -> UPayloadFormat.forNumber(v.getNumber())).findFirst().orElse(UPayloadFormat.UPAYLOAD_FORMAT_PROTOBUF_WRAPPED_IN_ANY);
    }

    public static String getContentTypeFromUPayloadFormat(UPayloadFormat format) {
        if (format == UPayloadFormat.UPAYLOAD_FORMAT_PROTOBUF_WRAPPED_IN_ANY) {
            return "";
        }
        return (String)format.getValueDescriptor().getOptions().getExtension(UprotocolOptions.mimeType);
    }

    public static String getCeName(Descriptors.EnumValueDescriptor descriptor) {
        return (String)descriptor.getOptions().getExtension(UprotocolOptions.ceName);
    }
}

