/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uprotocol.cloudevent.validate;

import io.cloudevents.CloudEvent;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.uprotocol.cloudevent.factory.UCloudEvent;
import org.eclipse.uprotocol.uri.serializer.LongUriSerializer;
import org.eclipse.uprotocol.uri.validator.UriValidator;
import org.eclipse.uprotocol.v1.UResource;
import org.eclipse.uprotocol.v1.UUri;
import org.eclipse.uprotocol.validation.ValidationResult;

public abstract class CloudEventValidator {
    public static CloudEventValidator getValidator(CloudEvent cloudEvent) {
        CloudEventValidator validator;
        String cloudEventType = cloudEvent.getType();
        if (cloudEventType.isEmpty()) {
            return Validators.PUBLISH.validator();
        }
        switch (UCloudEvent.getMessageType(cloudEvent.getType())) {
            case UMESSAGE_TYPE_NOTIFICATION: {
                validator = Validators.NOTIFICATION.validator();
                break;
            }
            case UMESSAGE_TYPE_RESPONSE: {
                validator = Validators.RESPONSE.validator();
                break;
            }
            case UMESSAGE_TYPE_REQUEST: {
                validator = Validators.REQUEST.validator();
                break;
            }
            default: {
                validator = Validators.PUBLISH.validator();
            }
        }
        return validator;
    }

    public ValidationResult validate(CloudEvent cloudEvent) {
        String errorMessage = Stream.of(CloudEventValidator.validateVersion(cloudEvent), CloudEventValidator.validateId(cloudEvent), this.validateSource(cloudEvent), this.validateType(cloudEvent), this.validateSink(cloudEvent)).filter(ValidationResult::isFailure).map(ValidationResult::getMessage).collect(Collectors.joining(","));
        return errorMessage.isBlank() ? ValidationResult.success() : ValidationResult.failure(errorMessage);
    }

    public static ValidationResult validateVersion(CloudEvent cloudEvent) {
        return CloudEventValidator.validateVersion(cloudEvent.getSpecVersion().toString());
    }

    public static ValidationResult validateVersion(String version) {
        return version.equals("1.0") ? ValidationResult.success() : ValidationResult.failure(String.format("Invalid CloudEvent version [%s]. CloudEvent version must be 1.0.", version));
    }

    public static ValidationResult validateId(CloudEvent cloudEvent) {
        return UCloudEvent.isCloudEventId(cloudEvent) ? ValidationResult.success() : ValidationResult.failure(String.format("Invalid CloudEvent Id [%s]. CloudEvent Id must be of type UUIDv8.", cloudEvent.getId()));
    }

    public abstract ValidationResult validateSource(CloudEvent var1);

    public abstract ValidationResult validateType(CloudEvent var1);

    public ValidationResult validateSink(CloudEvent cloudEvent) {
        String sink;
        ValidationResult checkSink;
        Optional<String> maybeSink = UCloudEvent.getSink(cloudEvent);
        if (maybeSink.isPresent() && (checkSink = CloudEventValidator.validateUEntityUri(sink = maybeSink.get())).isFailure()) {
            return ValidationResult.failure(String.format("Invalid CloudEvent sink [%s]. %s", sink, checkSink.getMessage()));
        }
        return ValidationResult.success();
    }

    public static ValidationResult validateUEntityUri(String uri) {
        UUri Uri = LongUriSerializer.instance().deserialize(uri);
        return CloudEventValidator.validateUEntityUri(Uri);
    }

    public static ValidationResult validateUEntityUri(UUri Uri) {
        return UriValidator.validate(Uri);
    }

    public static ValidationResult validateTopicUri(String uri) {
        UUri Uri = LongUriSerializer.instance().deserialize(uri);
        return CloudEventValidator.validateTopicUri(Uri);
    }

    public static ValidationResult validateTopicUri(UUri Uri) {
        ValidationResult validationResult = CloudEventValidator.validateUEntityUri(Uri);
        if (validationResult.isFailure()) {
            return validationResult;
        }
        UResource uResource = Uri.getResource();
        if (uResource.getName().isBlank()) {
            return ValidationResult.failure("UriPart is missing uResource name.");
        }
        if (uResource.getMessage().isEmpty()) {
            return ValidationResult.failure("UriPart is missing Message information.");
        }
        return ValidationResult.success();
    }

    public static ValidationResult validateRpcTopicUri(String uri) {
        UUri Uri = LongUriSerializer.instance().deserialize(uri);
        return CloudEventValidator.validateRpcTopicUri(Uri);
    }

    public static ValidationResult validateRpcTopicUri(UUri Uri) {
        ValidationResult validationResult = CloudEventValidator.validateUEntityUri(Uri);
        if (validationResult.isFailure()) {
            return ValidationResult.failure(String.format("Invalid RPC uri application response topic. %s", validationResult.getMessage()));
        }
        UResource uResource = Uri.getResource();
        String topic = String.format("%s.%s", uResource.getName(), uResource.getInstance());
        if (!"rpc.response".equals(topic)) {
            return ValidationResult.failure("Invalid RPC uri application response topic. UriPart is missing rpc.response.");
        }
        return ValidationResult.success();
    }

    public static ValidationResult validateRpcMethod(String uri) {
        UUri Uri = LongUriSerializer.instance().deserialize(uri);
        ValidationResult validationResult = CloudEventValidator.validateUEntityUri(Uri);
        if (validationResult.isFailure()) {
            return ValidationResult.failure(String.format("Invalid RPC method uri. %s", validationResult.getMessage()));
        }
        if (!UriValidator.isRpcMethod(Uri)) {
            return ValidationResult.failure("Invalid RPC method uri. UriPart should be the method to be called, or method from response.");
        }
        return ValidationResult.success();
    }

    private static class Response
    extends CloudEventValidator {
        private Response() {
        }

        @Override
        public ValidationResult validateSource(CloudEvent cloudEvent) {
            String source = cloudEvent.getSource().toString();
            ValidationResult checkSource = Response.validateRpcMethod(source);
            if (checkSource.isFailure()) {
                return ValidationResult.failure(String.format("Invalid RPC Response CloudEvent source [%s]. %s", source, checkSource.getMessage()));
            }
            return ValidationResult.success();
        }

        @Override
        public ValidationResult validateSink(CloudEvent cloudEvent) {
            Optional<String> maybeSink = UCloudEvent.getSink(cloudEvent);
            if (maybeSink.isEmpty()) {
                return ValidationResult.failure("Invalid CloudEvent sink. Response CloudEvent sink must be uri the destination of the response.");
            }
            String sink = maybeSink.get();
            ValidationResult checkSink = Response.validateRpcTopicUri(sink);
            if (checkSink.isFailure()) {
                return ValidationResult.failure(String.format("Invalid RPC Response CloudEvent sink [%s]. %s", sink, checkSink.getMessage()));
            }
            return ValidationResult.success();
        }

        @Override
        public ValidationResult validateType(CloudEvent cloudEvent) {
            return "res.v1".equals(cloudEvent.getType()) ? ValidationResult.success() : ValidationResult.failure(String.format("Invalid CloudEvent type [%s]. CloudEvent of type Response must have a type of 'res.v1'", cloudEvent.getType()));
        }

        public String toString() {
            return "CloudEventValidator.Response";
        }
    }

    private static class Request
    extends CloudEventValidator {
        private Request() {
        }

        @Override
        public ValidationResult validateSource(CloudEvent cloudEvent) {
            String source = cloudEvent.getSource().toString();
            ValidationResult checkSource = Request.validateRpcTopicUri(source);
            if (checkSource.isFailure()) {
                return ValidationResult.failure(String.format("Invalid RPC Request CloudEvent source [%s]. %s", source, checkSource.getMessage()));
            }
            return ValidationResult.success();
        }

        @Override
        public ValidationResult validateSink(CloudEvent cloudEvent) {
            Optional<String> maybeSink = UCloudEvent.getSink(cloudEvent);
            if (maybeSink.isEmpty()) {
                return ValidationResult.failure("Invalid RPC Request CloudEvent sink. Request CloudEvent sink must be uri for the method to be called.");
            }
            String sink = maybeSink.get();
            ValidationResult checkSink = Request.validateRpcMethod(sink);
            if (checkSink.isFailure()) {
                return ValidationResult.failure(String.format("Invalid RPC Request CloudEvent sink [%s]. %s", sink, checkSink.getMessage()));
            }
            return ValidationResult.success();
        }

        @Override
        public ValidationResult validateType(CloudEvent cloudEvent) {
            return "req.v1".equals(cloudEvent.getType()) ? ValidationResult.success() : ValidationResult.failure(String.format("Invalid CloudEvent type [%s]. CloudEvent of type Request must have a type of 'req.v1'", cloudEvent.getType()));
        }

        public String toString() {
            return "CloudEventValidator.Request";
        }
    }

    private static class Notification
    extends CloudEventValidator {
        private Notification() {
        }

        @Override
        public ValidationResult validateSink(CloudEvent cloudEvent) {
            Optional<String> maybeSink = UCloudEvent.getSink(cloudEvent);
            if (maybeSink.isEmpty()) {
                return ValidationResult.failure("Invalid CloudEvent sink. Notification CloudEvent sink must be an  uri.");
            }
            String sink = maybeSink.get();
            ValidationResult checkSink = Notification.validateUEntityUri(sink);
            if (checkSink.isFailure()) {
                return ValidationResult.failure(String.format("Invalid Notification type CloudEvent sink [%s]. %s", sink, checkSink.getMessage()));
            }
            return ValidationResult.success();
        }

        public String toString() {
            return "CloudEventValidator.Notification";
        }

        @Override
        public ValidationResult validateSource(CloudEvent cloudEvent) {
            String source = cloudEvent.getSource().toString();
            ValidationResult checkSource = Notification.validateTopicUri(source);
            if (checkSource.isFailure()) {
                return ValidationResult.failure(String.format("Invalid Notification type CloudEvent source [%s]. %s", source, checkSource.getMessage()));
            }
            return ValidationResult.success();
        }

        @Override
        public ValidationResult validateType(CloudEvent cloudEvent) {
            return "not.v1".equals(cloudEvent.getType()) ? ValidationResult.success() : ValidationResult.failure(String.format("Invalid CloudEvent type [%s]. CloudEvent of type Notification must have a type of 'not.v1'", cloudEvent.getType()));
        }
    }

    private static class Publish
    extends CloudEventValidator {
        private Publish() {
        }

        @Override
        public ValidationResult validateSource(CloudEvent cloudEvent) {
            String source = cloudEvent.getSource().toString();
            ValidationResult checkSource = Publish.validateTopicUri(source);
            if (checkSource.isFailure()) {
                return ValidationResult.failure(String.format("Invalid Publish type CloudEvent source [%s]. %s", source, checkSource.getMessage()));
            }
            return ValidationResult.success();
        }

        @Override
        public ValidationResult validateType(CloudEvent cloudEvent) {
            return "pub.v1".equals(cloudEvent.getType()) ? ValidationResult.success() : ValidationResult.failure(String.format("Invalid CloudEvent type [%s]. CloudEvent of type Publish must have a type of 'pub.v1'", cloudEvent.getType()));
        }

        public String toString() {
            return "CloudEventValidator.Publish";
        }
    }

    public static enum Validators {
        PUBLISH(new Publish()),
        NOTIFICATION(new Notification()),
        REQUEST(new Request()),
        RESPONSE(new Response());

        private final CloudEventValidator cloudEventValidator;

        public CloudEventValidator validator() {
            return this.cloudEventValidator;
        }

        private Validators(CloudEventValidator cloudEventValidator) {
            this.cloudEventValidator = cloudEventValidator;
        }
    }
}

