/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uprotocol.rpc;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.eclipse.uprotocol.rpc.RpcResult;
import org.eclipse.uprotocol.v1.UCode;
import org.eclipse.uprotocol.v1.UMessage;
import org.eclipse.uprotocol.v1.UStatus;

public interface RpcMapper {
    public static <T extends Message> CompletionStage<T> mapResponse(CompletionStage<UMessage> responseFuture, Class<T> expectedClazz) {
        return responseFuture.handle((message, exception) -> {
            Any any;
            if (exception != null) {
                throw new CompletionException(exception.getMessage(), (Throwable)exception);
            }
            if (message == null || !message.hasPayload()) {
                throw new RuntimeException("Server returned a null payload. Expected " + expectedClazz.getName());
            }
            try {
                any = Any.parseFrom((ByteString)message.getPayload().getValue());
                if (any.is(expectedClazz)) {
                    return RpcMapper.unpackPayload(any, expectedClazz);
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(String.format("%s [%s]", e.getMessage(), UStatus.class.getName()), e);
            }
            throw new RuntimeException(String.format("Unknown payload type [%s]. Expected [%s]", any.getTypeUrl(), expectedClazz.getName()));
        });
    }

    public static <T extends Message> CompletionStage<RpcResult<T>> mapResponseToResult(CompletionStage<UMessage> responseFuture, Class<T> expectedClazz) {
        return responseFuture.handle((message, exception) -> {
            Any any;
            if (exception != null) {
                return RpcResult.failure(exception.getMessage(), exception);
            }
            if (message == null || !message.hasPayload()) {
                exception = new RuntimeException("Server returned a null payload. Expected " + expectedClazz.getName());
                return RpcResult.failure(exception.getMessage(), exception);
            }
            try {
                any = Any.parseFrom((ByteString)message.getPayload().getValue());
                if (any.is(expectedClazz)) {
                    if (UStatus.class.equals((Object)expectedClazz)) {
                        return RpcMapper.calculateStatusResult(any);
                    }
                    return RpcResult.success(RpcMapper.unpackPayload(any, expectedClazz));
                }
                if (any.is(UStatus.class)) {
                    return RpcMapper.calculateStatusResult(any);
                }
            }
            catch (InvalidProtocolBufferException e) {
                exception = new RuntimeException(String.format("%s [%s]", e.getMessage(), UStatus.class.getName()), e);
                return RpcResult.failure(exception.getMessage(), exception);
            }
            exception = new RuntimeException(String.format("Unknown payload type [%s]. Expected [%s]", any.getTypeUrl(), expectedClazz.getName()));
            return RpcResult.failure(exception.getMessage(), exception);
        });
    }

    private static <T extends Message> RpcResult<T> calculateStatusResult(Any payload) {
        UStatus status = RpcMapper.unpackPayload(payload, UStatus.class);
        return status.getCode() == UCode.OK ? RpcResult.success(status) : RpcResult.failure(status);
    }

    public static <T extends Message> T unpackPayload(Any payload, Class<T> expectedClazz) {
        try {
            return (T)payload.unpack(expectedClazz);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(String.format("%s [%s]", e.getMessage(), UStatus.class.getName()), e);
        }
    }
}

