/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uprotocol.rpc;

import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.uprotocol.v1.UCode;
import org.eclipse.uprotocol.v1.UStatus;

public abstract class RpcResult<T> {
    private RpcResult() {
    }

    public abstract boolean isSuccess();

    public abstract boolean isFailure();

    public abstract T getOrElse(T var1);

    public abstract T getOrElse(Supplier<T> var1);

    public abstract <U> RpcResult<U> map(Function<T, U> var1);

    public abstract <U> RpcResult<U> flatMap(Function<T, RpcResult<U>> var1);

    public abstract RpcResult<T> filter(Function<T, Boolean> var1);

    public abstract UStatus failureValue();

    public abstract T successValue();

    public static <T> RpcResult<T> success(T value) {
        return new Success<T>(value);
    }

    public static <T> RpcResult<T> failure(UStatus value) {
        return new Failure(value);
    }

    public static <T, U> RpcResult<T> failure(Failure<U> failure) {
        return new Failure(failure.value);
    }

    public static <T> RpcResult<T> failure(String message, Throwable e) {
        return new Failure(new IllegalStateException(message, e));
    }

    public static <T> RpcResult<T> failure(UCode code, String message) {
        return new Failure(code, message);
    }

    public static <T> RpcResult<T> flatten(RpcResult<RpcResult<T>> result) {
        return result.flatMap(x -> x);
    }

    private static class Failure<T>
    extends RpcResult<T> {
        private final UStatus value;

        private Failure(UStatus value) {
            this.value = value;
        }

        private Failure(UCode code, String message) {
            this.value = UStatus.newBuilder().setCode(code).setMessage(message).build();
        }

        private Failure(Exception e) {
            this.value = UStatus.newBuilder().setCode(UCode.UNKNOWN).setMessage(e.getMessage()).build();
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public T getOrElse(T defaultValue) {
            return defaultValue;
        }

        @Override
        public T getOrElse(Supplier<T> defaultValue) {
            return defaultValue.get();
        }

        @Override
        public <U> RpcResult<U> map(Function<T, U> f) {
            return Failure.failure(this);
        }

        @Override
        public <U> RpcResult<U> flatMap(Function<T, RpcResult<U>> f) {
            return Failure.failure(this.failureValue());
        }

        @Override
        public RpcResult<T> filter(Function<T, Boolean> f) {
            return Failure.failure(this);
        }

        @Override
        public UStatus failureValue() {
            return this.value;
        }

        @Override
        public T successValue() {
            throw new IllegalStateException("Method successValue() called on a Failure instance");
        }

        public String toString() {
            return String.format("Failure(%s)", this.value);
        }
    }

    private static class Success<T>
    extends RpcResult<T> {
        private final T value;

        private Success(T value) {
            this.value = value;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        @Override
        public T getOrElse(T defaultValue) {
            return this.successValue();
        }

        @Override
        public T getOrElse(Supplier<T> defaultValue) {
            return this.successValue();
        }

        @Override
        public <U> RpcResult<U> map(Function<T, U> f) {
            try {
                return Success.success(f.apply(this.successValue()));
            }
            catch (Exception e) {
                return Success.failure(e.getMessage(), e);
            }
        }

        @Override
        public <U> RpcResult<U> flatMap(Function<T, RpcResult<U>> f) {
            try {
                return f.apply(this.successValue());
            }
            catch (Exception e) {
                return Success.failure(e.getMessage(), e);
            }
        }

        @Override
        public RpcResult<T> filter(Function<T, Boolean> f) {
            try {
                return f.apply(this.successValue()) != false ? this : Success.failure(UCode.FAILED_PRECONDITION, "filtered out");
            }
            catch (Exception e) {
                return Success.failure(e.getMessage(), e);
            }
        }

        @Override
        public UStatus failureValue() {
            throw new IllegalStateException("Method failureValue() called on a Success instance");
        }

        @Override
        public T successValue() {
            return this.value;
        }

        public String toString() {
            return String.format("Success(%s)", this.successValue().toString());
        }
    }
}

