/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uprotocol.transport.builder;

import java.util.Objects;
import org.eclipse.uprotocol.uuid.factory.UuidFactory;
import org.eclipse.uprotocol.v1.UAttributes;
import org.eclipse.uprotocol.v1.UCode;
import org.eclipse.uprotocol.v1.UMessageType;
import org.eclipse.uprotocol.v1.UPriority;
import org.eclipse.uprotocol.v1.UUID;
import org.eclipse.uprotocol.v1.UUri;

public class UAttributesBuilder {
    private final UUri source;
    private final UUID id;
    private final UMessageType type;
    private final UPriority priority;
    private Integer ttl;
    private String token;
    private UUri sink;
    private Integer plevel;
    private UCode commstatus;
    private UUID reqid;
    private String traceparent;

    public static UAttributesBuilder publish(UUri source, UPriority priority) {
        Objects.requireNonNull(source, "source cannot be null.");
        Objects.requireNonNull(priority, "UPriority cannot be null.");
        return new UAttributesBuilder(source, UuidFactory.Factories.UPROTOCOL.factory().create(), UMessageType.UMESSAGE_TYPE_PUBLISH, priority);
    }

    public static UAttributesBuilder notification(UUri source, UUri sink, UPriority priority) {
        Objects.requireNonNull(source, "source cannot be null.");
        Objects.requireNonNull(priority, "UPriority cannot be null.");
        Objects.requireNonNull(sink, "sink cannot be null.");
        return new UAttributesBuilder(source, UuidFactory.Factories.UPROTOCOL.factory().create(), UMessageType.UMESSAGE_TYPE_NOTIFICATION, priority).withSink(sink);
    }

    public static UAttributesBuilder request(UUri source, UUri sink, UPriority priority, Integer ttl) {
        Objects.requireNonNull(source, "source cannot be null.");
        Objects.requireNonNull(priority, "UPriority cannot be null.");
        Objects.requireNonNull(ttl, "ttl cannot be null.");
        Objects.requireNonNull(sink, "sink cannot be null.");
        return new UAttributesBuilder(source, UuidFactory.Factories.UPROTOCOL.factory().create(), UMessageType.UMESSAGE_TYPE_REQUEST, priority).withTtl(ttl).withSink(sink);
    }

    public static UAttributesBuilder response(UUri source, UUri sink, UPriority priority, UUID reqid) {
        Objects.requireNonNull(source, "source cannot be null.");
        Objects.requireNonNull(priority, "UPriority cannot be null.");
        Objects.requireNonNull(sink, "sink cannot be null.");
        Objects.requireNonNull(reqid, "reqid cannot be null.");
        return new UAttributesBuilder(source, UuidFactory.Factories.UPROTOCOL.factory().create(), UMessageType.UMESSAGE_TYPE_RESPONSE, priority).withSink(sink).withReqId(reqid);
    }

    public static UAttributesBuilder response(UAttributes request) {
        Objects.requireNonNull(request, "request cannot be null.");
        return UAttributesBuilder.response(request.getSink(), request.getSource(), request.getPriority(), request.getId());
    }

    private UAttributesBuilder(UUri source, UUID id, UMessageType type, UPriority priority) {
        this.source = source;
        this.id = id;
        this.type = type;
        this.priority = priority;
    }

    public UAttributesBuilder withTtl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public UAttributesBuilder withToken(String token) {
        this.token = token;
        return this;
    }

    public UAttributesBuilder withSink(UUri sink) {
        this.sink = sink;
        return this;
    }

    public UAttributesBuilder withPermissionLevel(Integer plevel) {
        this.plevel = plevel;
        return this;
    }

    public UAttributesBuilder withCommStatus(UCode commstatus) {
        this.commstatus = commstatus;
        return this;
    }

    public UAttributesBuilder withReqId(UUID reqid) {
        this.reqid = reqid;
        return this;
    }

    public UAttributesBuilder withTraceparent(String traceparent) {
        this.traceparent = traceparent;
        return this;
    }

    public UAttributes build() {
        UAttributes.Builder attributesBuilder = UAttributes.newBuilder().setSource(this.source).setId(this.id).setType(this.type).setPriority(this.priority);
        if (this.sink != null) {
            attributesBuilder.setSink(this.sink);
        }
        if (this.ttl != null) {
            attributesBuilder.setTtl(this.ttl);
        }
        if (this.plevel != null) {
            attributesBuilder.setPermissionLevel(this.plevel);
        }
        if (this.commstatus != null) {
            attributesBuilder.setCommstatus(this.commstatus);
        }
        if (this.reqid != null) {
            attributesBuilder.setReqid(this.reqid);
        }
        if (this.token != null) {
            attributesBuilder.setToken(this.token);
        }
        if (this.traceparent != null) {
            attributesBuilder.setTraceparent(this.traceparent);
        }
        return attributesBuilder.build();
    }
}

