/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uprotocol.transport.builder;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.Optional;
import org.eclipse.uprotocol.v1.UPayload;
import org.eclipse.uprotocol.v1.UPayloadFormat;

public interface UPayloadBuilder {
    public static UPayload packToAny(Message message) {
        return UPayload.newBuilder().setFormat(UPayloadFormat.UPAYLOAD_FORMAT_PROTOBUF_WRAPPED_IN_ANY).setValue(Any.pack((Message)message).toByteString()).build();
    }

    public static UPayload pack(Message message) {
        return UPayload.newBuilder().setFormat(UPayloadFormat.UPAYLOAD_FORMAT_PROTOBUF).setValue(message.toByteString()).build();
    }

    public static <T extends Message> Optional<T> unpack(UPayload payload, Class<T> clazz) {
        if (payload == null || !payload.hasValue()) {
            return Optional.empty();
        }
        try {
            switch (payload.getFormat()) {
                case UPAYLOAD_FORMAT_UNSPECIFIED: 
                case UPAYLOAD_FORMAT_PROTOBUF_WRAPPED_IN_ANY: {
                    return Optional.of(Any.parseFrom((ByteString)payload.getValue()).unpack(clazz));
                }
                case UPAYLOAD_FORMAT_PROTOBUF: {
                    Message defaultInstance = (Message)Internal.getDefaultInstance(clazz);
                    return Optional.of((Message)defaultInstance.getParserForType().parseFrom(payload.getValue()));
                }
            }
            return Optional.empty();
        }
        catch (InvalidProtocolBufferException e) {
            return Optional.empty();
        }
    }
}

