/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uprotocol.transport.validate;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.uprotocol.uri.validator.UriValidator;
import org.eclipse.uprotocol.uuid.factory.UuidUtils;
import org.eclipse.uprotocol.v1.UAttributes;
import org.eclipse.uprotocol.v1.UMessageType;
import org.eclipse.uprotocol.v1.UUID;
import org.eclipse.uprotocol.v1.UUri;
import org.eclipse.uprotocol.validation.ValidationResult;

public abstract class UAttributesValidator {
    public static UAttributesValidator getValidator(UAttributes attribute) {
        switch (attribute.getType()) {
            case UMESSAGE_TYPE_RESPONSE: {
                return Validators.RESPONSE.validator();
            }
            case UMESSAGE_TYPE_REQUEST: {
                return Validators.REQUEST.validator();
            }
            case UMESSAGE_TYPE_NOTIFICATION: {
                return Validators.NOTIFICATION.validator();
            }
        }
        return Validators.PUBLISH.validator();
    }

    public ValidationResult validate(UAttributes attributes) {
        String errorMessage = Stream.of(this.validateType(attributes), this.validateTtl(attributes), this.validateSink(attributes), this.validatePriority(attributes), this.validatePermissionLevel(attributes), this.validateReqId(attributes)).filter(ValidationResult::isFailure).map(ValidationResult::getMessage).collect(Collectors.joining(","));
        return errorMessage.isBlank() ? ValidationResult.success() : ValidationResult.failure(errorMessage);
    }

    public boolean isExpired(UAttributes uAttributes) {
        int ttl = uAttributes.getTtl();
        Optional<Long> maybeTime = UuidUtils.getTime(uAttributes.getId());
        if (maybeTime.isEmpty() || ttl <= 0) {
            return false;
        }
        return maybeTime.get() + (long)ttl < System.currentTimeMillis();
    }

    public ValidationResult validateTtl(UAttributes attributes) {
        int ttl = attributes.getTtl();
        if (attributes.hasTtl() && ttl <= 0) {
            return ValidationResult.failure(String.format("Invalid TTL [%s]", ttl));
        }
        return ValidationResult.success();
    }

    public ValidationResult validateSink(UAttributes attributes) {
        if (attributes.hasSink()) {
            return UriValidator.validate(attributes.getSink());
        }
        return ValidationResult.success();
    }

    public ValidationResult validatePermissionLevel(UAttributes attributes) {
        if (!attributes.hasPermissionLevel() || attributes.getPermissionLevel() > 0) {
            return ValidationResult.success();
        }
        return ValidationResult.failure("Invalid Permission Level");
    }

    public ValidationResult validateReqId(UAttributes attributes) {
        if (attributes.hasReqid() && !UuidUtils.isUuid(attributes.getReqid())) {
            return ValidationResult.failure("Invalid UUID");
        }
        return ValidationResult.success();
    }

    public ValidationResult validatePriority(UAttributes attributes) {
        return attributes.getPriority().getNumber() >= 1 ? ValidationResult.success() : ValidationResult.failure(String.format("Invalid UPriority [%s]", attributes.getPriority().name()));
    }

    public abstract ValidationResult validateType(UAttributes var1);

    private static class Notification
    extends UAttributesValidator {
        private Notification() {
        }

        @Override
        public ValidationResult validateType(UAttributes attributes) {
            return UMessageType.UMESSAGE_TYPE_NOTIFICATION == attributes.getType() ? ValidationResult.success() : ValidationResult.failure(String.format("Wrong Attribute Type [%s]", new Object[]{attributes.getType()}));
        }

        @Override
        public ValidationResult validateSink(UAttributes attributes) {
            Objects.requireNonNull(attributes, "UAttributes cannot be null.");
            if (!attributes.hasSink() || attributes.getSink() == UUri.getDefaultInstance()) {
                return ValidationResult.failure("Missing Sink");
            }
            return ValidationResult.success();
        }

        public String toString() {
            return "UAttributesValidator.Notification";
        }
    }

    private static class Response
    extends UAttributesValidator {
        private Response() {
        }

        @Override
        public ValidationResult validateType(UAttributes attributes) {
            return UMessageType.UMESSAGE_TYPE_RESPONSE == attributes.getType() ? ValidationResult.success() : ValidationResult.failure(String.format("Wrong Attribute Type [%s]", new Object[]{attributes.getType()}));
        }

        @Override
        public ValidationResult validateSink(UAttributes attributes) {
            Objects.requireNonNull(attributes, "UAttributes cannot be null.");
            if (!attributes.hasSink() || attributes.getSink() == UUri.getDefaultInstance()) {
                return ValidationResult.failure("Missing Sink");
            }
            ValidationResult result = UriValidator.validateRpcResponse(attributes.getSink());
            return result;
        }

        @Override
        public ValidationResult validateReqId(UAttributes attributes) {
            if (!attributes.hasReqid() || attributes.getReqid() == UUID.getDefaultInstance()) {
                return ValidationResult.failure("Missing correlationId");
            }
            if (!UuidUtils.isUuid(attributes.getReqid())) {
                return ValidationResult.failure(String.format("Invalid correlationId [%s]", attributes.getReqid()));
            }
            return ValidationResult.success();
        }

        @Override
        public ValidationResult validatePriority(UAttributes attributes) {
            return attributes.getPriority().getNumber() >= 5 ? ValidationResult.success() : ValidationResult.failure(String.format("Invalid UPriority [%s]", attributes.getPriority().name()));
        }

        public String toString() {
            return "UAttributesValidator.Response";
        }
    }

    private static class Request
    extends UAttributesValidator {
        private Request() {
        }

        @Override
        public ValidationResult validateType(UAttributes attributes) {
            return UMessageType.UMESSAGE_TYPE_REQUEST == attributes.getType() ? ValidationResult.success() : ValidationResult.failure(String.format("Wrong Attribute Type [%s]", new Object[]{attributes.getType()}));
        }

        @Override
        public ValidationResult validateSink(UAttributes attributes) {
            if (!attributes.hasSink()) {
                return ValidationResult.failure("Missing Sink");
            }
            return UriValidator.validateRpcMethod(attributes.getSink());
        }

        @Override
        public ValidationResult validateTtl(UAttributes attributes) {
            if (!attributes.hasTtl()) {
                return ValidationResult.failure("Missing TTL");
            }
            int ttl = attributes.getTtl();
            if (ttl <= 0) {
                return ValidationResult.failure(String.format("Invalid TTL [%s]", ttl));
            }
            return ValidationResult.success();
        }

        @Override
        public ValidationResult validatePriority(UAttributes attributes) {
            return attributes.getPriority().getNumber() >= 5 ? ValidationResult.success() : ValidationResult.failure(String.format("Invalid UPriority [%s]", attributes.getPriority().name()));
        }

        public String toString() {
            return "UAttributesValidator.Request";
        }
    }

    private static class Publish
    extends UAttributesValidator {
        private Publish() {
        }

        @Override
        public ValidationResult validateType(UAttributes attributes) {
            return UMessageType.UMESSAGE_TYPE_PUBLISH == attributes.getType() ? ValidationResult.success() : ValidationResult.failure(String.format("Wrong Attribute Type [%s]", new Object[]{attributes.getType()}));
        }

        public String toString() {
            return "UAttributesValidator.Publish";
        }
    }

    public static enum Validators {
        PUBLISH(new Publish()),
        REQUEST(new Request()),
        RESPONSE(new Response()),
        NOTIFICATION(new Notification());

        private final UAttributesValidator uattributesValidator;

        private Validators(UAttributesValidator uattributesValidator) {
            this.uattributesValidator = uattributesValidator;
        }

        public UAttributesValidator validator() {
            return this.uattributesValidator;
        }
    }
}

